/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.dml;

import com.mysema.query.QueryException;
import com.mysema.query.dml.StoreClause;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.sql.SQLQueryImpl;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.dml.AbstractSQLClause;
import com.mysema.query.sql.dml.SQLInsertClause;
import com.mysema.query.sql.dml.SQLUpdateClause;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQuery;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.path.NullExpr;
import com.mysema.query.types.path.PEntity;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
public class SQLMergeClause
extends AbstractSQLClause
implements StoreClause<SQLMergeClause> {
    private static final Logger logger = LoggerFactory.getLogger(SQLMergeClause.class);
    private final List<Path<?>> columns = new ArrayList();
    private final Connection connection;
    private final PEntity<?> entity;
    private final List<Path<?>> keys = new ArrayList();
    @Nullable
    private SubQuery<?> subQuery;
    private final List<Expr<?>> values = new ArrayList();

    public SQLMergeClause(Connection connection, SQLTemplates templates, PEntity<?> entity) {
        this(connection, new Configuration(templates), entity);
    }

    public SQLMergeClause(Connection connection, Configuration configuration, PEntity<?> entity) {
        super(configuration);
        this.connection = connection;
        this.entity = entity;
    }

    protected void close(PreparedStatement stmt) {
        try {
            stmt.close();
        }
        catch (SQLException e) {
            throw new QueryException((Throwable)e);
        }
    }

    public long execute() {
        if (this.configuration.getTemplates().isNativeMerge()) {
            return this.executeNativeMerge();
        }
        return this.executeCompositeMerge();
    }

    private long executeCompositeMerge() {
        SQLQuery query = (SQLQuery)new SQLQueryImpl(this.connection, this.configuration.getTemplates()).from((Expr<?>[])new Expr[]{this.entity});
        for (int i = 0; i < this.columns.size(); ++i) {
            if (this.values.get(i) instanceof NullExpr) {
                query.where(new EBoolean[]{this.columns.get(i).isNull()});
                continue;
            }
            query.where(new EBoolean[]{this.columns.get(i).asExpr().eq(this.values.get(i))});
        }
        List ids = query.list(this.keys.get(0).asExpr());
        if (!ids.isEmpty()) {
            SQLUpdateClause update = new SQLUpdateClause(this.connection, this.configuration.getTemplates(), this.entity);
            this.populate((StoreClause<?>)update);
            update.where(this.keys.get(0).asExpr().in((Collection)ids));
            return update.execute();
        }
        SQLInsertClause insert = new SQLInsertClause(this.connection, this.configuration.getTemplates(), this.entity);
        this.populate((StoreClause<?>)insert);
        return insert.execute();
    }

    private void populate(StoreClause<?> clause) {
        for (int i = 0; i < this.columns.size(); ++i) {
            clause.set(this.columns.get(i), this.values.get(i));
        }
    }

    private long executeNativeMerge() {
        SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
        serializer.serializeForMerge(this.entity, this.keys, this.columns, this.values, this.subQuery);
        String queryString = serializer.toString();
        logger.debug(queryString);
        PreparedStatement stmt = null;
        try {
            stmt = this.connection.prepareStatement(queryString);
            this.setParameters(stmt, serializer.getConstants(), Collections.emptyMap());
            long l = stmt.executeUpdate();
            return l;
        }
        catch (SQLException e) {
            throw new QueryException("Caught " + e.getClass().getSimpleName() + " for " + queryString, (Throwable)e);
        }
        finally {
            if (stmt != null) {
                this.close(stmt);
            }
        }
    }

    public SQLMergeClause keys(Path<?> ... paths) {
        for (Path<?> path : paths) {
            this.keys.add(path);
        }
        return this;
    }

    public SQLMergeClause select(SubQuery<?> subQuery) {
        this.subQuery = subQuery;
        return this;
    }

    public <T> SQLMergeClause set(Path<T> path, @Nullable T value) {
        this.columns.add(path);
        if (value != null) {
            this.values.add(ExprConst.create(value));
        } else {
            this.values.add((Expr<?>)new NullExpr(path.getType()));
        }
        return this;
    }

    public String toString() {
        SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
        serializer.serializeForMerge(this.entity, this.keys, this.columns, this.values, this.subQuery);
        return serializer.toString();
    }

    public SQLMergeClause values(Object ... v) {
        for (Object value : v) {
            if (value instanceof Expr) {
                this.values.add((Expr)value);
                continue;
            }
            if (value != null) {
                this.values.add(ExprConst.create((Object)value));
                continue;
            }
            this.values.add((Expr<?>)NullExpr.DEFAULT);
        }
        return this;
    }
}

