/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.dml;

import com.mysema.query.BooleanBuilder;
import com.mysema.query.QueryException;
import com.mysema.query.dml.DeleteClause;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.dml.AbstractSQLClause;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.path.PEntity;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
public class SQLDeleteClause
extends AbstractSQLClause
implements DeleteClause<SQLDeleteClause> {
    private static final Logger logger = LoggerFactory.getLogger(SQLDeleteClause.class);
    private final Connection connection;
    private final PEntity<?> entity;
    private final BooleanBuilder where = new BooleanBuilder();

    public SQLDeleteClause(Connection connection, SQLTemplates templates, PEntity<?> entity) {
        this(connection, new Configuration(templates), entity);
    }

    public SQLDeleteClause(Connection connection, Configuration configuration, PEntity<?> entity) {
        super(configuration);
        this.connection = connection;
        this.entity = entity;
    }

    protected void close(PreparedStatement stmt) {
        try {
            stmt.close();
        }
        catch (SQLException e) {
            throw new QueryException((Throwable)e);
        }
    }

    public long execute() {
        SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
        serializer.serializeForDelete(this.entity, this.where.getValue());
        String queryString = serializer.toString();
        logger.debug(queryString);
        PreparedStatement stmt = null;
        try {
            stmt = this.connection.prepareStatement(queryString);
            this.setParameters(stmt, serializer.getConstants(), Collections.emptyMap());
            long l = stmt.executeUpdate();
            return l;
        }
        catch (SQLException e) {
            throw new QueryException("Caught " + e.getClass().getSimpleName() + " for " + queryString, (Throwable)e);
        }
        finally {
            if (stmt != null) {
                this.close(stmt);
            }
        }
    }

    public SQLDeleteClause where(EBoolean ... o) {
        for (EBoolean e : o) {
            this.where.and(e);
        }
        return this;
    }

    public String toString() {
        SQLSerializer serializer = new SQLSerializer(this.configuration.getTemplates(), true);
        serializer.serializeForDelete(this.entity, this.where.getValue());
        return serializer.toString();
    }
}

