/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.commons.lang.Pair;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryException;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.serialization.SerializerBase;
import com.mysema.query.sql.PrimaryKey;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.SerializationContext;
import com.mysema.query.sql.Table;
import com.mysema.query.types.Constant;
import com.mysema.query.types.EConstructor;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Order;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Param;
import com.mysema.query.types.Path;
import com.mysema.query.types.SubQuery;
import com.mysema.query.types.Templates;
import com.mysema.query.types.custom.CSimple;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.expr.ExprConst;
import com.mysema.query.types.path.PEntity;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class SQLSerializer
extends SerializerBase<SQLSerializer> {
    private final SerializationContext context = new SerializationContext(){

        @Override
        public void serialize(QueryMetadata metadata, boolean forCountRow) {
            SQLSerializer.this.serializeForQuery(metadata, forCountRow);
        }

        @Override
        public SerializationContext append(String str) {
            SQLSerializer.this.append(new String[]{str});
            return this;
        }

        @Override
        public void handle(String template, Object ... args) {
            Expr[] exprs = new Expr[args.length];
            for (int i = 0; i < args.length; ++i) {
                exprs[i] = ExprConst.create((Object)args[i]);
            }
            SQLSerializer.this.handle(CSimple.create(Object.class, (String)template, (Expr[])exprs));
        }
    };
    private static final String COMMA = ", ";
    private final List<Object> constants = new ArrayList<Object>();
    private final boolean dml;
    private boolean skipParent;
    private PEntity<?> entity;
    private final SQLTemplates templates;

    public SQLSerializer(SQLTemplates templates) {
        this(templates, false);
    }

    public SQLSerializer(SQLTemplates templates, boolean dml) {
        super((Templates)templates);
        this.templates = templates;
        this.dml = dml;
    }

    private void appendAsColumnName(Path<?> path) {
        String column = path.getMetadata().getExpression().toString();
        this.append(new String[]{this.templates.quoteColumnName(column)});
    }

    private void appendAsTableName(Path<?> path) {
        String table = path.getAnnotatedElement().getAnnotation(Table.class).value();
        this.append(new String[]{this.templates.quoteTableName(table)});
    }

    public List<Object> getConstants() {
        return this.constants;
    }

    private List<Expr<?>> getIdentifierColumns(List<JoinExpression> joins) {
        try {
            ArrayList columns = new ArrayList();
            for (JoinExpression j : joins) {
                for (Field field : j.getTarget().getClass().getFields()) {
                    if (!PrimaryKey.class.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    columns.addAll(((PrimaryKey)field.get(j.getTarget())).getLocalColumns());
                }
            }
            return columns;
        }
        catch (IllegalArgumentException e) {
            throw new QueryException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new QueryException((Throwable)e);
        }
    }

    protected SQLTemplates getTemplates() {
        return this.templates;
    }

    private void handleJoinTarget(JoinExpression je) {
        PEntity pe;
        if (je.getTarget() instanceof PEntity && this.templates.isSupportsAlias() && (pe = (PEntity)je.getTarget()).getMetadata().getParent() == null) {
            this.appendAsTableName((Path<?>)pe);
            this.append(new String[]{this.templates.getTableAlias()});
        }
        this.handle(je.getTarget());
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow) {
        this.templates.serialize(metadata, forCountRow, this.context);
    }

    private void serializeForQuery(QueryMetadata metadata, boolean forCountRow) {
        List select = metadata.getProjection();
        List joins = metadata.getJoins();
        EBoolean where = metadata.getWhere();
        List groupBy = metadata.getGroupBy();
        EBoolean having = metadata.getHaving();
        List orderBy = metadata.getOrderBy();
        Set flags = metadata.getFlags();
        ArrayList<Expr> sqlSelect = new ArrayList<Expr>();
        for (Expr selectExpr : select) {
            if (selectExpr instanceof EConstructor) {
                sqlSelect.addAll(((EConstructor)selectExpr).getArgs());
                continue;
            }
            sqlSelect.add(selectExpr);
        }
        this.serialize(QueryFlag.Position.START, flags);
        if (forCountRow) {
            this.append(new String[]{this.templates.getSelect()});
            this.serialize(QueryFlag.Position.AFTER_SELECT, flags);
            if (!metadata.isDistinct()) {
                this.append(new String[]{this.templates.getCountStar()});
            } else {
                this.append(new String[]{this.templates.getDistinctCountStart()});
                if (sqlSelect.isEmpty()) {
                    this.handle(this.getIdentifierColumns(joins).get(0));
                } else {
                    this.handle(COMMA, sqlSelect);
                }
                this.append(new String[]{this.templates.getDistinctCountEnd()});
            }
        } else if (!sqlSelect.isEmpty()) {
            if (!metadata.isDistinct()) {
                this.append(new String[]{this.templates.getSelect()});
            } else {
                this.append(new String[]{this.templates.getSelectDistinct()});
            }
            this.serialize(QueryFlag.Position.AFTER_SELECT, flags);
            this.handle(COMMA, sqlSelect);
        }
        this.serialize(QueryFlag.Position.AFTER_PROJECTION, flags);
        this.serializeSources(joins);
        this.serialize(QueryFlag.Position.BEFORE_FILTERS, flags);
        if (where != null) {
            ((SQLSerializer)this.append(new String[]{this.templates.getWhere()})).handle((Expr)where);
            this.serialize(QueryFlag.Position.AFTER_FILTERS, flags);
        }
        this.serialize(QueryFlag.Position.BEFORE_GROUP_BY, flags);
        if (!groupBy.isEmpty()) {
            ((SQLSerializer)this.append(new String[]{this.templates.getGroupBy()})).handle(COMMA, groupBy);
            this.serialize(QueryFlag.Position.AFTER_GROUP_BY, flags);
        }
        this.serialize(QueryFlag.Position.BEFORE_HAVING, flags);
        if (having != null) {
            if (groupBy.isEmpty()) {
                throw new IllegalArgumentException("having, but not groupBy was given");
            }
            ((SQLSerializer)this.append(new String[]{this.templates.getHaving()})).handle((Expr)having);
            this.serialize(QueryFlag.Position.AFTER_HAVING, flags);
        }
        this.serialize(QueryFlag.Position.BEFORE_ORDER, flags);
        if (!orderBy.isEmpty() && !forCountRow) {
            this.append(new String[]{this.templates.getOrderBy()});
            boolean first = true;
            for (OrderSpecifier os : orderBy) {
                if (!first) {
                    this.append(new String[]{COMMA});
                }
                this.handle(os.getTarget());
                this.append(new String[]{os.getOrder() == Order.ASC ? this.templates.getAsc() : this.templates.getDesc()});
                first = false;
            }
            this.serialize(QueryFlag.Position.AFTER_ORDER, flags);
        }
        this.serialize(QueryFlag.Position.END, flags);
    }

    public void serializeForDelete(PEntity<?> entity, EBoolean where) {
        this.entity = entity;
        this.append(new String[]{this.templates.getDeleteFrom()});
        this.handle((Expr)entity);
        if (where != null) {
            this.skipParent = true;
            ((SQLSerializer)this.append(new String[]{this.templates.getWhere()})).handle((Expr)where);
            this.skipParent = false;
        }
    }

    public void serializeForMerge(PEntity<?> entity, List<Path<?>> keys, List<Path<?>> columns, List<Expr<?>> values, @Nullable SubQuery<?> subQuery) {
        this.entity = entity;
        this.append(new String[]{this.templates.getMergeInto()});
        this.handle((Expr)entity);
        this.append(new String[]{" "});
        if (!columns.isEmpty()) {
            this.skipParent = true;
            ((SQLSerializer)((SQLSerializer)this.append(new String[]{"("})).handle(COMMA, columns)).append(new String[]{") "});
            this.skipParent = false;
        }
        if (!keys.isEmpty()) {
            this.append(new String[]{this.templates.getKey()});
            this.skipParent = true;
            ((SQLSerializer)((SQLSerializer)this.append(new String[]{"("})).handle(COMMA, keys)).append(new String[]{") "});
            this.skipParent = false;
        }
        if (subQuery != null) {
            this.append(new String[]{"\n"});
            this.serialize(subQuery.getMetadata(), false);
        } else {
            this.append(new String[]{this.templates.getValues()});
            ((SQLSerializer)((SQLSerializer)this.append(new String[]{"("})).handle(COMMA, values)).append(new String[]{") "});
        }
    }

    public void serializeForInsert(PEntity<?> entity, List<Path<?>> columns, List<Expr<?>> values, @Nullable SubQuery<?> subQuery) {
        this.entity = entity;
        this.append(new String[]{this.templates.getInsertInto()});
        this.handle((Expr)entity);
        if (!columns.isEmpty()) {
            this.append(new String[]{"("});
            this.skipParent = true;
            this.handle(COMMA, columns);
            this.skipParent = false;
            this.append(new String[]{")"});
        }
        if (subQuery != null) {
            this.append(new String[]{"\n"});
            this.serialize(subQuery.getMetadata(), false);
        } else {
            this.append(new String[]{this.templates.getValues()});
            this.append(new String[]{"("});
            this.handle(COMMA, values);
            this.append(new String[]{")"});
        }
    }

    public void serializeForUpdate(PEntity<?> entity, List<Pair<Path<?>, ?>> updates, EBoolean where) {
        this.entity = entity;
        this.append(new String[]{this.templates.getUpdate()});
        this.handle((Expr)entity);
        this.append(new String[]{"\n"});
        this.append(new String[]{this.templates.getSet()});
        boolean first = true;
        this.skipParent = true;
        for (Pair<Path<?>, ?> update : updates) {
            if (!first) {
                this.append(new String[]{COMMA});
            }
            this.handle(((Path)update.getFirst()).asExpr());
            this.append(new String[]{" = "});
            if (update.getSecond() instanceof Expr) {
                this.handle((Expr)update.getSecond());
            } else {
                this.handle(ExprConst.create((Object)update.getSecond()));
            }
            first = false;
        }
        this.skipParent = false;
        if (where != null) {
            ((SQLSerializer)this.append(new String[]{this.templates.getWhere()})).handle((Expr)where);
        }
    }

    private void serializeSources(List<JoinExpression> joins) {
        if (joins.isEmpty()) {
            String dummyTable = this.templates.getDummyTable();
            if (!StringUtils.isEmpty((String)dummyTable)) {
                this.append(new String[]{this.templates.getFrom()});
                this.append(new String[]{dummyTable});
            }
        } else {
            this.append(new String[]{this.templates.getFrom()});
            for (int i = 0; i < joins.size(); ++i) {
                JoinExpression je = joins.get(i);
                if (i > 0) {
                    this.append(new String[]{this.templates.getJoinSymbol(je.getType())});
                }
                this.handleJoinTarget(je);
                if (je.getCondition() != null) {
                    ((SQLSerializer)this.append(new String[]{this.templates.getOn()})).handle((Expr)je.getCondition());
                }
                for (JoinFlag flag : je.getFlags()) {
                    this.append(new String[]{flag.toString()});
                }
            }
        }
    }

    public void serializeUnion(SubQuery[] sqs, List<OrderSpecifier<?>> orderBy) {
        this.handle(this.templates.getUnion(), Arrays.asList(sqs));
        if (!orderBy.isEmpty()) {
            this.append(new String[]{this.templates.getOrderBy()});
            boolean first = true;
            for (OrderSpecifier<?> os : orderBy) {
                if (!first) {
                    this.append(new String[]{COMMA});
                }
                this.handle(os.getTarget());
                this.append(new String[]{os.getOrder() == Order.ASC ? this.templates.getAsc() : this.templates.getDesc()});
                first = false;
            }
        }
    }

    public void visit(Constant<?> expr) {
        if (expr.getConstant() instanceof Collection) {
            this.append(new String[]{"("});
            boolean first = true;
            for (Object o : (Collection)expr.getConstant()) {
                if (!first) {
                    this.append(new String[]{COMMA});
                }
                this.append(new String[]{"?"});
                this.constants.add(o);
                first = false;
            }
            this.append(new String[]{")"});
        } else {
            this.append(new String[]{"?"});
            this.constants.add(expr.getConstant());
        }
    }

    public void visit(Param<?> param) {
        this.append(new String[]{"?"});
        this.constants.add(param);
    }

    public void visit(Path<?> path) {
        if (this.dml) {
            if (path.equals(this.entity)) {
                this.appendAsTableName(path);
            } else if (this.entity.equals((Object)path.getMetadata().getParent()) && this.skipParent) {
                this.appendAsColumnName(path);
            } else {
                super.visit(path);
            }
        } else {
            super.visit(path);
        }
    }

    public void visit(SubQuery<?> query) {
        this.append(new String[]{"("});
        this.serialize(query.getMetadata(), false);
        this.append(new String[]{")"});
    }

    protected void visitOperation(Class<?> type, Operator<?> operator, List<Expr<?>> args) {
        if (operator.equals((Object)Ops.STRING_CAST)) {
            String typeName = this.templates.getTypeForClass(String.class);
            this.visitOperation(String.class, SQLTemplates.CAST, Arrays.asList(args.get(0), ExprConst.create((Object)typeName)));
        } else if (operator.equals((Object)Ops.NUMCAST)) {
            Class targetType = (Class)((Constant)args.get(1)).getConstant();
            String typeName = this.templates.getTypeForClass(targetType);
            this.visitOperation(targetType, SQLTemplates.CAST, Arrays.asList(args.get(0), ExprConst.create((Object)typeName)));
        } else {
            super.visitOperation(type, operator, args);
        }
    }
}

