/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Ops;

public class PostgresTemplates
extends SQLTemplates {
    public PostgresTemplates() {
        this(false);
    }

    public PostgresTemplates(boolean quote) {
        super(quote ? "\"" : null);
        this.addClass2TypeMappings("numeric(3,0)", Byte.class);
        this.addClass2TypeMappings("double precision", Double.class);
        this.add(Ops.CONCAT, "{0} || {1}");
        this.add(Ops.MATCHES, "{0} ~ {1}");
        this.add(Ops.INDEX_OF, "strpos({0},{1})-1");
        this.add(Ops.INDEX_OF_2ARGS, "strpos({0},{1})-1");
        this.add(Ops.MathOps.RANDOM, "random()");
        this.add(Ops.MathOps.LOG, "ln({0})");
        this.add(Ops.MathOps.LOG10, "log({0})");
        this.add(Ops.DateTimeOps.YEAR, "extract(year from {0})");
        this.add(Ops.DateTimeOps.YEAR_MONTH, "extract(year from {0}) * 100 + extract(month from {0})");
        this.add(Ops.DateTimeOps.MONTH, "extract(month from {0})");
        this.add(Ops.DateTimeOps.WEEK, "extract(week from {0})");
        this.add(Ops.DateTimeOps.DAY_OF_MONTH, "extract(day from {0})");
        this.add(Ops.DateTimeOps.DAY_OF_WEEK, "extract(dow from {0}) + 1");
        this.add(Ops.DateTimeOps.DAY_OF_YEAR, "extract(doy from {0})");
        this.add(Ops.DateTimeOps.HOUR, "extract(hour from {0})");
        this.add(Ops.DateTimeOps.MINUTE, "extract(minute from {0})");
        this.add(Ops.DateTimeOps.SECOND, "extract(second from {0})");
    }
}

