/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.JavaWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.Types;
import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Method;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SimpleSerializerConfig;
import com.mysema.query.sql.ColumnImpl;
import com.mysema.query.sql.NamingStrategy;
import com.mysema.query.sql.SQLTypeMapping;
import com.mysema.query.sql.TableImpl;
import com.mysema.query.sql.support.ForeignKeyData;
import com.mysema.query.sql.support.InverseForeignKeyData;
import com.mysema.query.sql.support.KeyDataFactory;
import com.mysema.query.sql.support.PrimaryKeyData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataExporter {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataExporter.class);
    private static final int COLUMN_NAME = 4;
    private static final int COLUMN_TYPE = 5;
    private static final int TABLE_NAME = 3;
    private Set<String> classes = new HashSet<String>();
    private final File targetFolder;
    private final String packageName;
    private final String namePrefix;
    private final NamingStrategy namingStrategy;
    @Nullable
    private final String schemaPattern;
    @Nullable
    private final String tableNamePattern;
    private final Serializer serializer;
    @Nullable
    private final Serializer beanSerializer;
    private final SQLTypeMapping sqlTypeMapping = new SQLTypeMapping();
    private final KeyDataFactory keyDataFactory = new KeyDataFactory();

    private static Writer writerFor(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            logger.error("Folder " + file.getParent() + " could not be created");
        }
        try {
            return new OutputStreamWriter(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public MetaDataExporter(String namePrefix, String packageName, File targetFolder, NamingStrategy namingStrategy, Serializer serializer) {
        this(namePrefix, packageName, null, null, targetFolder, namingStrategy, serializer, null);
    }

    public MetaDataExporter(String namePrefix, String packageName, @Nullable String schemaPattern, @Nullable String tableNamePattern, File targetFolder, NamingStrategy namingStrategy, Serializer serializer, @Nullable Serializer beanSerializer) {
        this.namePrefix = (String)Assert.notNull((Object)namePrefix, (String)"namePrefix");
        this.packageName = (String)Assert.notNull((Object)packageName, (String)"packageName");
        this.schemaPattern = schemaPattern;
        this.tableNamePattern = tableNamePattern;
        this.targetFolder = (File)Assert.notNull((Object)targetFolder, (String)"targetFolder");
        this.namingStrategy = (NamingStrategy)Assert.notNull((Object)namingStrategy, (String)"namingStrategy");
        this.serializer = (Serializer)Assert.notNull((Object)serializer, (String)"serializer");
        this.beanSerializer = beanSerializer;
    }

    protected EntityType createEntityType(String tableName, String className) {
        SimpleType classTypeModel = new SimpleType(TypeCategory.ENTITY, this.packageName + "." + className, this.packageName, className, false, false, new Type[0]);
        EntityType classModel = new EntityType(this.beanSerializer == null ? "" : this.namePrefix, (Type)classTypeModel);
        Method wildcard = new Method((Type)classModel, "all", "{0}.*", (Type)Types.OBJECTS);
        classModel.addMethod(wildcard);
        classModel.addAnnotation((Annotation)new TableImpl(this.namingStrategy.normalizeTableName(tableName)));
        return classModel;
    }

    protected Property createProperty(EntityType classModel, String columnName, String propertyName, Type typeModel) {
        return new Property(classModel, this.namingStrategy.normalizeColumnName(columnName), propertyName, typeModel, new String[0], false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(DatabaseMetaData md) throws SQLException {
        ResultSet tables = md.getTables(null, this.schemaPattern, this.tableNamePattern, null);
        try {
            while (tables.next()) {
                this.handleTable(md, tables);
            }
        }
        finally {
            tables.close();
        }
    }

    public Set<String> getClasses() {
        return this.classes;
    }

    private void handleColumn(EntityType classModel, ResultSet columns) throws SQLException {
        String columnName = columns.getString(4);
        String propertyName = this.namingStrategy.getPropertyName(columnName, this.namePrefix, classModel);
        Class<?> clazz = this.sqlTypeMapping.get(columns.getInt(5));
        if (clazz == null) {
            throw new RuntimeException("No java type for " + columns.getString(6));
        }
        TypeCategory fieldType = TypeCategory.get((String)clazz.getName());
        if (Number.class.isAssignableFrom(clazz)) {
            fieldType = TypeCategory.NUMERIC;
        }
        ClassType typeModel = new ClassType(fieldType, clazz, new Type[0]);
        Property property = this.createProperty(classModel, columnName, propertyName, (Type)typeModel);
        property.addAnnotation((Annotation)new ColumnImpl(this.namingStrategy.normalizeColumnName(columnName)));
        classModel.addProperty(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTable(DatabaseMetaData md, ResultSet tables) throws SQLException {
        String tableName = tables.getString(3);
        String className = this.namingStrategy.getClassName(this.namePrefix, tableName);
        if (this.beanSerializer != null) {
            className = className.substring(this.namePrefix.length());
        }
        EntityType classModel = this.createEntityType(tableName, className);
        Map<String, PrimaryKeyData> primaryKeyData = this.keyDataFactory.getPrimaryKeys(md, this.schemaPattern, tableName);
        classModel.getData().put(PrimaryKeyData.class, primaryKeyData.values());
        Map<String, ForeignKeyData> foreignKeyData = this.keyDataFactory.getImportedKeys(md, this.schemaPattern, tableName);
        classModel.getData().put(ForeignKeyData.class, foreignKeyData.values());
        Map<String, InverseForeignKeyData> inverseForeignKeyData = this.keyDataFactory.getExportedKeys(md, this.schemaPattern, tableName);
        classModel.getData().put(InverseForeignKeyData.class, inverseForeignKeyData.values());
        ResultSet columns = md.getColumns(null, this.schemaPattern, tableName, null);
        try {
            while (columns.next()) {
                this.handleColumn(classModel, columns);
            }
        }
        finally {
            columns.close();
        }
        this.serialize(classModel);
    }

    private void serialize(EntityType type) {
        try {
            String path = this.packageName.replace('.', '/') + "/" + type.getSimpleName() + ".java";
            if (this.beanSerializer != null) {
                this.write(this.beanSerializer, path, type);
                String otherPath = this.packageName.replace('.', '/') + "/" + this.namePrefix + type.getSimpleName() + ".java";
                this.write(this.serializer, otherPath, type);
            } else {
                this.write(this.serializer, path, type);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Serializer serializer, String path, EntityType type) throws IOException {
        File targetFile = new File(this.targetFolder, path);
        this.classes.add(targetFile.getPath());
        Writer writer = MetaDataExporter.writerFor(targetFile);
        try {
            serializer.serialize(type, SimpleSerializerConfig.DEFAULT, (CodeWriter)new JavaWriter((Appendable)writer));
        }
        finally {
            writer.close();
        }
    }
}

