/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.BooleanBuilder;
import com.mysema.query.types.Expr;
import com.mysema.query.types.Path;
import com.mysema.query.types.expr.EBoolean;
import com.mysema.query.types.path.PEntity;
import com.mysema.query.types.path.PSimple;
import java.util.Arrays;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class ForeignKey<E> {
    private final PEntity<?> entity;
    private final List<? extends Path<?>> localColumns;
    private final List<String> foreignColumns;

    public ForeignKey(PEntity<?> entity, Path<?> localColumn, String foreignColumn) {
        this(entity, Arrays.asList(localColumn), Arrays.asList(foreignColumn));
    }

    public ForeignKey(PEntity<?> entity, List<? extends Path<?>> localColumns, List<String> foreignColumns) {
        this.entity = entity;
        this.localColumns = localColumns;
        this.foreignColumns = foreignColumns;
    }

    public PEntity<?> getEntity() {
        return this.entity;
    }

    public List<? extends Path<?>> getLocalColumns() {
        return this.localColumns;
    }

    public List<String> getForeignColumns() {
        return this.foreignColumns;
    }

    public EBoolean on(PEntity<E> entity) {
        BooleanBuilder builder = new BooleanBuilder();
        for (int i = 0; i < this.localColumns.size(); ++i) {
            Expr local = this.localColumns.get(i).asExpr();
            PSimple foreign = new PSimple(local.getType(), entity, this.foreignColumns.get(i));
            builder.and(local.eq((Expr)foreign));
        }
        return builder.getValue();
    }
}

