/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.codegen;

import com.google.common.io.Files;
import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.JavaWriter;
import com.mysema.codegen.ScalaWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.QueryTypeFactory;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SimpleSerializerConfig;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.query.sql.ColumnImpl;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.codegen.KeyDataFactory;
import com.mysema.query.sql.codegen.NamingStrategy;
import com.mysema.query.sql.codegen.SQLCodegenModule;
import com.mysema.query.sql.support.ForeignKeyData;
import com.mysema.query.sql.support.InverseForeignKeyData;
import com.mysema.query.sql.support.NotNullImpl;
import com.mysema.query.sql.support.PrimaryKeyData;
import com.mysema.query.sql.support.SizeImpl;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataExporter {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataExporter.class);
    private static final int COLUMN_NAME = 4;
    private static final int COLUMN_TYPE = 5;
    private static final int COLUMN_SIZE = 7;
    private static final int COLUMN_NULLABLE = 11;
    private static final int SCHEMA_NAME = 2;
    private static final int TABLE_NAME = 3;
    private final SQLCodegenModule module = new SQLCodegenModule();
    private final Set<String> classes = new HashSet<String>();
    private File targetFolder;
    @Nullable
    private String beanPackageName;
    @Nullable
    private String schemaPattern;
    @Nullable
    private String tableNamePattern;
    @Nullable
    private Serializer beanSerializer;
    private boolean createScalaSources = false;
    private final Map<EntityType, Type> entityToWrapped = new HashMap<EntityType, Type>();
    private Serializer serializer;
    private TypeMappings typeMappings;
    private QueryTypeFactory queryTypeFactory;
    private NamingStrategy namingStrategy;
    private Configuration configuration;
    private KeyDataFactory keyDataFactory;
    private boolean columnAnnotations = false;
    private boolean validationAnnotations = false;
    private boolean schemaToPackage = false;
    private String sourceEncoding = "UTF-8";

    protected EntityType createEntityType(@Nullable String schemaName, String tableName, String className) {
        EntityType classModel;
        if (this.beanSerializer == null) {
            String packageName = this.normalizePackage(this.module.getPackageName(), schemaName);
            String simpleName = this.module.getPrefix() + className + this.module.getSuffix();
            SimpleType classTypeModel = new SimpleType(TypeCategory.ENTITY, packageName + "." + simpleName, packageName, simpleName, false, false, new Type[0]);
            classModel = new EntityType((Type)classTypeModel);
            this.typeMappings.register((Type)classModel, (Type)classModel);
        } else {
            String beanPackage = this.normalizePackage(this.beanPackageName, schemaName);
            String simpleName = this.module.getBeanPrefix() + className + this.module.getBeanSuffix();
            SimpleType classTypeModel = new SimpleType(TypeCategory.ENTITY, beanPackage + "." + simpleName, beanPackage, simpleName, false, false, new Type[0]);
            classModel = new EntityType((Type)classTypeModel);
            Type mappedType = this.queryTypeFactory.create((Type)classModel);
            this.entityToWrapped.put(classModel, mappedType);
            this.typeMappings.register((Type)classModel, mappedType);
        }
        classModel.getData().put("schema", schemaName);
        classModel.getData().put("table", tableName);
        return classModel;
    }

    private String normalizePackage(String packageName, @Nullable String schemaName) {
        if (this.schemaToPackage && schemaName != null) {
            return this.namingStrategy.appendSchema(packageName, schemaName);
        }
        return packageName;
    }

    protected Property createProperty(EntityType classModel, String columnName, String propertyName, Type typeModel) {
        return new Property(classModel, this.namingStrategy.normalizeColumnName(columnName), propertyName, typeModel, Collections.emptyList(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(DatabaseMetaData md) throws SQLException {
        if (this.beanPackageName == null) {
            this.beanPackageName = this.module.getPackageName();
        }
        this.module.bind("beanPackageName", this.beanPackageName);
        this.typeMappings = (TypeMappings)this.module.get(TypeMappings.class);
        this.queryTypeFactory = (QueryTypeFactory)this.module.get(QueryTypeFactory.class);
        this.serializer = (Serializer)this.module.get(Serializer.class);
        this.beanSerializer = (Serializer)this.module.get(Serializer.class, "beanSerializer");
        this.namingStrategy = (NamingStrategy)this.module.get(NamingStrategy.class);
        this.configuration = (Configuration)this.module.get(Configuration.class);
        this.keyDataFactory = this.beanSerializer == null ? new KeyDataFactory(this.namingStrategy, this.module.getPackageName(), this.module.getPrefix(), this.module.getSuffix(), this.schemaToPackage) : new KeyDataFactory(this.namingStrategy, this.beanPackageName, this.module.getBeanPrefix(), this.module.getBeanSuffix(), this.schemaToPackage);
        ResultSet tables = md.getTables(null, this.schemaPattern, this.tableNamePattern, null);
        try {
            while (tables.next()) {
                this.handleTable(md, tables);
            }
        }
        finally {
            tables.close();
        }
    }

    Set<String> getClasses() {
        return this.classes;
    }

    private void handleColumn(EntityType classModel, String tableName, ResultSet columns) throws SQLException {
        String columnName = columns.getString(4);
        String propertyName = this.namingStrategy.getPropertyName(columnName, classModel);
        Class clazz = this.configuration.getJavaType(columns.getInt(5), tableName, columnName);
        if (clazz == null) {
            throw new IllegalStateException("Found to mapping for " + columns.getInt(5));
        }
        TypeCategory fieldType = TypeCategory.get((String)clazz.getName());
        if (Number.class.isAssignableFrom(clazz)) {
            fieldType = TypeCategory.NUMERIC;
        } else if (Enum.class.isAssignableFrom(clazz)) {
            fieldType = TypeCategory.ENUM;
        }
        ClassType typeModel = new ClassType(fieldType, clazz, new Type[0]);
        Property property = this.createProperty(classModel, columnName, propertyName, (Type)typeModel);
        if (this.columnAnnotations) {
            property.addAnnotation((Annotation)new ColumnImpl(this.namingStrategy.normalizeColumnName(columnName)));
        }
        if (this.validationAnnotations) {
            int size;
            int nullable = columns.getInt(11);
            if (nullable == 0) {
                property.addAnnotation((Annotation)((Object)new NotNullImpl()));
            }
            if ((size = columns.getInt(7)) > 0 && clazz.equals(String.class)) {
                property.addAnnotation((Annotation)((Object)new SizeImpl(0, size)));
            }
        }
        classModel.addProperty(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTable(DatabaseMetaData md, ResultSet tables) throws SQLException {
        Map<String, InverseForeignKeyData> inverseForeignKeyData;
        Map<String, ForeignKeyData> foreignKeyData;
        String schemaName = tables.getString(2);
        String tableName = tables.getString(3);
        String className = this.namingStrategy.getClassName(tableName);
        EntityType classModel = this.createEntityType(schemaName, this.namingStrategy.normalizeTableName(tableName), className);
        Map<String, PrimaryKeyData> primaryKeyData = this.keyDataFactory.getPrimaryKeys(md, this.schemaPattern, tableName);
        if (!primaryKeyData.isEmpty()) {
            classModel.getData().put(PrimaryKeyData.class, primaryKeyData.values());
        }
        if (!(foreignKeyData = this.keyDataFactory.getImportedKeys(md, this.schemaPattern, tableName)).isEmpty()) {
            classModel.getData().put(ForeignKeyData.class, foreignKeyData.values());
        }
        if (!(inverseForeignKeyData = this.keyDataFactory.getExportedKeys(md, this.schemaPattern, tableName)).isEmpty()) {
            classModel.getData().put(InverseForeignKeyData.class, inverseForeignKeyData.values());
        }
        ResultSet columns = md.getColumns(null, this.schemaPattern, tableName.replace("/", "//"), null);
        try {
            while (columns.next()) {
                this.handleColumn(classModel, tableName, columns);
            }
        }
        finally {
            columns.close();
        }
        this.serialize(classModel);
        logger.info("Exported " + tableName + " successfully");
    }

    private void serialize(EntityType type) {
        try {
            String fileSuffix;
            String string = fileSuffix = this.createScalaSources ? ".scala" : ".java";
            if (this.beanSerializer != null) {
                String packageName = this.normalizePackage(this.beanPackageName, (String)type.getData().get("schema"));
                String path = packageName.replace('.', '/') + "/" + type.getSimpleName() + fileSuffix;
                this.write(this.beanSerializer, path, type);
                String otherPath = this.entityToWrapped.get(type).getFullName().replace('.', '/') + fileSuffix;
                this.write(this.serializer, otherPath, type);
            } else {
                String packageName = this.normalizePackage(this.module.getPackageName(), (String)type.getData().get("schema"));
                String path = packageName.replace('.', '/') + "/" + type.getSimpleName() + fileSuffix;
                this.write(this.serializer, path, type);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void write(Serializer serializer, String path, EntityType type) throws IOException {
        File targetFile = new File(this.targetFolder, path);
        this.classes.add(targetFile.getPath());
        StringWriter w = new StringWriter();
        ScalaWriter writer = this.createScalaSources ? new ScalaWriter((Appendable)w) : new JavaWriter((Appendable)w);
        serializer.serialize(type, SimpleSerializerConfig.DEFAULT, (CodeWriter)writer);
        boolean generate = true;
        byte[] bytes = w.toString().getBytes(this.sourceEncoding);
        if (targetFile.exists() && targetFile.length() == (long)bytes.length) {
            String str = Files.toString((File)targetFile, (Charset)Charset.forName(this.sourceEncoding));
            if (str.equals(w.toString())) {
                generate = false;
            }
        } else {
            targetFile.getParentFile().mkdirs();
        }
        if (generate) {
            Files.write((byte[])bytes, (File)targetFile);
        }
    }

    public void setSchemaPattern(@Nullable String schemaPattern) {
        this.schemaPattern = schemaPattern;
    }

    public void setTableNamePattern(@Nullable String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setConfiguration(Configuration configuration) {
        Assert.notNull((Object)configuration, (String)"configuration");
        this.module.bind(Configuration.class, configuration);
    }

    public void setCreateScalaSources(boolean createScalaSources) {
        this.createScalaSources = createScalaSources;
    }

    public void setTargetFolder(File targetFolder) {
        Assert.notNull((Object)targetFolder, (String)"targetFolder");
        this.targetFolder = targetFolder;
    }

    public void setPackageName(String packageName) {
        Assert.notNull((Object)packageName, (String)"packageName");
        this.module.bind("packageName", packageName);
    }

    public void setBeanPackageName(@Nullable String beanPackageName) {
        this.beanPackageName = beanPackageName;
    }

    public void setNamePrefix(String namePrefix) {
        Assert.notNull((Object)namePrefix, (String)"namePrefix");
        this.module.bind("prefix", namePrefix);
    }

    public void setNameSuffix(String nameSuffix) {
        Assert.notNull((Object)nameSuffix, (String)"nameSuffix");
        this.module.bind("suffix", nameSuffix);
    }

    public void setBeanPrefix(String beanPrefix) {
        Assert.notNull((Object)beanPrefix, (String)"beanPrefix");
        this.module.bind("beanPrefix", beanPrefix);
    }

    public void setBeanSuffix(String beanSuffix) {
        Assert.notNull((Object)beanSuffix, (String)"beanSuffix");
        this.module.bind("beanSuffix", beanSuffix);
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        Assert.notNull((Object)namingStrategy, (String)"namingStrategy");
        this.module.bind(NamingStrategy.class, namingStrategy);
    }

    public void setBeanSerializer(@Nullable Serializer beanSerializer) {
        this.module.bind("beanSerializer", beanSerializer);
    }

    public void setBeanSerializerClass(Class<? extends Serializer> beanSerializerClass) {
        Assert.notNull(beanSerializerClass, (String)"beanSerializerClass");
        this.module.bind("beanSerializer", beanSerializerClass);
    }

    public void setInnerClassesForKeys(boolean innerClassesForKeys) {
        this.module.bind("innerClassesForKeys", innerClassesForKeys);
    }

    public void setSerializerClass(Class<? extends Serializer> serializerClass) {
        Assert.notNull(serializerClass, (String)"serializerClass");
        this.module.bind(Serializer.class, serializerClass);
    }

    public void setTypeMappings(TypeMappings typeMappings) {
        Assert.notNull((Object)typeMappings, (String)"typeMappings");
        this.module.bind(TypeMappings.class, typeMappings);
    }

    public void setColumnAnnotations(boolean columnAnnotations) {
        this.columnAnnotations = columnAnnotations;
    }

    public void setValidationAnnotations(boolean validationAnnotations) {
        this.validationAnnotations = validationAnnotations;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public void setSchemaToPackage(boolean schemaToPackage) {
        this.schemaToPackage = schemaToPackage;
        this.module.bind("schemaToPackage", schemaToPackage);
    }
}

