/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.TypeExtends;
import com.mysema.codegen.model.TypeSuper;
import com.mysema.codegen.model.Types;
import com.mysema.query.codegen.AnnotationHelper;
import com.mysema.query.codegen.DefaultVariableNameFunction;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.ParameterizedTypeImpl;
import com.mysema.query.codegen.Property;
import com.mysema.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TypeFactory {
    private static final com.mysema.codegen.model.Type ANY = new TypeExtends((com.mysema.codegen.model.Type)Types.OBJECT);
    private final Map<List<?>, com.mysema.codegen.model.Type> cache = Maps.newHashMap();
    private final List<Class<? extends Annotation>> entityAnnotations;
    private final List<AnnotationHelper> annotationHelpers = Lists.newArrayList();
    private final Set<Class<?>> embeddableTypes = Sets.newHashSet();
    private boolean unknownAsEntity = false;
    private Function<EntityType, String> variableNameFunction;

    public TypeFactory() {
        this(Lists.newArrayList(), DefaultVariableNameFunction.INSTANCE);
    }

    public TypeFactory(List<Class<? extends Annotation>> entityAnnotations) {
        this(entityAnnotations, DefaultVariableNameFunction.INSTANCE);
    }

    public TypeFactory(List<Class<? extends Annotation>> entityAnnotations, Function<EntityType, String> variableNameFunction) {
        this.entityAnnotations = entityAnnotations;
        this.variableNameFunction = variableNameFunction;
    }

    public EntityType getEntityType(Class<?> cl) {
        Type generic = cl;
        if (cl.getTypeParameters().length > 0) {
            generic = new ParameterizedTypeImpl(cl, cl.getTypeParameters());
        }
        return (EntityType)this.get(true, cl, null, generic);
    }

    public com.mysema.codegen.model.Type get(Class<?> cl) {
        return this.get(cl, cl);
    }

    public com.mysema.codegen.model.Type get(Class<?> cl, Type genericType) {
        return this.get(this.isEntityClass(cl), cl, null, genericType);
    }

    public com.mysema.codegen.model.Type get(Class<?> cl, AnnotatedElement annotated, Type genericType) {
        return this.get(this.isEntityClass(cl), cl, annotated, genericType);
    }

    public com.mysema.codegen.model.Type get(boolean entity, Class<?> cl, Type genericType) {
        return this.get(entity, cl, null, genericType);
    }

    public com.mysema.codegen.model.Type get(boolean entity, Class<?> cl, AnnotatedElement annotated, Type genericType) {
        ImmutableList key;
        ImmutableList.Builder keyBuilder = ImmutableList.builder().add(cl).add((Object)genericType);
        AnnotationHelper annotationHelper = null;
        Annotation selectedAnnotation = null;
        if (annotated != null) {
            block0: for (Annotation annotation : annotated.getDeclaredAnnotations()) {
                for (AnnotationHelper helper : this.annotationHelpers) {
                    if (!helper.isSupported(annotation.annotationType())) continue;
                    keyBuilder.add(annotation.annotationType());
                    selectedAnnotation = annotated.getAnnotation(annotation.annotationType());
                    annotationHelper = helper;
                    keyBuilder.add(helper.getCustomKey(selectedAnnotation));
                    continue block0;
                }
            }
        }
        if (this.cache.containsKey(key = keyBuilder.build())) {
            Object value = this.cache.get(key);
            if (entity && !(value instanceof EntityType)) {
                value = new EntityType((com.mysema.codegen.model.Type)value, this.variableNameFunction);
                this.cache.put((List<?>)key, (com.mysema.codegen.model.Type)value);
            }
            return value;
        }
        com.mysema.codegen.model.Type value = this.create(entity, cl, annotationHelper, selectedAnnotation, genericType, (List<?>)key);
        this.cache.put((List<?>)key, value);
        return value;
    }

    private com.mysema.codegen.model.Type create(boolean entity, Class<?> cl, AnnotationHelper annotationHelper, Annotation annotation, Type genericType, List<?> key) {
        Object value;
        if (cl.isPrimitive()) {
            cl = Primitives.wrap(cl);
        }
        com.mysema.codegen.model.Type[] tempParams = (com.mysema.codegen.model.Type[])Array.newInstance(com.mysema.codegen.model.Type.class, ReflectionUtils.getTypeParameterCount((Type)genericType));
        this.cache.put(key, (com.mysema.codegen.model.Type)new ClassType(cl, tempParams));
        com.mysema.codegen.model.Type[] parameters = this.getParameters(cl, genericType);
        if (cl.isArray()) {
            com.mysema.codegen.model.Type componentType = this.get(cl.getComponentType());
            if (cl.getComponentType().isPrimitive()) {
                componentType = (com.mysema.codegen.model.Type)Types.PRIMITIVES.get(componentType);
            }
            value = componentType.asArrayType();
        } else {
            value = cl.isEnum() ? new ClassType(TypeCategory.ENUM, cl, new com.mysema.codegen.model.Type[0]) : (Number.class.isAssignableFrom(cl) && Comparable.class.isAssignableFrom(cl) ? new ClassType(TypeCategory.NUMERIC, cl, parameters) : (entity ? this.createOther(cl, entity, annotationHelper, annotation, parameters) : (Map.class.isAssignableFrom(cl) ? new SimpleType((com.mysema.codegen.model.Type)Types.MAP, new com.mysema.codegen.model.Type[]{parameters[0], this.asGeneric(parameters[1])}) : (List.class.isAssignableFrom(cl) ? new SimpleType((com.mysema.codegen.model.Type)Types.LIST, new com.mysema.codegen.model.Type[]{this.asGeneric(parameters[0])}) : (Set.class.isAssignableFrom(cl) ? new SimpleType((com.mysema.codegen.model.Type)Types.SET, new com.mysema.codegen.model.Type[]{this.asGeneric(parameters[0])}) : (Collection.class.isAssignableFrom(cl) ? new SimpleType((com.mysema.codegen.model.Type)Types.COLLECTION, new com.mysema.codegen.model.Type[]{this.asGeneric(parameters[0])}) : this.createOther(cl, entity, annotationHelper, annotation, parameters)))))));
        }
        if (genericType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)genericType;
            value = tv.getBounds().length == 1 && tv.getBounds()[0].equals(Object.class) ? new TypeSuper(tv.getName(), (com.mysema.codegen.model.Type)value) : new TypeExtends(tv.getName(), (com.mysema.codegen.model.Type)value);
        }
        if (entity && !(value instanceof EntityType)) {
            value = new EntityType((com.mysema.codegen.model.Type)value, this.variableNameFunction);
        }
        return value;
    }

    private com.mysema.codegen.model.Type asGeneric(com.mysema.codegen.model.Type type) {
        int count;
        if (type.getParameters().size() == 0 && (count = type.getJavaClass().getTypeParameters().length) > 0) {
            return new SimpleType(type, new com.mysema.codegen.model.Type[count]);
        }
        return type;
    }

    private com.mysema.codegen.model.Type createOther(Class<?> cl, boolean entity, AnnotationHelper annotationHelper, Annotation annotation, com.mysema.codegen.model.Type[] parameters) {
        TypeCategory typeCategory = TypeCategory.get((String)cl.getName());
        if (annotationHelper != null) {
            typeCategory = annotationHelper.getTypeByAnnotation(cl, annotation);
        } else if (!typeCategory.isSubCategoryOf(TypeCategory.COMPARABLE) && Comparable.class.isAssignableFrom(cl) && !cl.equals(Comparable.class)) {
            typeCategory = TypeCategory.COMPARABLE;
        } else if (this.embeddableTypes.contains(cl)) {
            typeCategory = TypeCategory.CUSTOM;
        } else if (typeCategory == TypeCategory.SIMPLE && entity) {
            typeCategory = TypeCategory.ENTITY;
        } else if (this.unknownAsEntity && typeCategory == TypeCategory.SIMPLE && !cl.getName().startsWith("java")) {
            typeCategory = TypeCategory.CUSTOM;
        }
        return new ClassType(typeCategory, cl, parameters);
    }

    private com.mysema.codegen.model.Type[] getParameters(Class<?> cl, Type genericType) {
        int parameterCount = ReflectionUtils.getTypeParameterCount((Type)genericType);
        if (parameterCount > 0) {
            return this.getGenericParameters(cl, genericType, parameterCount);
        }
        if (Map.class.isAssignableFrom(cl)) {
            return new com.mysema.codegen.model.Type[]{Types.OBJECT, Types.OBJECT};
        }
        if (Collection.class.isAssignableFrom(cl)) {
            return new com.mysema.codegen.model.Type[]{Types.OBJECT};
        }
        return new com.mysema.codegen.model.Type[0];
    }

    private com.mysema.codegen.model.Type[] getGenericParameters(Class<?> cl, Type genericType, int parameterCount) {
        com.mysema.codegen.model.Type[] types = new com.mysema.codegen.model.Type[parameterCount];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.getGenericParameter(cl, genericType, i);
        }
        return types;
    }

    private com.mysema.codegen.model.Type getGenericParameter(Class<?> cl, Type genericType, int i) {
        Type parameter = ReflectionUtils.getTypeParameter((Type)genericType, (int)i);
        if (parameter instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)parameter;
            com.mysema.codegen.model.Type rv = this.get(ReflectionUtils.getTypeParameterAsClass((Type)genericType, (int)i), null, parameter);
            return new TypeExtends(variable.getName(), rv);
        }
        if (parameter instanceof WildcardType && ((WildcardType)parameter).getUpperBounds()[0].equals(Object.class) && ((WildcardType)parameter).getLowerBounds().length == 0) {
            return ANY;
        }
        com.mysema.codegen.model.Type rv = this.get(ReflectionUtils.getTypeParameterAsClass((Type)genericType, (int)i), null, parameter);
        if (parameter instanceof WildcardType) {
            rv = new TypeExtends(rv);
        }
        return rv;
    }

    private boolean isEntityClass(Class<?> cl) {
        for (Class<? extends Annotation> clazz : this.entityAnnotations) {
            if (!cl.isAnnotationPresent(clazz)) continue;
            return true;
        }
        return this.embeddableTypes.contains(cl);
    }

    public void extendTypes() {
        for (Map.Entry<List<?>, com.mysema.codegen.model.Type> entry : this.cache.entrySet()) {
            EntityType entityType;
            if (!(entry.getValue() instanceof EntityType) || !(entityType = (EntityType)entry.getValue()).getProperties().isEmpty()) continue;
            for (com.mysema.codegen.model.Type type : this.cache.values()) {
                if (!type.getFullName().equals(entityType.getFullName()) || !(type instanceof EntityType)) continue;
                EntityType base = (EntityType)type;
                for (Property property : base.getProperties()) {
                    entityType.addProperty(property);
                }
            }
        }
    }

    public void setUnknownAsEntity(boolean unknownAsEntity) {
        this.unknownAsEntity = unknownAsEntity;
    }

    public void addEmbeddableType(Class<?> cl) {
        this.embeddableTypes.add(cl);
    }

    public void addAnnotationHelper(AnnotationHelper annotationHelper) {
        this.annotationHelpers.add(annotationHelper);
    }
}

