/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.google.common.base.Function;
import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.Constructor;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.Types;
import com.mysema.commons.lang.Assert;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.query.types.ConstructorExpression;
import com.mysema.query.types.Expression;
import com.mysema.query.types.expr.NumberExpression;
import java.io.IOException;
import javax.annotation.Generated;
import javax.inject.Inject;

public final class ProjectionSerializer
implements Serializer {
    private final TypeMappings typeMappings;

    @Inject
    public ProjectionSerializer(TypeMappings typeMappings) {
        this.typeMappings = (TypeMappings)Assert.notNull((Object)typeMappings, (String)"typeMappings");
    }

    protected void intro(EntityType model, CodeWriter writer) throws IOException {
        String simpleName = model.getSimpleName();
        Type queryType = this.typeMappings.getPathType((Type)model, model, false);
        if (!queryType.getPackageName().isEmpty()) {
            writer.packageDecl(queryType.getPackageName());
        }
        writer.imports(new Package[]{Expression.class.getPackage(), NumberExpression.class.getPackage()});
        writer.imports(new Class[]{Generated.class});
        writer.javadoc(new String[]{queryType + " is a Querydsl Projection type for " + simpleName});
        writer.line(new String[]{"@Generated(\"", this.getClass().getName(), "\")"});
        ClassType superType = new ClassType(TypeCategory.SIMPLE, ConstructorExpression.class, new Type[]{model});
        writer.beginClass(queryType, (Type)superType, new Type[0]);
        writer.privateStaticFinal((Type)Types.LONG_P, "serialVersionUID", String.valueOf(model.hashCode()));
    }

    protected void outro(EntityType model, CodeWriter writer) throws IOException {
        writer.end();
    }

    @Override
    public void serialize(final EntityType model, SerializerConfig serializerConfig, CodeWriter writer) throws IOException {
        this.intro(model, writer);
        String localName = writer.getRawName((Type)model);
        for (Constructor c : model.getConstructors()) {
            writer.beginConstructor(c.getParameters(), (Function)new Function<Parameter, Parameter>(){

                public Parameter apply(Parameter p) {
                    return new Parameter(p.getName(), ProjectionSerializer.this.typeMappings.getExprType(p.getType(), model, false, false, true));
                }
            });
            writer.beginLine(new String[]{"super(" + localName + ".class"});
            writer.append((CharSequence)", new Class[]{");
            boolean first = true;
            for (Parameter p : c.getParameters()) {
                if (!first) {
                    writer.append((CharSequence)", ");
                }
                if (Types.PRIMITIVES.containsKey(p.getType())) {
                    Type primitive = (Type)Types.PRIMITIVES.get(p.getType());
                    writer.append((CharSequence)(primitive.getFullName() + ".class"));
                } else {
                    writer.append((CharSequence)writer.getRawName(p.getType()));
                    writer.append((CharSequence)".class");
                }
                first = false;
            }
            writer.append((CharSequence)"}");
            for (Parameter p : c.getParameters()) {
                writer.append((CharSequence)(", " + p.getName()));
            }
            writer.append((CharSequence)");\n");
            writer.end();
        }
        this.outro(model, writer);
    }
}

