/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.codegen.model.Constructor;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.query.annotations.PropertyType;
import com.mysema.query.annotations.QueryInit;
import com.mysema.query.annotations.QueryType;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.ExtendedTypeFactory;
import com.mysema.query.apt.VisitorConfig;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.QueryTypeFactory;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.util.Annotations;
import com.mysema.util.BeanUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public final class TypeElementHandler {
    private final TypeMappings typeMappings;
    private final QueryTypeFactory queryTypeFactory;
    private final Configuration configuration;
    private final ExtendedTypeFactory typeFactory;

    public TypeElementHandler(Configuration configuration, ExtendedTypeFactory typeFactory, TypeMappings typeMappings, QueryTypeFactory queryTypeFactory) {
        this.configuration = configuration;
        this.typeFactory = typeFactory;
        this.typeMappings = typeMappings;
        this.queryTypeFactory = queryTypeFactory;
    }

    public EntityType handleEntityType(TypeElement element) {
        Annotations annotations;
        String name;
        EntityType entityType = this.typeFactory.getEntityType(element.asType(), true);
        List<? extends Element> elements = element.getEnclosedElements();
        VisitorConfig config = this.configuration.getConfig(element, elements);
        HashSet<String> blockedProperties = new HashSet<String>();
        HashMap<String, TypeMirror> propertyTypes = new HashMap<String, TypeMirror>();
        HashMap<String, Annotations> propertyAnnotations = new HashMap<String, Annotations>();
        if (config.visitConstructors()) {
            this.handleConstructors(entityType, elements);
        }
        if (config.visitFieldProperties()) {
            for (VariableElement variableElement : ElementFilter.fieldsIn(elements)) {
                name = variableElement.getSimpleName().toString();
                if (this.configuration.isBlockedField(variableElement)) {
                    blockedProperties.add(name);
                    continue;
                }
                if (!this.configuration.isValidField(variableElement)) continue;
                annotations = new Annotations(new AnnotatedElement[0]);
                annotations.addAnnotation((Annotation)variableElement.getAnnotation(QueryType.class));
                annotations.addAnnotation((Annotation)variableElement.getAnnotation(QueryInit.class));
                propertyAnnotations.put(name, annotations);
                propertyTypes.put(name, variableElement.asType());
            }
        }
        if (config.visitMethodProperties()) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(elements)) {
                name = executableElement.getSimpleName().toString();
                if (name.startsWith("get") && name.length() > 3 && executableElement.getParameters().isEmpty()) {
                    name = BeanUtils.uncapitalize((String)name.substring(3));
                } else {
                    if (!name.startsWith("is") || name.length() <= 2 || !executableElement.getParameters().isEmpty()) continue;
                    name = BeanUtils.uncapitalize((String)name.substring(2));
                }
                if (this.configuration.isBlockedGetter(executableElement)) {
                    blockedProperties.add(name);
                    continue;
                }
                if (!this.configuration.isValidGetter(executableElement) || blockedProperties.contains(name)) continue;
                annotations = (Annotations)propertyAnnotations.get(name);
                if (annotations == null) {
                    annotations = new Annotations(new AnnotatedElement[0]);
                    propertyAnnotations.put(name, annotations);
                }
                annotations.addAnnotation((Annotation)executableElement.getAnnotation(QueryType.class));
                annotations.addAnnotation((Annotation)executableElement.getAnnotation(QueryInit.class));
                propertyTypes.put(name, executableElement.getReturnType());
            }
        }
        for (Map.Entry entry : propertyAnnotations.entrySet()) {
            Property property = this.toProperty(entityType, (String)entry.getKey(), (TypeMirror)propertyTypes.get(entry.getKey()), (Annotations)entry.getValue());
            if (property == null) continue;
            entityType.addProperty(property);
        }
        return entityType;
    }

    private Property toProperty(EntityType entityType, String name, TypeMirror type, Annotations annotations) {
        Type propertyType = this.typeFactory.getType(type, true);
        if (annotations.isAnnotationPresent(QueryType.class)) {
            PropertyType propertyTypeAnn = ((QueryType)annotations.getAnnotation(QueryType.class)).value();
            if (propertyTypeAnn != PropertyType.NONE) {
                TypeCategory typeCategory = TypeCategory.valueOf((String)((QueryType)annotations.getAnnotation(QueryType.class)).value().name());
                if (typeCategory == null) {
                    return null;
                }
                propertyType = propertyType.as(typeCategory);
            } else {
                return null;
            }
        }
        List<Object> inits = Collections.emptyList();
        if (annotations.isAnnotationPresent(QueryInit.class)) {
            inits = Arrays.asList(((QueryInit)annotations.getAnnotation(QueryInit.class)).value());
        }
        return new Property(entityType, name, propertyType, inits);
    }

    public EntityType handleProjectionType(TypeElement e) {
        Type c = this.typeFactory.getType(e.asType(), true);
        EntityType entityType = new EntityType(c.as(TypeCategory.ENTITY));
        this.typeMappings.register((Type)entityType, this.queryTypeFactory.create((Type)entityType));
        List<? extends Element> elements = e.getEnclosedElements();
        this.handleConstructors(entityType, elements);
        return entityType;
    }

    private Type getType(VariableElement element) {
        QueryType qt;
        Type rv = this.typeFactory.getType(element.asType(), true);
        if (element.getAnnotation(QueryType.class) != null && (qt = element.getAnnotation(QueryType.class)).value() != PropertyType.NONE) {
            TypeCategory typeCategory = TypeCategory.valueOf((String)qt.value().name());
            rv = rv.as(typeCategory);
        }
        return rv;
    }

    private void handleConstructors(EntityType entityType, List<? extends Element> elements) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(elements)) {
            if (!this.configuration.isValidConstructor(constructor)) continue;
            List<Parameter> parameters = this.transformParams(constructor.getParameters());
            entityType.addConstructor(new Constructor(parameters));
        }
    }

    public List<Parameter> transformParams(List<? extends VariableElement> params) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(params.size());
        for (VariableElement variableElement : params) {
            Type paramType = this.getType(variableElement);
            parameters.add(new Parameter(variableElement.getSimpleName().toString(), paramType));
        }
        return parameters;
    }
}

