/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.JavaWriter;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.query.annotations.QueryDelegate;
import com.mysema.query.annotations.QueryExclude;
import com.mysema.query.annotations.QueryProjection;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.Context;
import com.mysema.query.apt.ExtendedTypeFactory;
import com.mysema.query.apt.TypeElementHandler;
import com.mysema.query.apt.TypeExtractor;
import com.mysema.query.apt.TypeUtils;
import com.mysema.query.apt.VisitorConfig;
import com.mysema.query.codegen.Delegate;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.QueryTypeFactory;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.Supertype;
import com.mysema.query.codegen.TypeMappings;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public abstract class AbstractQuerydslProcessor
extends AbstractProcessor {
    private static final Set<Element> delegateMethods = new HashSet<Element>();
    public static final Boolean ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS = Boolean.FALSE;
    private final TypeExtractor typeExtractor = new TypeExtractor(true);
    private Configuration conf;
    private RoundEnvironment roundEnv;
    private ExtendedTypeFactory typeFactory;
    private TypeElementHandler elementHandler;
    private Context context;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Running " + this.getClass().getSimpleName());
        if (roundEnv.processingOver() || annotations.size() == 0) {
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        if (roundEnv.getRootElements() == null || roundEnv.getRootElements().isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "No sources to process");
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        this.conf = this.createConfiguration(roundEnv);
        this.context = new Context();
        Set<Class<? extends Annotation>> entityAnnotations = this.conf.getEntityAnnotations();
        TypeMappings typeMappings = this.conf.getTypeMappings();
        QueryTypeFactory queryTypeFactory = this.conf.getQueryTypeFactory();
        this.typeFactory = new ExtendedTypeFactory(this.processingEnv, this.conf, entityAnnotations, typeMappings, queryTypeFactory);
        this.elementHandler = new TypeElementHandler(this.conf, this.typeFactory, typeMappings, queryTypeFactory);
        this.roundEnv = roundEnv;
        this.processAnnotations();
        this.validateMetaTypes();
        this.serializeMetaTypes();
        return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
    }

    private void processAnnotations() {
        EntityType entityType3;
        this.processExclusions();
        Set<Element> elements = this.collectElements();
        for (Element element : elements) {
            this.typeFactory.getEntityType(element.asType(), false);
        }
        for (Element element : elements) {
            this.typeFactory.getEntityType(element.asType(), true);
        }
        boolean embeddableAnn = this.conf.getEmbeddableAnnotation() != null;
        boolean superAnn = this.conf.getSuperTypeAnnotation() != null;
        for (Element element : elements) {
            entityType3 = this.elementHandler.handleEntityType((TypeElement)element);
            this.registerTypeElement(entityType3.getFullName(), (TypeElement)element);
            if (element.getAnnotation(this.conf.getEntityAnnotation()) != null) {
                this.context.entityTypes.put(entityType3.getFullName(), entityType3);
            } else if (embeddableAnn && element.getAnnotation(this.conf.getEmbeddableAnnotation()) != null) {
                this.context.embeddableTypes.put(entityType3.getFullName(), entityType3);
            } else if (superAnn && element.getAnnotation(this.conf.getSuperTypeAnnotation()) != null) {
                this.context.supertypes.put(entityType3.getFullName(), entityType3);
            } else if (!entityType3.getDelegates().isEmpty()) {
                this.context.extensionTypes.put(entityType3.getFullName(), entityType3);
            } else {
                this.context.embeddableTypes.put(entityType3.getFullName(), entityType3);
            }
            this.context.allTypes.put(entityType3.getFullName(), entityType3);
        }
        for (EntityType entityType2 : new ArrayList<EntityType>(this.typeFactory.getEntityTypes())) {
            TypeElement element;
            String fullName = entityType2.getFullName();
            if (this.context.allTypes.keySet().contains(fullName) || (element = this.processingEnv.getElementUtils().getTypeElement(fullName)) == null) continue;
            this.elementHandler.handleEntityType(element);
        }
        for (Element element : elements) {
            entityType3 = this.typeFactory.getEntityType(element.asType(), false);
            this.addExternalParents(entityType3);
        }
        HashSet<EntityType> handled = new HashSet<EntityType>();
        for (EntityType entityType3 : this.context.allTypes.values()) {
            this.addSupertypeFields(entityType3, handled);
        }
        this.processProjectionTypes(elements);
        this.typeFactory.extendTypes();
        this.context.clean();
    }

    private void addExternalParents(EntityType entityType) {
        ArrayDeque<Type> superTypes = new ArrayDeque<Type>();
        if (entityType.getSuperType() != null) {
            superTypes.push(entityType.getSuperType().getType());
        }
        while (!superTypes.isEmpty()) {
            Type superType = (Type)superTypes.pop();
            if (this.context.allTypes.containsKey(superType.getFullName())) continue;
            TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(superType.getFullName());
            if (typeElement == null) {
                throw new IllegalStateException("Found no type for " + superType.getFullName());
            }
            EntityType superEntityType = this.elementHandler.handleEntityType(typeElement);
            if (entityType.getSuperType() != null) {
                superTypes.push(entityType.getSuperType().getType());
            }
            this.context.allTypes.put(superType.getFullName(), superEntityType);
        }
    }

    protected Set<Element> collectElements() {
        HashSet<Element> elements = new HashSet<Element>();
        elements.addAll(this.processDelegateMethods());
        for (Class<? extends Annotation> clazz : this.conf.getEntityAnnotations()) {
            elements.addAll(this.getElements(clazz));
        }
        if (this.conf.getEntitiesAnnotation() != null) {
            for (Element element : this.getElements(this.conf.getEntitiesAnnotation())) {
                AnnotationMirror mirror = TypeUtils.getAnnotationMirrorOfType(element, this.conf.getEntitiesAnnotation());
                elements.addAll(TypeUtils.getAnnotationValuesAsElements(mirror, "value"));
            }
        }
        if (this.conf.getEmbeddedAnnotation() != null) {
            elements.addAll(this.getEmbeddedTypes());
        }
        if (this.conf.isUnknownAsEmbedded()) {
            elements.addAll(this.getTypeFromProperties(elements));
        }
        elements.addAll(this.getAnnotationlessSupertypes(elements));
        if (this.conf.getEmbeddedAnnotation() != null) {
            Class<? extends Annotation> embedded = this.conf.getEmbeddedAnnotation();
            HashSet<Element> hashSet = new HashSet<Element>();
            for (Element element : elements) {
                TypeMirror superTypeMirror = ((TypeElement)element).getSuperclass();
                while (superTypeMirror != null) {
                    TypeElement superTypeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(superTypeMirror);
                    if (superTypeElement != null) {
                        List<? extends Element> enclosed = superTypeElement.getEnclosedElements();
                        for (Element element2 : enclosed) {
                            if (element2.getAnnotation(embedded) == null) continue;
                            this.handleEmbeddedType(element2, hashSet);
                        }
                        superTypeMirror = superTypeElement.getSuperclass();
                        if (!(superTypeMirror instanceof NoType)) continue;
                        superTypeMirror = null;
                        continue;
                    }
                    superTypeMirror = null;
                }
            }
            for (Element element : hashSet) {
                if (elements.contains(element)) continue;
                this.elementHandler.handleEntityType((TypeElement)element);
            }
        }
        return elements;
    }

    private Set<Element> getAnnotationlessSupertypes(Set<Element> elements) {
        HashSet<Element> rv = new HashSet<Element>();
        for (Element element : elements) {
            TypeMirror superTypeMirror = ((TypeElement)element).getSuperclass();
            while (superTypeMirror != null) {
                TypeElement superTypeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(superTypeMirror);
                if (superTypeElement != null && !superTypeElement.toString().startsWith("java.lang.") && !TypeUtils.hasAnnotationOfType((Element)superTypeElement, this.conf.getEntityAnnotations())) {
                    rv.add(superTypeElement);
                    superTypeMirror = superTypeElement.getSuperclass();
                    if (!(superTypeMirror instanceof NoType)) continue;
                    superTypeMirror = null;
                    continue;
                }
                superTypeMirror = null;
            }
        }
        return rv;
    }

    private void registerTypeElement(String entityName, TypeElement element) {
        Set<TypeElement> elements = this.context.typeElements.get(entityName);
        if (elements == null) {
            elements = new HashSet<TypeElement>();
            this.context.typeElements.put(entityName, elements);
        }
        elements.add(element);
    }

    private void processProjectionTypes(Set<Element> elements) {
        HashSet<Element> visited = new HashSet<Element>();
        for (Element element : this.getElements(QueryProjection.class)) {
            Element parent = element.getEnclosingElement();
            if (elements.contains(parent) || visited.contains(parent)) continue;
            EntityType model = this.elementHandler.handleProjectionType((TypeElement)parent);
            this.registerTypeElement(model.getFullName(), (TypeElement)parent);
            this.context.projectionTypes.put(model.getFullName(), model);
            visited.add(parent);
        }
    }

    private Set<Element> getEmbeddedTypes() {
        HashSet<Element> elements = new HashSet<Element>();
        for (Element element : this.getElements(this.conf.getEmbeddedAnnotation())) {
            this.handleEmbeddedType(element, elements);
        }
        return elements;
    }

    private void handleEmbeddedType(Element element, Set<Element> elements) {
        String typeName;
        TypeMirror type = element.asType();
        if (element.getKind() == ElementKind.METHOD) {
            type = ((ExecutableElement)element).getReturnType();
        }
        if ((typeName = ((Object)type).toString()).startsWith(Collection.class.getName()) || typeName.startsWith(List.class.getName()) || typeName.startsWith(Set.class.getName())) {
            type = ((DeclaredType)type).getTypeArguments().get(0);
        } else if (typeName.startsWith(Map.class.getName())) {
            type = ((DeclaredType)type).getTypeArguments().get(1);
        }
        TypeElement typeElement = (TypeElement)this.typeExtractor.visit(type);
        if (typeElement != null && !TypeUtils.hasAnnotationOfType((Element)typeElement, this.conf.getEntityAnnotations()) && !typeElement.getQualifiedName().toString().startsWith("java.")) {
            elements.add(typeElement);
        }
    }

    private Set<TypeElement> getTypeFromProperties(Set<Element> parents) {
        HashSet<TypeElement> elements = new HashSet<TypeElement>();
        for (Element element : parents) {
            if (!(element instanceof TypeElement)) continue;
            this.processFromProperties((TypeElement)element, elements);
        }
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            Element element;
            element = (TypeElement)iterator.next();
            if (element.getQualifiedName().toString().startsWith("java.")) {
                iterator.remove();
                continue;
            }
            boolean annotated = false;
            for (Class<? extends Annotation> annotation : this.conf.getEntityAnnotations()) {
                annotated |= element.getAnnotation(annotation) != null;
            }
            if (!annotated) continue;
            iterator.remove();
        }
        return elements;
    }

    private void processFromProperties(TypeElement type, Set<TypeElement> types) {
        List<? extends Element> children = type.getEnclosedElements();
        VisitorConfig config = this.conf.getConfig(type, children);
        if (config.visitFieldProperties()) {
            for (VariableElement field : ElementFilter.fieldsIn(children)) {
                TypeElement typeElement = (TypeElement)this.typeExtractor.visit(field.asType());
                if (typeElement == null) continue;
                types.add(typeElement);
            }
        }
        if (config.visitMethodProperties()) {
            for (ExecutableElement method : ElementFilter.methodsIn(children)) {
                TypeElement typeElement;
                String name = method.getSimpleName().toString();
                if (!name.startsWith("get") && !name.startsWith("is") || !method.getParameters().isEmpty() || (typeElement = (TypeElement)this.typeExtractor.visit(method.getReturnType())) == null) continue;
                types.add(typeElement);
            }
        }
    }

    private void addSupertypeFields(EntityType model, Set<EntityType> handled) {
        if (handled.add(model)) {
            for (Supertype supertype : model.getSuperTypes()) {
                EntityType entityType = this.context.allTypes.get(supertype.getType().getFullName());
                if (entityType == null) continue;
                this.addSupertypeFields(entityType, handled);
                supertype.setEntityType(entityType);
                model.include(supertype);
            }
        }
    }

    private void processExclusions() {
        for (Element element : this.getElements(QueryExclude.class)) {
            if (element instanceof PackageElement) {
                this.conf.addExcludedPackage(((PackageElement)element).getQualifiedName().toString());
                continue;
            }
            if (element instanceof TypeElement) {
                this.conf.addExcludedClass(((TypeElement)element).getQualifiedName().toString());
                continue;
            }
            throw new IllegalArgumentException(element.toString());
        }
    }

    private Set<Element> processDelegateMethods() {
        HashSet<? extends Element> elements = new HashSet<Element>();
        elements.addAll(this.getElements(QueryDelegate.class));
        for (Element element : delegateMethods) {
            TypeElement typeElement2 = (TypeElement)element.getEnclosingElement();
            typeElement2 = this.processingEnv.getElementUtils().getTypeElement(typeElement2.getQualifiedName().toString());
            if (typeElement2 == null) continue;
            for (Element element2 : typeElement2.getEnclosedElements()) {
                if (element2.getKind() != element.getKind() || !((Object)element2.getSimpleName()).equals(element.getSimpleName())) continue;
                elements.add(element2);
            }
        }
        delegateMethods.clear();
        delegateMethods.addAll(elements);
        HashSet<Element> typeElements = new HashSet<Element>();
        for (Element element : elements) {
            boolean bl;
            ExecutableElement method = (ExecutableElement)element;
            Element element3 = element.getEnclosingElement();
            String name = method.getSimpleName().toString();
            Type delegateType = this.typeFactory.getType(element3.asType(), true);
            Type returnType = this.typeFactory.getType(method.getReturnType(), true);
            List<Parameter> parameters = this.elementHandler.transformParams(method.getParameters());
            parameters = parameters.subList(1, parameters.size());
            EntityType entityType = null;
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                TypeMirror type;
                if (!TypeUtils.isAnnotationMirrorOfType(annotationMirror, QueryDelegate.class) || (type = TypeUtils.getAnnotationValueAsTypeMirror(annotationMirror, "value")) == null) continue;
                entityType = this.typeFactory.getEntityType(type, true);
            }
            if (entityType == null) continue;
            this.registerTypeElement(entityType.getFullName(), (TypeElement)element3);
            entityType.addDelegate(new Delegate(entityType, delegateType, name, parameters, returnType));
            TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement(entityType.getFullName());
            boolean bl2 = false;
            for (Class<? extends Annotation> ann : this.conf.getEntityAnnotations()) {
                if (typeElement.getAnnotation(ann) == null) continue;
                bl = true;
            }
            if (bl) {
                typeElements.add(this.processingEnv.getElementUtils().getTypeElement(entityType.getFullName()));
                continue;
            }
            this.context.extensionTypes.put(entityType.getFullName(), entityType);
            this.context.allTypes.put(entityType.getFullName(), entityType);
        }
        return typeElements;
    }

    private void validateMetaTypes() {
        for (Collection entityTypes : Arrays.asList(this.context.supertypes.values(), this.context.entityTypes.values(), this.context.extensionTypes.values(), this.context.embeddableTypes.values(), this.context.projectionTypes.values())) {
            for (EntityType entityType : entityTypes) {
                for (Property property : entityType.getProperties()) {
                    if (property.getInits() == null || property.getInits().size() <= 0) continue;
                    this.validateInits(entityType, property);
                }
            }
        }
    }

    protected void validateInits(EntityType entityType, Property property) {
        for (String init : property.getInits()) {
            String initProperty;
            if (init.startsWith("*") || !(property.getType() instanceof EntityType)) continue;
            String string = initProperty = init.contains(".") ? init.substring(0, init.indexOf(46)) : init;
            if (((EntityType)property.getType()).getPropertyNames().contains(initProperty)) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Illegal inits of " + entityType.getFullName() + "." + property.getName() + ": " + initProperty + " not found");
        }
    }

    private void serializeMetaTypes() {
        if (!this.context.supertypes.isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Serializing Supertypes");
            this.serialize(this.conf.getSupertypeSerializer(), this.context.supertypes.values());
        }
        if (!this.context.entityTypes.isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Serializing Entity types");
            this.serialize(this.conf.getEntitySerializer(), this.context.entityTypes.values());
        }
        if (!this.context.extensionTypes.isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Serializing Extension types");
            this.serialize(this.conf.getEmbeddableSerializer(), this.context.extensionTypes.values());
        }
        if (!this.context.embeddableTypes.isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Serializing Embeddable types");
            this.serialize(this.conf.getEmbeddableSerializer(), this.context.embeddableTypes.values());
        }
        if (!this.context.projectionTypes.isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Serializing Projection types");
            this.serialize(this.conf.getDTOSerializer(), this.context.projectionTypes.values());
        }
    }

    private Set<? extends Element> getElements(Class<? extends Annotation> a) {
        return this.roundEnv.getElementsAnnotatedWith(a);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(Serializer serializer, Collection<EntityType> models) {
        for (EntityType model : models) {
            try {
                String className;
                Type type = this.conf.getTypeMappings().getPathType((Type)model, model, true);
                String packageName = type.getPackageName();
                String string = className = !packageName.isEmpty() ? packageName + "." + type.getSimpleName() : type.getSimpleName();
                if (this.conf.isExcludedPackage(model.getPackageName()) || this.conf.isExcludedClass(model.getFullName())) continue;
                Set<TypeElement> elements = this.context.typeElements.get(model.getFullName());
                if (elements == null) {
                    elements = new HashSet<TypeElement>();
                }
                for (Property property : model.getProperties()) {
                    Set<TypeElement> customElements;
                    if (property.getType().getCategory() != TypeCategory.CUSTOM || (customElements = this.context.typeElements.get(property.getType().getFullName())) == null) continue;
                    elements.addAll(customElements);
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating " + className + " for " + elements);
                JavaFileObject fileObject = this.processingEnv.getFiler().createSourceFile(className, elements.toArray(new Element[elements.size()]));
                Writer writer = fileObject.openWriter();
                try {
                    SerializerConfig serializerConfig = this.conf.getSerializerConfig(model);
                    serializer.serialize(model, serializerConfig, (CodeWriter)new JavaWriter((Appendable)writer));
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
    }

    protected abstract Configuration createConfiguration(RoundEnvironment var1);
}

