/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt.jdo;

import com.mysema.query.apt.APTException;
import com.mysema.query.apt.DefaultConfiguration;
import com.mysema.query.apt.Processor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.mysema.query.annotations.*", "javax.jdo.annotations.*"})
public class JDOAnnotationProcessor
extends AbstractProcessor {
    private static final Boolean ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS = Boolean.FALSE;
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("AS", "ASC", "ASCENDING", "AVG", "BY", "COUNT", "DESC", "DESCENDING", "DISTINCT", "EXCLUDE", "FROM", "GROUP", "HAVING", "INTO", "MAX", "MIN", "ORDER", "PARAMETERS", "RANGE", "SELECT", "SUBCLASSES", "SUM", "UNIQUE", "VARIABLES", "WHERE"));

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Running " + this.getClass().getSimpleName());
            Class<?> entity = Class.forName("javax.jdo.annotations.PersistenceCapable");
            Class<?> embeddable = Class.forName("javax.jdo.annotations.EmbeddedOnly");
            Class<?> embedded = Class.forName("javax.jdo.annotations.Embedded");
            Class<?> skip = Class.forName("javax.jdo.annotations.NotPersistent");
            DefaultConfiguration configuration = new DefaultConfiguration(roundEnv, this.processingEnv.getOptions(), KEYWORDS, null, entity, null, embeddable, embedded, skip);
            configuration.setUseGetters(false);
            Processor processor = new Processor(this.processingEnv, roundEnv, configuration);
            processor.process();
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        catch (ClassNotFoundException e) {
            throw new APTException(e.getMessage(), e);
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

