/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.EmailAddress;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class TestMessage
implements Serializable {
    private String id = null;
    private List<EmailAddress> to = new ArrayList<EmailAddress>();
    private EmailAddress from = null;
    private String subject = null;
    private String textBody = null;
    private String htmlBody = null;
    private Date time = null;

    @ApiModelProperty(example="null", value="After the message has been sent, this is the value of the Message-ID email header.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public TestMessage to(List<EmailAddress> to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The recipients of the email message.")
    @JsonProperty(value="to")
    public List<EmailAddress> getTo() {
        return this.to;
    }

    public void setTo(List<EmailAddress> to) {
        this.to = to;
    }

    public TestMessage from(EmailAddress from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The sender of the email message.")
    @JsonProperty(value="from")
    public EmailAddress getFrom() {
        return this.from;
    }

    public void setFrom(EmailAddress from) {
        this.from = from;
    }

    public TestMessage subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="null", value="The subject of the email message.")
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public TestMessage textBody(String textBody) {
        this.textBody = textBody;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The text body of the email message.")
    @JsonProperty(value="textBody")
    public String getTextBody() {
        return this.textBody;
    }

    public void setTextBody(String textBody) {
        this.textBody = textBody;
    }

    public TestMessage htmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
        return this;
    }

    @ApiModelProperty(example="null", value="The html body of the email message")
    @JsonProperty(value="htmlBody")
    public String getHtmlBody() {
        return this.htmlBody;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public TestMessage time(Date time) {
        this.time = time;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when the message was sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="time")
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestMessage testMessage = (TestMessage)o;
        return Objects.equals(this.id, testMessage.id) && Objects.equals(this.to, testMessage.to) && Objects.equals(this.from, testMessage.from) && Objects.equals(this.subject, testMessage.subject) && Objects.equals(this.textBody, testMessage.textBody) && Objects.equals(this.htmlBody, testMessage.htmlBody) && Objects.equals(this.time, testMessage.time);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.to, this.from, this.subject, this.textBody, this.htmlBody, this.time);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    textBody: ").append(this.toIndentedString(this.textBody)).append("\n");
        sb.append("    htmlBody: ").append(this.toIndentedString(this.htmlBody)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

