/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ScimUserRoutingLanguage;
import com.mypurecloud.sdk.v2.model.ScimUserRoutingSkill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines a SCIM Genesys Cloud user.")
public class ScimUserExtensions
implements Serializable {
    private List<ScimUserRoutingSkill> routingSkills = new ArrayList<ScimUserRoutingSkill>();
    private List<ScimUserRoutingLanguage> routingLanguages = new ArrayList<ScimUserRoutingLanguage>();

    public ScimUserExtensions routingSkills(List<ScimUserRoutingSkill> routingSkills) {
        this.routingSkills = routingSkills;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of routing skills assigned to a user. Maximum 50 skills.")
    @JsonProperty(value="routingSkills")
    public List<ScimUserRoutingSkill> getRoutingSkills() {
        return this.routingSkills;
    }

    public void setRoutingSkills(List<ScimUserRoutingSkill> routingSkills) {
        this.routingSkills = routingSkills;
    }

    public ScimUserExtensions routingLanguages(List<ScimUserRoutingLanguage> routingLanguages) {
        this.routingLanguages = routingLanguages;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of routing languages assigned to a user. Maximum 50 languages.")
    @JsonProperty(value="routingLanguages")
    public List<ScimUserRoutingLanguage> getRoutingLanguages() {
        return this.routingLanguages;
    }

    public void setRoutingLanguages(List<ScimUserRoutingLanguage> routingLanguages) {
        this.routingLanguages = routingLanguages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimUserExtensions scimUserExtensions = (ScimUserExtensions)o;
        return Objects.equals(this.routingSkills, scimUserExtensions.routingSkills) && Objects.equals(this.routingLanguages, scimUserExtensions.routingLanguages);
    }

    public int hashCode() {
        return Objects.hash(this.routingSkills, this.routingLanguages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimUserExtensions {\n");
        sb.append("    routingSkills: ").append(this.toIndentedString(this.routingSkills)).append("\n");
        sb.append("    routingLanguages: ").append(this.toIndentedString(this.routingLanguages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

