/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.JsonSchemaDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Contains a metadata representation for a JSON schema stored in DataTables along with an optional field for the schema itself")
public class DataTable
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private JsonSchemaDocument schema = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public DataTable name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataTable description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description from the JSON schema (equates to the Description field on the JSON schema.)")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DataTable schema(JsonSchemaDocument schema) {
        this.schema = schema;
        return this;
    }

    @ApiModelProperty(example="null", value="the schema as stored in the system.")
    @JsonProperty(value="schema")
    public JsonSchemaDocument getSchema() {
        return this.schema;
    }

    public void setSchema(JsonSchemaDocument schema) {
        this.schema = schema;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTable dataTable = (DataTable)o;
        return Objects.equals(this.id, dataTable.id) && Objects.equals(this.name, dataTable.name) && Objects.equals(this.description, dataTable.description) && Objects.equals(this.schema, dataTable.schema) && Objects.equals(this.selfUri, dataTable.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.schema, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataTable {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

