/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.SurveyForm;
import java.util.HashMap;
import java.util.Map;

public class PutQualityFormsSurveyRequest {
    private String formId;
    private SurveyForm body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public PutQualityFormsSurveyRequest withFormId(String formId) {
        this.setFormId(formId);
        return this;
    }

    public SurveyForm getBody() {
        return this.body;
    }

    public void setBody(SurveyForm body) {
        this.body = body;
    }

    public PutQualityFormsSurveyRequest withBody(SurveyForm body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutQualityFormsSurveyRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<SurveyForm> withHttpInfo() {
        if (this.formId == null) {
            throw new IllegalStateException("Missing the required parameter 'formId' when building request for PutQualityFormsSurveyRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutQualityFormsSurveyRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/quality/forms/surveys/{formId}").withPathParameter("formId", this.formId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String formId, SurveyForm body) {
        return new Builder().withRequiredParams(formId, body);
    }

    public static class Builder {
        private final PutQualityFormsSurveyRequest request = new PutQualityFormsSurveyRequest();

        private Builder() {
        }

        public Builder withFormId(String formId) {
            this.request.setFormId(formId);
            return this;
        }

        public Builder withBody(SurveyForm body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String formId, SurveyForm body) {
            this.request.setFormId(formId);
            this.request.setBody(body);
            return this;
        }

        public PutQualityFormsSurveyRequest build() {
            if (this.request.formId == null) {
                throw new IllegalStateException("Missing the required parameter 'formId' when building request for PutQualityFormsSurveyRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutQualityFormsSurveyRequest.");
            }
            return this.request;
        }
    }
}

