/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetLicenseDefinitionRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseDefinitionsRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseOrganizationRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseUserRequest;
import com.mypurecloud.sdk.v2.api.request.PostLicenseOrganizationRequest;
import com.mypurecloud.sdk.v2.api.request.PostLicenseUsersRequest;
import com.mypurecloud.sdk.v2.model.LicenseBatchAssignmentRequest;
import com.mypurecloud.sdk.v2.model.LicenseDefinition;
import com.mypurecloud.sdk.v2.model.LicenseDefinitionListing;
import com.mypurecloud.sdk.v2.model.LicenseOrganization;
import com.mypurecloud.sdk.v2.model.LicenseUpdateResponse;
import com.mypurecloud.sdk.v2.model.LicenseUser;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class LicenseApi {
    private final ApiClient pcapiClient;

    public LicenseApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LicenseApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public LicenseDefinition getLicenseDefinition(String licenseId) throws IOException, ApiException {
        return this.getLicenseDefinition(this.createGetLicenseDefinitionRequest(licenseId));
    }

    public ApiResponse<LicenseDefinition> getLicenseDefinitionWithHttpInfo(String licenseId) throws IOException {
        return this.getLicenseDefinition(this.createGetLicenseDefinitionRequest(licenseId).withHttpInfo());
    }

    private GetLicenseDefinitionRequest createGetLicenseDefinitionRequest(String licenseId) {
        return GetLicenseDefinitionRequest.builder().withLicenseId(licenseId).build();
    }

    public LicenseDefinition getLicenseDefinition(GetLicenseDefinitionRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LicenseDefinition> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LicenseDefinition>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LicenseDefinition> getLicenseDefinition(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LicenseDefinition>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LicenseDefinitionListing getLicenseDefinitions() throws IOException, ApiException {
        return this.getLicenseDefinitions(this.createGetLicenseDefinitionsRequest());
    }

    public ApiResponse<LicenseDefinitionListing> getLicenseDefinitionsWithHttpInfo() throws IOException {
        return this.getLicenseDefinitions(this.createGetLicenseDefinitionsRequest().withHttpInfo());
    }

    private GetLicenseDefinitionsRequest createGetLicenseDefinitionsRequest() {
        return GetLicenseDefinitionsRequest.builder().build();
    }

    public LicenseDefinitionListing getLicenseDefinitions(GetLicenseDefinitionsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LicenseDefinitionListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LicenseDefinitionListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LicenseDefinitionListing> getLicenseDefinitions(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LicenseDefinitionListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LicenseOrganization getLicenseOrganization() throws IOException, ApiException {
        return this.getLicenseOrganization(this.createGetLicenseOrganizationRequest());
    }

    public ApiResponse<LicenseOrganization> getLicenseOrganizationWithHttpInfo() throws IOException {
        return this.getLicenseOrganization(this.createGetLicenseOrganizationRequest().withHttpInfo());
    }

    private GetLicenseOrganizationRequest createGetLicenseOrganizationRequest() {
        return GetLicenseOrganizationRequest.builder().build();
    }

    public LicenseOrganization getLicenseOrganization(GetLicenseOrganizationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LicenseOrganization> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LicenseOrganization>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LicenseOrganization> getLicenseOrganization(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LicenseOrganization>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LicenseUser getLicenseUser(String userId) throws IOException, ApiException {
        return this.getLicenseUser(this.createGetLicenseUserRequest(userId));
    }

    public ApiResponse<LicenseUser> getLicenseUserWithHttpInfo(String userId) throws IOException {
        return this.getLicenseUser(this.createGetLicenseUserRequest(userId).withHttpInfo());
    }

    private GetLicenseUserRequest createGetLicenseUserRequest(String userId) {
        return GetLicenseUserRequest.builder().withUserId(userId).build();
    }

    public LicenseUser getLicenseUser(GetLicenseUserRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LicenseUser> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LicenseUser>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LicenseUser> getLicenseUser(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LicenseUser>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LicenseUpdateResponse postLicenseOrganization(LicenseBatchAssignmentRequest body) throws IOException, ApiException {
        return this.postLicenseOrganization(this.createPostLicenseOrganizationRequest(body));
    }

    public ApiResponse<LicenseUpdateResponse> postLicenseOrganizationWithHttpInfo(LicenseBatchAssignmentRequest body) throws IOException {
        return this.postLicenseOrganization(this.createPostLicenseOrganizationRequest(body).withHttpInfo());
    }

    private PostLicenseOrganizationRequest createPostLicenseOrganizationRequest(LicenseBatchAssignmentRequest body) {
        return PostLicenseOrganizationRequest.builder().withBody(body).build();
    }

    public LicenseUpdateResponse postLicenseOrganization(PostLicenseOrganizationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LicenseUpdateResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LicenseUpdateResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LicenseUpdateResponse> postLicenseOrganization(ApiRequest<LicenseBatchAssignmentRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LicenseUpdateResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Map<String, Object> postLicenseUsers(List<String> body) throws IOException, ApiException {
        return this.postLicenseUsers(this.createPostLicenseUsersRequest(body));
    }

    public ApiResponse<Map<String, Object>> postLicenseUsersWithHttpInfo(List<String> body) throws IOException {
        return this.postLicenseUsers(this.createPostLicenseUsersRequest(body).withHttpInfo());
    }

    private PostLicenseUsersRequest createPostLicenseUsersRequest(List<String> body) {
        return PostLicenseUsersRequest.builder().withBody(body).build();
    }

    public Map<String, Object> postLicenseUsers(PostLicenseUsersRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Map<String, Object>> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Map<String, Object>>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Map<String, Object>> postLicenseUsers(ApiRequest<List<String>> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Map<String, Object>>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

