/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteFaxDocumentRequest;
import com.mypurecloud.sdk.v2.api.request.GetFaxDocumentContentRequest;
import com.mypurecloud.sdk.v2.api.request.GetFaxDocumentRequest;
import com.mypurecloud.sdk.v2.api.request.GetFaxDocumentsRequest;
import com.mypurecloud.sdk.v2.api.request.GetFaxSummaryRequest;
import com.mypurecloud.sdk.v2.api.request.PutFaxDocumentRequest;
import com.mypurecloud.sdk.v2.model.DownloadResponse;
import com.mypurecloud.sdk.v2.model.FaxDocument;
import com.mypurecloud.sdk.v2.model.FaxDocumentEntityListing;
import com.mypurecloud.sdk.v2.model.FaxSummary;
import java.io.IOException;

public class FaxApi {
    private final ApiClient pcapiClient;

    public FaxApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FaxApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteFaxDocument(String documentId) throws IOException, ApiException {
        this.deleteFaxDocument(this.createDeleteFaxDocumentRequest(documentId));
    }

    public ApiResponse<Void> deleteFaxDocumentWithHttpInfo(String documentId) throws IOException {
        return this.deleteFaxDocument(this.createDeleteFaxDocumentRequest(documentId).withHttpInfo());
    }

    private DeleteFaxDocumentRequest createDeleteFaxDocumentRequest(String documentId) {
        return DeleteFaxDocumentRequest.builder().withDocumentId(documentId).build();
    }

    public void deleteFaxDocument(DeleteFaxDocumentRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse response = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteFaxDocument(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public FaxDocument getFaxDocument(String documentId) throws IOException, ApiException {
        return this.getFaxDocument(this.createGetFaxDocumentRequest(documentId));
    }

    public ApiResponse<FaxDocument> getFaxDocumentWithHttpInfo(String documentId) throws IOException {
        return this.getFaxDocument(this.createGetFaxDocumentRequest(documentId).withHttpInfo());
    }

    private GetFaxDocumentRequest createGetFaxDocumentRequest(String documentId) {
        return GetFaxDocumentRequest.builder().withDocumentId(documentId).build();
    }

    public FaxDocument getFaxDocument(GetFaxDocumentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<FaxDocument> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<FaxDocument>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<FaxDocument> getFaxDocument(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<FaxDocument>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DownloadResponse getFaxDocumentContent(String documentId) throws IOException, ApiException {
        return this.getFaxDocumentContent(this.createGetFaxDocumentContentRequest(documentId));
    }

    public ApiResponse<DownloadResponse> getFaxDocumentContentWithHttpInfo(String documentId) throws IOException {
        return this.getFaxDocumentContent(this.createGetFaxDocumentContentRequest(documentId).withHttpInfo());
    }

    private GetFaxDocumentContentRequest createGetFaxDocumentContentRequest(String documentId) {
        return GetFaxDocumentContentRequest.builder().withDocumentId(documentId).build();
    }

    public DownloadResponse getFaxDocumentContent(GetFaxDocumentContentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DownloadResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DownloadResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DownloadResponse> getFaxDocumentContent(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DownloadResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public FaxDocumentEntityListing getFaxDocuments(Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        return this.getFaxDocuments(this.createGetFaxDocumentsRequest(pageSize, pageNumber));
    }

    public ApiResponse<FaxDocumentEntityListing> getFaxDocumentsWithHttpInfo(Integer pageSize, Integer pageNumber) throws IOException {
        return this.getFaxDocuments(this.createGetFaxDocumentsRequest(pageSize, pageNumber).withHttpInfo());
    }

    private GetFaxDocumentsRequest createGetFaxDocumentsRequest(Integer pageSize, Integer pageNumber) {
        return GetFaxDocumentsRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).build();
    }

    public FaxDocumentEntityListing getFaxDocuments(GetFaxDocumentsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<FaxDocumentEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<FaxDocumentEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<FaxDocumentEntityListing> getFaxDocuments(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<FaxDocumentEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public FaxSummary getFaxSummary() throws IOException, ApiException {
        return this.getFaxSummary(this.createGetFaxSummaryRequest());
    }

    public ApiResponse<FaxSummary> getFaxSummaryWithHttpInfo() throws IOException {
        return this.getFaxSummary(this.createGetFaxSummaryRequest().withHttpInfo());
    }

    private GetFaxSummaryRequest createGetFaxSummaryRequest() {
        return GetFaxSummaryRequest.builder().build();
    }

    public FaxSummary getFaxSummary(GetFaxSummaryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<FaxSummary> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<FaxSummary>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<FaxSummary> getFaxSummary(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<FaxSummary>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public FaxDocument putFaxDocument(String documentId, FaxDocument body) throws IOException, ApiException {
        return this.putFaxDocument(this.createPutFaxDocumentRequest(documentId, body));
    }

    public ApiResponse<FaxDocument> putFaxDocumentWithHttpInfo(String documentId, FaxDocument body) throws IOException {
        return this.putFaxDocument(this.createPutFaxDocumentRequest(documentId, body).withHttpInfo());
    }

    private PutFaxDocumentRequest createPutFaxDocumentRequest(String documentId, FaxDocument body) {
        return PutFaxDocumentRequest.builder().withDocumentId(documentId).withBody(body).build();
    }

    public FaxDocument putFaxDocument(PutFaxDocumentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<FaxDocument> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<FaxDocument>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<FaxDocument> putFaxDocument(ApiRequest<FaxDocument> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<FaxDocument>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

