/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteAttributeRequest;
import com.mypurecloud.sdk.v2.api.request.GetAttributeRequest;
import com.mypurecloud.sdk.v2.api.request.GetAttributesRequest;
import com.mypurecloud.sdk.v2.api.request.PostAttributesQueryRequest;
import com.mypurecloud.sdk.v2.api.request.PostAttributesRequest;
import com.mypurecloud.sdk.v2.api.request.PutAttributeRequest;
import com.mypurecloud.sdk.v2.model.Attribute;
import com.mypurecloud.sdk.v2.model.AttributeEntityListing;
import com.mypurecloud.sdk.v2.model.AttributeQueryRequest;
import java.io.IOException;

public class AttributesApi {
    private final ApiClient pcapiClient;

    public AttributesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AttributesApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteAttribute(String attributeId) throws IOException, ApiException {
        this.deleteAttribute(this.createDeleteAttributeRequest(attributeId));
    }

    public ApiResponse<Void> deleteAttributeWithHttpInfo(String attributeId) throws IOException {
        return this.deleteAttribute(this.createDeleteAttributeRequest(attributeId).withHttpInfo());
    }

    private DeleteAttributeRequest createDeleteAttributeRequest(String attributeId) {
        return DeleteAttributeRequest.builder().withAttributeId(attributeId).build();
    }

    public void deleteAttribute(DeleteAttributeRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse response = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteAttribute(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Attribute getAttribute(String attributeId) throws IOException, ApiException {
        return this.getAttribute(this.createGetAttributeRequest(attributeId));
    }

    public ApiResponse<Attribute> getAttributeWithHttpInfo(String attributeId) throws IOException {
        return this.getAttribute(this.createGetAttributeRequest(attributeId).withHttpInfo());
    }

    private GetAttributeRequest createGetAttributeRequest(String attributeId) {
        return GetAttributeRequest.builder().withAttributeId(attributeId).build();
    }

    public Attribute getAttribute(GetAttributeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Attribute> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Attribute>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Attribute> getAttribute(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Attribute>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AttributeEntityListing getAttributes(Integer pageNumber, Integer pageSize) throws IOException, ApiException {
        return this.getAttributes(this.createGetAttributesRequest(pageNumber, pageSize));
    }

    public ApiResponse<AttributeEntityListing> getAttributesWithHttpInfo(Integer pageNumber, Integer pageSize) throws IOException {
        return this.getAttributes(this.createGetAttributesRequest(pageNumber, pageSize).withHttpInfo());
    }

    private GetAttributesRequest createGetAttributesRequest(Integer pageNumber, Integer pageSize) {
        return GetAttributesRequest.builder().withPageNumber(pageNumber).withPageSize(pageSize).build();
    }

    public AttributeEntityListing getAttributes(GetAttributesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AttributeEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AttributeEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AttributeEntityListing> getAttributes(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AttributeEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Attribute postAttributes(Attribute body) throws IOException, ApiException {
        return this.postAttributes(this.createPostAttributesRequest(body));
    }

    public ApiResponse<Attribute> postAttributesWithHttpInfo(Attribute body) throws IOException {
        return this.postAttributes(this.createPostAttributesRequest(body).withHttpInfo());
    }

    private PostAttributesRequest createPostAttributesRequest(Attribute body) {
        return PostAttributesRequest.builder().withBody(body).build();
    }

    public Attribute postAttributes(PostAttributesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Attribute> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Attribute>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Attribute> postAttributes(ApiRequest<Attribute> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Attribute>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AttributeEntityListing postAttributesQuery(AttributeQueryRequest body) throws IOException, ApiException {
        return this.postAttributesQuery(this.createPostAttributesQueryRequest(body));
    }

    public ApiResponse<AttributeEntityListing> postAttributesQueryWithHttpInfo(AttributeQueryRequest body) throws IOException {
        return this.postAttributesQuery(this.createPostAttributesQueryRequest(body).withHttpInfo());
    }

    private PostAttributesQueryRequest createPostAttributesQueryRequest(AttributeQueryRequest body) {
        return PostAttributesQueryRequest.builder().withBody(body).build();
    }

    public AttributeEntityListing postAttributesQuery(PostAttributesQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AttributeEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AttributeEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AttributeEntityListing> postAttributesQuery(ApiRequest<AttributeQueryRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AttributeEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Attribute putAttribute(String attributeId, Attribute body) throws IOException, ApiException {
        return this.putAttribute(this.createPutAttributeRequest(attributeId, body));
    }

    public ApiResponse<Attribute> putAttributeWithHttpInfo(String attributeId, Attribute body) throws IOException {
        return this.putAttribute(this.createPutAttributeRequest(attributeId, body).withHttpInfo());
    }

    private PutAttributeRequest createPutAttributeRequest(String attributeId, Attribute body) {
        return PutAttributeRequest.builder().withAttributeId(attributeId).withBody(body).build();
    }

    public Attribute putAttribute(PutAttributeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Attribute> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Attribute>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Attribute> putAttribute(ApiRequest<Attribute> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Attribute>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

