/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.InboundRoute;
import java.util.HashMap;
import java.util.Map;

public class PutRoutingEmailDomainRouteRequest {
    private String domainName;
    private String routeId;
    private InboundRoute body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public PutRoutingEmailDomainRouteRequest withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public PutRoutingEmailDomainRouteRequest withRouteId(String routeId) {
        this.setRouteId(routeId);
        return this;
    }

    public InboundRoute getBody() {
        return this.body;
    }

    public void setBody(InboundRoute body) {
        this.body = body;
    }

    public PutRoutingEmailDomainRouteRequest withBody(InboundRoute body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutRoutingEmailDomainRouteRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<InboundRoute> withHttpInfo() {
        if (this.domainName == null) {
            throw new IllegalStateException("Missing the required parameter 'domainName' when building request for PutRoutingEmailDomainRouteRequest.");
        }
        if (this.routeId == null) {
            throw new IllegalStateException("Missing the required parameter 'routeId' when building request for PutRoutingEmailDomainRouteRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutRoutingEmailDomainRouteRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/routing/email/domains/{domainName}/routes/{routeId}").withPathParameter("domainName", this.domainName).withPathParameter("routeId", this.routeId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String domainName, String routeId, InboundRoute body) {
        return new Builder().withRequiredParams(domainName, routeId, body);
    }

    public static class Builder {
        private final PutRoutingEmailDomainRouteRequest request = new PutRoutingEmailDomainRouteRequest();

        private Builder() {
        }

        public Builder withDomainName(String domainName) {
            this.request.setDomainName(domainName);
            return this;
        }

        public Builder withRouteId(String routeId) {
            this.request.setRouteId(routeId);
            return this;
        }

        public Builder withBody(InboundRoute body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String domainName, String routeId, InboundRoute body) {
            this.request.setDomainName(domainName);
            this.request.setRouteId(routeId);
            this.request.setBody(body);
            return this;
        }

        public PutRoutingEmailDomainRouteRequest build() {
            if (this.request.domainName == null) {
                throw new IllegalStateException("Missing the required parameter 'domainName' when building request for PutRoutingEmailDomainRouteRequest.");
            }
            if (this.request.routeId == null) {
                throw new IllegalStateException("Missing the required parameter 'routeId' when building request for PutRoutingEmailDomainRouteRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutRoutingEmailDomainRouteRequest.");
            }
            return this.request;
        }
    }
}

