/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetMessagingStickerRequest;
import com.mypurecloud.sdk.v2.model.MessagingStickerEntityListing;
import java.io.IOException;

public class MessagingApi {
    private final ApiClient pcapiClient;

    public MessagingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MessagingApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public MessagingStickerEntityListing getMessagingSticker(String messengerType, Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        return this.getMessagingSticker(this.createGetMessagingStickerRequest(messengerType, pageSize, pageNumber));
    }

    public ApiResponse<MessagingStickerEntityListing> getMessagingStickerWithHttpInfo(String messengerType, Integer pageSize, Integer pageNumber) throws IOException {
        return this.getMessagingSticker(this.createGetMessagingStickerRequest(messengerType, pageSize, pageNumber).withHttpInfo());
    }

    private GetMessagingStickerRequest createGetMessagingStickerRequest(String messengerType, Integer pageSize, Integer pageNumber) {
        return GetMessagingStickerRequest.builder().withMessengerType(messengerType).withPageSize(pageSize).withPageNumber(pageNumber).build();
    }

    public MessagingStickerEntityListing getMessagingSticker(GetMessagingStickerRequest request) throws IOException, ApiException {
        try {
            ApiResponse<MessagingStickerEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<MessagingStickerEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<MessagingStickerEntityListing> getMessagingSticker(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<MessagingStickerEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

