/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class AnalyticsUserPresenceRecord
implements Serializable {
    private Date startTime = null;
    private Date endTime = null;
    private SystemPresenceEnum systemPresence = null;
    private String organizationPresenceId = null;

    public AnalyticsUserPresenceRecord startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The start time of the record. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startTime")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public AnalyticsUserPresenceRecord endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The end time of the record. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="endTime")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public AnalyticsUserPresenceRecord systemPresence(SystemPresenceEnum systemPresence) {
        this.systemPresence = systemPresence;
        return this;
    }

    @ApiModelProperty(example="null", value="The user's system presence")
    @JsonProperty(value="systemPresence")
    public SystemPresenceEnum getSystemPresence() {
        return this.systemPresence;
    }

    public void setSystemPresence(SystemPresenceEnum systemPresence) {
        this.systemPresence = systemPresence;
    }

    public AnalyticsUserPresenceRecord organizationPresenceId(String organizationPresenceId) {
        this.organizationPresenceId = organizationPresenceId;
        return this;
    }

    @ApiModelProperty(example="null", value="The identifier for the user's organization presence")
    @JsonProperty(value="organizationPresenceId")
    public String getOrganizationPresenceId() {
        return this.organizationPresenceId;
    }

    public void setOrganizationPresenceId(String organizationPresenceId) {
        this.organizationPresenceId = organizationPresenceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsUserPresenceRecord analyticsUserPresenceRecord = (AnalyticsUserPresenceRecord)o;
        return Objects.equals(this.startTime, analyticsUserPresenceRecord.startTime) && Objects.equals(this.endTime, analyticsUserPresenceRecord.endTime) && Objects.equals((Object)this.systemPresence, (Object)analyticsUserPresenceRecord.systemPresence) && Objects.equals(this.organizationPresenceId, analyticsUserPresenceRecord.organizationPresenceId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startTime, this.endTime, this.systemPresence, this.organizationPresenceId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsUserPresenceRecord {\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    systemPresence: ").append(this.toIndentedString((Object)this.systemPresence)).append("\n");
        sb.append("    organizationPresenceId: ").append(this.toIndentedString(this.organizationPresenceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SystemPresenceEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AVAILABLE("AVAILABLE"),
        AWAY("AWAY"),
        BUSY("BUSY"),
        OFFLINE("OFFLINE"),
        IDLE("IDLE"),
        ON_QUEUE("ON_QUEUE"),
        MEAL("MEAL"),
        TRAINING("TRAINING"),
        MEETING("MEETING"),
        BREAK("BREAK");

        private String value;

        private SystemPresenceEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SystemPresenceEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SystemPresenceEnum value : SystemPresenceEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SystemPresenceEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

