/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.MessageInfo;
import com.mypurecloud.sdk.v2.model.PropertyChange;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AuditLogMessage
implements Serializable {
    private String id = null;
    private AddressableEntityRef user = null;
    private AddressableEntityRef client = null;
    private List<String> remoteIp = new ArrayList<String>();
    private ServiceNameEnum serviceName = null;
    private Date eventDate = null;
    private MessageInfo message = null;
    private ActionEnum action = null;
    private AddressableEntityRef entity = null;
    private EntityTypeEnum entityType = null;
    private List<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
    private Map<String, String> context = null;

    public AuditLogMessage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Id of the audit message.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AuditLogMessage user(AddressableEntityRef user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="User associated with this audit message.")
    @JsonProperty(value="user")
    public AddressableEntityRef getUser() {
        return this.user;
    }

    public void setUser(AddressableEntityRef user) {
        this.user = user;
    }

    public AuditLogMessage client(AddressableEntityRef client) {
        this.client = client;
        return this;
    }

    @ApiModelProperty(example="null", value="Client associated with this audit message.")
    @JsonProperty(value="client")
    public AddressableEntityRef getClient() {
        return this.client;
    }

    public void setClient(AddressableEntityRef client) {
        this.client = client;
    }

    public AuditLogMessage remoteIp(List<String> remoteIp) {
        this.remoteIp = remoteIp;
        return this;
    }

    @ApiModelProperty(example="null", value="List of IP addresses of systems that originated or handled the request.")
    @JsonProperty(value="remoteIp")
    public List<String> getRemoteIp() {
        return this.remoteIp;
    }

    public void setRemoteIp(List<String> remoteIp) {
        this.remoteIp = remoteIp;
    }

    public AuditLogMessage serviceName(ServiceNameEnum serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the service that logged this audit message.")
    @JsonProperty(value="serviceName")
    public ServiceNameEnum getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(ServiceNameEnum serviceName) {
        this.serviceName = serviceName;
    }

    public AuditLogMessage eventDate(Date eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date and time of when the audit message was logged. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="eventDate")
    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public AuditLogMessage message(MessageInfo message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(example="null", value="Message describing the event being audited.")
    @JsonProperty(value="message")
    public MessageInfo getMessage() {
        return this.message;
    }

    public void setMessage(MessageInfo message) {
        this.message = message;
    }

    public AuditLogMessage action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", value="Action that took place.")
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public AuditLogMessage entity(AddressableEntityRef entity) {
        this.entity = entity;
        return this;
    }

    @ApiModelProperty(example="null", value="Entity that was impacted.")
    @JsonProperty(value="entity")
    public AddressableEntityRef getEntity() {
        return this.entity;
    }

    public void setEntity(AddressableEntityRef entity) {
        this.entity = entity;
    }

    public AuditLogMessage entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the entity that was impacted.")
    @JsonProperty(value="entityType")
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public AuditLogMessage propertyChanges(List<PropertyChange> propertyChanges) {
        this.propertyChanges = propertyChanges;
        return this;
    }

    @ApiModelProperty(example="null", value="List of properties that were changed and changes made to those properties.")
    @JsonProperty(value="propertyChanges")
    public List<PropertyChange> getPropertyChanges() {
        return this.propertyChanges;
    }

    public void setPropertyChanges(List<PropertyChange> propertyChanges) {
        this.propertyChanges = propertyChanges;
    }

    public AuditLogMessage context(Map<String, String> context) {
        this.context = context;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional context for this message.")
    @JsonProperty(value="context")
    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogMessage auditLogMessage = (AuditLogMessage)o;
        return Objects.equals(this.id, auditLogMessage.id) && Objects.equals(this.user, auditLogMessage.user) && Objects.equals(this.client, auditLogMessage.client) && Objects.equals(this.remoteIp, auditLogMessage.remoteIp) && Objects.equals((Object)this.serviceName, (Object)auditLogMessage.serviceName) && Objects.equals(this.eventDate, auditLogMessage.eventDate) && Objects.equals(this.message, auditLogMessage.message) && Objects.equals((Object)this.action, (Object)auditLogMessage.action) && Objects.equals(this.entity, auditLogMessage.entity) && Objects.equals((Object)this.entityType, (Object)auditLogMessage.entityType) && Objects.equals(this.propertyChanges, auditLogMessage.propertyChanges) && Objects.equals(this.context, auditLogMessage.context);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.user, this.client, this.remoteIp, this.serviceName, this.eventDate, this.message, this.action, this.entity, this.entityType, this.propertyChanges, this.context});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditLogMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    client: ").append(this.toIndentedString(this.client)).append("\n");
        sb.append("    remoteIp: ").append(this.toIndentedString(this.remoteIp)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString((Object)this.serviceName)).append("\n");
        sb.append("    eventDate: ").append(this.toIndentedString(this.eventDate)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    propertyChanges: ").append(this.toIndentedString(this.propertyChanges)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EntityTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DOCUMENT("Document"),
        QUEUE("Queue"),
        RECORDING("Recording"),
        ROLE("Role"),
        VOICEMAILUSERPOLICY("VoicemailUserPolicy"),
        WRAPUPCODE("WrapupCode"),
        ACCESSTOKEN("AccessToken"),
        OAUTHCLIENT("OAuthClient"),
        OAUTHCLIENTAUTHORIZATION("OAuthClientAuthorization"),
        AUTHORGANIZATION("AuthOrganization"),
        AUTHUSER("AuthUser"),
        BULKACTIONS("BulkActions"),
        FEEDBACK("Feedback"),
        TOPIC("Topic"),
        PROGRAM("Program");

        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EntityTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EntityTypeEnum value : EntityTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EntityTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CREATE("Create"),
        VIEW("View"),
        UPDATE("Update"),
        DELETE("Delete"),
        DOWNLOAD("Download"),
        MEMBERADD("MemberAdd"),
        MEMBERUPDATE("MemberUpdate"),
        MEMBERREMOVE("MemberRemove"),
        READ("Read"),
        READALL("ReadAll"),
        EXECUTE("Execute"),
        PUBLISH("Publish"),
        AUTHORIZE("Authorize"),
        DEAUTHORIZE("Deauthorize"),
        AUTHENTICATE("Authenticate"),
        CHANGEPASSWORD("ChangePassword");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionEnum value : ActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ServiceNameEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CONTACTCENTER("ContactCenter"),
        CONTENTMANAGEMENT("ContentManagement"),
        PEOPLEPERMISSIONS("PeoplePermissions"),
        QUALITY("Quality"),
        LANGUAGEUNDERSTANDING("LanguageUnderstanding"),
        TOPICSDEFINITIONSSERVICE("TopicsDefinitionsService");

        private String value;

        private ServiceNameEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ServiceNameEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ServiceNameEnum value : ServiceNameEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ServiceNameEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

