/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.Segment;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Screenshare
implements Serializable {
    private StateEnum state = null;
    private String id = null;
    private String context = null;
    private Boolean sharing = null;
    private Integer peerCount = null;
    private DisconnectTypeEnum disconnectType = null;
    private Date startAlertingTime = null;
    private Date connectedTime = null;
    private Date disconnectedTime = null;
    private String provider = null;
    private String peerId = null;
    private List<Segment> segments = new ArrayList<Segment>();

    public Screenshare state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The connection state of this communication.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Screenshare id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for this communication.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Screenshare context(String context) {
        this.context = context;
        return this;
    }

    @ApiModelProperty(example="null", value="The room id context (xmpp jid) for the conference session.")
    @JsonProperty(value="context")
    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public Screenshare sharing(Boolean sharing) {
        this.sharing = sharing;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether this participant is sharing their screen.")
    @JsonProperty(value="sharing")
    public Boolean getSharing() {
        return this.sharing;
    }

    public void setSharing(Boolean sharing) {
        this.sharing = sharing;
    }

    public Screenshare peerCount(Integer peerCount) {
        this.peerCount = peerCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of peer participants from the perspective of the participant in the conference.")
    @JsonProperty(value="peerCount")
    public Integer getPeerCount() {
        return this.peerCount;
    }

    public void setPeerCount(Integer peerCount) {
        this.peerCount = peerCount;
    }

    public Screenshare disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public Screenshare startAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the communication has when it is first put into an alerting state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="startAlertingTime")
    public Date getStartAlertingTime() {
        return this.startAlertingTime;
    }

    public void setStartAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
    }

    public Screenshare connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public Screenshare disconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="disconnectedTime")
    public Date getDisconnectedTime() {
        return this.disconnectedTime;
    }

    public void setDisconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
    }

    public Screenshare provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the screen share.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public Screenshare peerId(String peerId) {
        this.peerId = peerId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the peer communication corresponding to a matching leg for this communication.")
    @JsonProperty(value="peerId")
    public String getPeerId() {
        return this.peerId;
    }

    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    public Screenshare segments(List<Segment> segments) {
        this.segments = segments;
        return this;
    }

    @ApiModelProperty(example="null", value="The time line of the participant's call, divided into activity segments.")
    @JsonProperty(value="segments")
    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Screenshare screenshare = (Screenshare)o;
        return Objects.equals((Object)this.state, (Object)screenshare.state) && Objects.equals(this.id, screenshare.id) && Objects.equals(this.context, screenshare.context) && Objects.equals(this.sharing, screenshare.sharing) && Objects.equals(this.peerCount, screenshare.peerCount) && Objects.equals((Object)this.disconnectType, (Object)screenshare.disconnectType) && Objects.equals(this.startAlertingTime, screenshare.startAlertingTime) && Objects.equals(this.connectedTime, screenshare.connectedTime) && Objects.equals(this.disconnectedTime, screenshare.disconnectedTime) && Objects.equals(this.provider, screenshare.provider) && Objects.equals(this.peerId, screenshare.peerId) && Objects.equals(this.segments, screenshare.segments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.id, this.context, this.sharing, this.peerCount, this.disconnectType, this.startAlertingTime, this.connectedTime, this.disconnectedTime, this.provider, this.peerId, this.segments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Screenshare {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    sharing: ").append(this.toIndentedString(this.sharing)).append("\n");
        sb.append("    peerCount: ").append(this.toIndentedString(this.peerCount)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    startAlertingTime: ").append(this.toIndentedString(this.startAlertingTime)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    disconnectedTime: ").append(this.toIndentedString(this.disconnectedTime)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    peerId: ").append(this.toIndentedString(this.peerId)).append("\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        CLIENT("client"),
        SYSTEM("system"),
        TIMEOUT("timeout"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_FORWARD("transfer.forward"),
        TRANSFER_NOANSWER("transfer.noanswer"),
        TRANSFER_NOTAVAILABLE("transfer.notavailable"),
        TRANSPORT_FAILURE("transport.failure"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        SPAM("spam"),
        UNCALLABLE("uncallable");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

