/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.SetWrapperDayOfWeek;
import com.mypurecloud.sdk.v2.model.WorkPlanActivity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Shift in a work plan")
public class WorkPlanShift
implements Serializable {
    private String name = null;
    private SetWrapperDayOfWeek days = null;
    private Boolean flexibleStartTime = null;
    private Integer exactStartTimeMinutesFromMidnight = null;
    private Integer earliestStartTimeMinutesFromMidnight = null;
    private Integer latestStartTimeMinutesFromMidnight = null;
    private Boolean constrainStopTime = null;
    private Boolean constrainLatestStopTime = null;
    private Integer latestStopTimeMinutesFromMidnight = null;
    private Integer startIncrementMinutes = null;
    private Boolean flexiblePaidTime = null;
    private Integer exactPaidTimeMinutes = null;
    private Integer minimumPaidTimeMinutes = null;
    private Integer maximumPaidTimeMinutes = null;
    private Boolean constrainContiguousWorkTime = null;
    private Integer minimumContiguousWorkTimeMinutes = null;
    private Integer maximumContiguousWorkTimeMinutes = null;
    private List<WorkPlanActivity> activities = new ArrayList<WorkPlanActivity>();
    private String id = null;
    private Boolean delete = null;

    public WorkPlanShift name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the shift")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkPlanShift days(SetWrapperDayOfWeek days) {
        this.days = days;
        return this;
    }

    @ApiModelProperty(example="null", value="Days of the week applicable for this shift")
    @JsonProperty(value="days")
    public SetWrapperDayOfWeek getDays() {
        return this.days;
    }

    public void setDays(SetWrapperDayOfWeek days) {
        this.days = days;
    }

    public WorkPlanShift flexibleStartTime(Boolean flexibleStartTime) {
        this.flexibleStartTime = flexibleStartTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the start time of the shift is flexible")
    @JsonProperty(value="flexibleStartTime")
    public Boolean getFlexibleStartTime() {
        return this.flexibleStartTime;
    }

    public void setFlexibleStartTime(Boolean flexibleStartTime) {
        this.flexibleStartTime = flexibleStartTime;
    }

    public WorkPlanShift exactStartTimeMinutesFromMidnight(Integer exactStartTimeMinutesFromMidnight) {
        this.exactStartTimeMinutesFromMidnight = exactStartTimeMinutesFromMidnight;
        return this;
    }

    @ApiModelProperty(example="null", value="Exact start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == false")
    @JsonProperty(value="exactStartTimeMinutesFromMidnight")
    public Integer getExactStartTimeMinutesFromMidnight() {
        return this.exactStartTimeMinutesFromMidnight;
    }

    public void setExactStartTimeMinutesFromMidnight(Integer exactStartTimeMinutesFromMidnight) {
        this.exactStartTimeMinutesFromMidnight = exactStartTimeMinutesFromMidnight;
    }

    public WorkPlanShift earliestStartTimeMinutesFromMidnight(Integer earliestStartTimeMinutesFromMidnight) {
        this.earliestStartTimeMinutesFromMidnight = earliestStartTimeMinutesFromMidnight;
        return this;
    }

    @ApiModelProperty(example="null", value="Earliest start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == true")
    @JsonProperty(value="earliestStartTimeMinutesFromMidnight")
    public Integer getEarliestStartTimeMinutesFromMidnight() {
        return this.earliestStartTimeMinutesFromMidnight;
    }

    public void setEarliestStartTimeMinutesFromMidnight(Integer earliestStartTimeMinutesFromMidnight) {
        this.earliestStartTimeMinutesFromMidnight = earliestStartTimeMinutesFromMidnight;
    }

    public WorkPlanShift latestStartTimeMinutesFromMidnight(Integer latestStartTimeMinutesFromMidnight) {
        this.latestStartTimeMinutesFromMidnight = latestStartTimeMinutesFromMidnight;
        return this;
    }

    @ApiModelProperty(example="null", value="Latest start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == true")
    @JsonProperty(value="latestStartTimeMinutesFromMidnight")
    public Integer getLatestStartTimeMinutesFromMidnight() {
        return this.latestStartTimeMinutesFromMidnight;
    }

    public void setLatestStartTimeMinutesFromMidnight(Integer latestStartTimeMinutesFromMidnight) {
        this.latestStartTimeMinutesFromMidnight = latestStartTimeMinutesFromMidnight;
    }

    public WorkPlanShift constrainStopTime(Boolean constrainStopTime) {
        this.constrainStopTime = constrainStopTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the latest stop time constraint for the shift is enabled")
    @JsonProperty(value="constrainStopTime")
    public Boolean getConstrainStopTime() {
        return this.constrainStopTime;
    }

    public void setConstrainStopTime(Boolean constrainStopTime) {
        this.constrainStopTime = constrainStopTime;
    }

    public WorkPlanShift constrainLatestStopTime(Boolean constrainLatestStopTime) {
        this.constrainLatestStopTime = constrainLatestStopTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the latest stop time constraint for the shift is enabled")
    @JsonProperty(value="constrainLatestStopTime")
    public Boolean getConstrainLatestStopTime() {
        return this.constrainLatestStopTime;
    }

    public void setConstrainLatestStopTime(Boolean constrainLatestStopTime) {
        this.constrainLatestStopTime = constrainLatestStopTime;
    }

    public WorkPlanShift latestStopTimeMinutesFromMidnight(Integer latestStopTimeMinutesFromMidnight) {
        this.latestStopTimeMinutesFromMidnight = latestStopTimeMinutesFromMidnight;
        return this;
    }

    @ApiModelProperty(example="null", value="Latest stop time of the shift defined as offset minutes from midnight. Used if constrainStopTime == true")
    @JsonProperty(value="latestStopTimeMinutesFromMidnight")
    public Integer getLatestStopTimeMinutesFromMidnight() {
        return this.latestStopTimeMinutesFromMidnight;
    }

    public void setLatestStopTimeMinutesFromMidnight(Integer latestStopTimeMinutesFromMidnight) {
        this.latestStopTimeMinutesFromMidnight = latestStopTimeMinutesFromMidnight;
    }

    public WorkPlanShift startIncrementMinutes(Integer startIncrementMinutes) {
        this.startIncrementMinutes = startIncrementMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Increment in offset minutes that would contribute to different possible start times for the shift. Used if flexibleStartTime == true")
    @JsonProperty(value="startIncrementMinutes")
    public Integer getStartIncrementMinutes() {
        return this.startIncrementMinutes;
    }

    public void setStartIncrementMinutes(Integer startIncrementMinutes) {
        this.startIncrementMinutes = startIncrementMinutes;
    }

    public WorkPlanShift flexiblePaidTime(Boolean flexiblePaidTime) {
        this.flexiblePaidTime = flexiblePaidTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the paid time setting for the shift is flexible")
    @JsonProperty(value="flexiblePaidTime")
    public Boolean getFlexiblePaidTime() {
        return this.flexiblePaidTime;
    }

    public void setFlexiblePaidTime(Boolean flexiblePaidTime) {
        this.flexiblePaidTime = flexiblePaidTime;
    }

    public WorkPlanShift exactPaidTimeMinutes(Integer exactPaidTimeMinutes) {
        this.exactPaidTimeMinutes = exactPaidTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Exact paid time in minutes configured for the shift. Used if flexiblePaidTime == false")
    @JsonProperty(value="exactPaidTimeMinutes")
    public Integer getExactPaidTimeMinutes() {
        return this.exactPaidTimeMinutes;
    }

    public void setExactPaidTimeMinutes(Integer exactPaidTimeMinutes) {
        this.exactPaidTimeMinutes = exactPaidTimeMinutes;
    }

    public WorkPlanShift minimumPaidTimeMinutes(Integer minimumPaidTimeMinutes) {
        this.minimumPaidTimeMinutes = minimumPaidTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Minimum paid time in minutes configured for the shift. Used if flexiblePaidTime == true")
    @JsonProperty(value="minimumPaidTimeMinutes")
    public Integer getMinimumPaidTimeMinutes() {
        return this.minimumPaidTimeMinutes;
    }

    public void setMinimumPaidTimeMinutes(Integer minimumPaidTimeMinutes) {
        this.minimumPaidTimeMinutes = minimumPaidTimeMinutes;
    }

    public WorkPlanShift maximumPaidTimeMinutes(Integer maximumPaidTimeMinutes) {
        this.maximumPaidTimeMinutes = maximumPaidTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Maximum paid time in minutes configured for the shift. Used if flexiblePaidTime == true")
    @JsonProperty(value="maximumPaidTimeMinutes")
    public Integer getMaximumPaidTimeMinutes() {
        return this.maximumPaidTimeMinutes;
    }

    public void setMaximumPaidTimeMinutes(Integer maximumPaidTimeMinutes) {
        this.maximumPaidTimeMinutes = maximumPaidTimeMinutes;
    }

    public WorkPlanShift constrainContiguousWorkTime(Boolean constrainContiguousWorkTime) {
        this.constrainContiguousWorkTime = constrainContiguousWorkTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the contiguous time constraint for the shift is enabled")
    @JsonProperty(value="constrainContiguousWorkTime")
    public Boolean getConstrainContiguousWorkTime() {
        return this.constrainContiguousWorkTime;
    }

    public void setConstrainContiguousWorkTime(Boolean constrainContiguousWorkTime) {
        this.constrainContiguousWorkTime = constrainContiguousWorkTime;
    }

    public WorkPlanShift minimumContiguousWorkTimeMinutes(Integer minimumContiguousWorkTimeMinutes) {
        this.minimumContiguousWorkTimeMinutes = minimumContiguousWorkTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Minimum contiguous time in minutes configured for the shift. Used if constrainContiguousWorkTime == true")
    @JsonProperty(value="minimumContiguousWorkTimeMinutes")
    public Integer getMinimumContiguousWorkTimeMinutes() {
        return this.minimumContiguousWorkTimeMinutes;
    }

    public void setMinimumContiguousWorkTimeMinutes(Integer minimumContiguousWorkTimeMinutes) {
        this.minimumContiguousWorkTimeMinutes = minimumContiguousWorkTimeMinutes;
    }

    public WorkPlanShift maximumContiguousWorkTimeMinutes(Integer maximumContiguousWorkTimeMinutes) {
        this.maximumContiguousWorkTimeMinutes = maximumContiguousWorkTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Maximum contiguous time in minutes configured for the shift. Used if constrainContiguousWorkTime == true")
    @JsonProperty(value="maximumContiguousWorkTimeMinutes")
    public Integer getMaximumContiguousWorkTimeMinutes() {
        return this.maximumContiguousWorkTimeMinutes;
    }

    public void setMaximumContiguousWorkTimeMinutes(Integer maximumContiguousWorkTimeMinutes) {
        this.maximumContiguousWorkTimeMinutes = maximumContiguousWorkTimeMinutes;
    }

    public WorkPlanShift activities(List<WorkPlanActivity> activities) {
        this.activities = activities;
        return this;
    }

    @ApiModelProperty(example="null", value="Activities configured for this shift")
    @JsonProperty(value="activities")
    public List<WorkPlanActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<WorkPlanActivity> activities) {
        this.activities = activities;
    }

    public WorkPlanShift id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the shift. This is required only for the case of updating an existing shift")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorkPlanShift delete(Boolean delete) {
        this.delete = delete;
        return this;
    }

    @ApiModelProperty(example="null", value="If marked true for updating an existing shift, the shift will be permanently deleted")
    @JsonProperty(value="delete")
    public Boolean getDelete() {
        return this.delete;
    }

    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkPlanShift workPlanShift = (WorkPlanShift)o;
        return Objects.equals(this.name, workPlanShift.name) && Objects.equals(this.days, workPlanShift.days) && Objects.equals(this.flexibleStartTime, workPlanShift.flexibleStartTime) && Objects.equals(this.exactStartTimeMinutesFromMidnight, workPlanShift.exactStartTimeMinutesFromMidnight) && Objects.equals(this.earliestStartTimeMinutesFromMidnight, workPlanShift.earliestStartTimeMinutesFromMidnight) && Objects.equals(this.latestStartTimeMinutesFromMidnight, workPlanShift.latestStartTimeMinutesFromMidnight) && Objects.equals(this.constrainStopTime, workPlanShift.constrainStopTime) && Objects.equals(this.constrainLatestStopTime, workPlanShift.constrainLatestStopTime) && Objects.equals(this.latestStopTimeMinutesFromMidnight, workPlanShift.latestStopTimeMinutesFromMidnight) && Objects.equals(this.startIncrementMinutes, workPlanShift.startIncrementMinutes) && Objects.equals(this.flexiblePaidTime, workPlanShift.flexiblePaidTime) && Objects.equals(this.exactPaidTimeMinutes, workPlanShift.exactPaidTimeMinutes) && Objects.equals(this.minimumPaidTimeMinutes, workPlanShift.minimumPaidTimeMinutes) && Objects.equals(this.maximumPaidTimeMinutes, workPlanShift.maximumPaidTimeMinutes) && Objects.equals(this.constrainContiguousWorkTime, workPlanShift.constrainContiguousWorkTime) && Objects.equals(this.minimumContiguousWorkTimeMinutes, workPlanShift.minimumContiguousWorkTimeMinutes) && Objects.equals(this.maximumContiguousWorkTimeMinutes, workPlanShift.maximumContiguousWorkTimeMinutes) && Objects.equals(this.activities, workPlanShift.activities) && Objects.equals(this.id, workPlanShift.id) && Objects.equals(this.delete, workPlanShift.delete);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.days, this.flexibleStartTime, this.exactStartTimeMinutesFromMidnight, this.earliestStartTimeMinutesFromMidnight, this.latestStartTimeMinutesFromMidnight, this.constrainStopTime, this.constrainLatestStopTime, this.latestStopTimeMinutesFromMidnight, this.startIncrementMinutes, this.flexiblePaidTime, this.exactPaidTimeMinutes, this.minimumPaidTimeMinutes, this.maximumPaidTimeMinutes, this.constrainContiguousWorkTime, this.minimumContiguousWorkTimeMinutes, this.maximumContiguousWorkTimeMinutes, this.activities, this.id, this.delete);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkPlanShift {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    days: ").append(this.toIndentedString(this.days)).append("\n");
        sb.append("    flexibleStartTime: ").append(this.toIndentedString(this.flexibleStartTime)).append("\n");
        sb.append("    exactStartTimeMinutesFromMidnight: ").append(this.toIndentedString(this.exactStartTimeMinutesFromMidnight)).append("\n");
        sb.append("    earliestStartTimeMinutesFromMidnight: ").append(this.toIndentedString(this.earliestStartTimeMinutesFromMidnight)).append("\n");
        sb.append("    latestStartTimeMinutesFromMidnight: ").append(this.toIndentedString(this.latestStartTimeMinutesFromMidnight)).append("\n");
        sb.append("    constrainStopTime: ").append(this.toIndentedString(this.constrainStopTime)).append("\n");
        sb.append("    constrainLatestStopTime: ").append(this.toIndentedString(this.constrainLatestStopTime)).append("\n");
        sb.append("    latestStopTimeMinutesFromMidnight: ").append(this.toIndentedString(this.latestStopTimeMinutesFromMidnight)).append("\n");
        sb.append("    startIncrementMinutes: ").append(this.toIndentedString(this.startIncrementMinutes)).append("\n");
        sb.append("    flexiblePaidTime: ").append(this.toIndentedString(this.flexiblePaidTime)).append("\n");
        sb.append("    exactPaidTimeMinutes: ").append(this.toIndentedString(this.exactPaidTimeMinutes)).append("\n");
        sb.append("    minimumPaidTimeMinutes: ").append(this.toIndentedString(this.minimumPaidTimeMinutes)).append("\n");
        sb.append("    maximumPaidTimeMinutes: ").append(this.toIndentedString(this.maximumPaidTimeMinutes)).append("\n");
        sb.append("    constrainContiguousWorkTime: ").append(this.toIndentedString(this.constrainContiguousWorkTime)).append("\n");
        sb.append("    minimumContiguousWorkTimeMinutes: ").append(this.toIndentedString(this.minimumContiguousWorkTimeMinutes)).append("\n");
        sb.append("    maximumContiguousWorkTimeMinutes: ").append(this.toIndentedString(this.maximumContiguousWorkTimeMinutes)).append("\n");
        sb.append("    activities: ").append(this.toIndentedString(this.activities)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    delete: ").append(this.toIndentedString(this.delete)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

