/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.ConversationDetailQueryFilter;
import com.mypurecloud.sdk.v2.model.EvaluationDetailQueryFilter;
import com.mypurecloud.sdk.v2.model.MediaEndpointStatDetailQueryFilter;
import com.mypurecloud.sdk.v2.model.SegmentDetailQueryFilter;
import com.mypurecloud.sdk.v2.model.SurveyDetailQueryFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AsyncConversationQuery
implements Serializable {
    private String interval = null;
    private List<ConversationDetailQueryFilter> conversationFilters = new ArrayList<ConversationDetailQueryFilter>();
    private List<SegmentDetailQueryFilter> segmentFilters = new ArrayList<SegmentDetailQueryFilter>();
    private List<EvaluationDetailQueryFilter> evaluationFilters = new ArrayList<EvaluationDetailQueryFilter>();
    private List<MediaEndpointStatDetailQueryFilter> mediaEndpointStatFilters = new ArrayList<MediaEndpointStatDetailQueryFilter>();
    private List<SurveyDetailQueryFilter> surveyFilters = new ArrayList<SurveyDetailQueryFilter>();
    private OrderEnum order = null;
    private OrderByEnum orderBy = null;
    private Integer limit = null;
    private Boolean startOfDayIntervalMatching = null;

    public AsyncConversationQuery interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Specifies the date and time range of data being queried. Results will include conversations that both started on a day touched by the interval AND either started, ended, or any activity during the interval. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public AsyncConversationQuery conversationFilters(List<ConversationDetailQueryFilter> conversationFilters) {
        this.conversationFilters = conversationFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target conversation-level data")
    @JsonProperty(value="conversationFilters")
    public List<ConversationDetailQueryFilter> getConversationFilters() {
        return this.conversationFilters;
    }

    public void setConversationFilters(List<ConversationDetailQueryFilter> conversationFilters) {
        this.conversationFilters = conversationFilters;
    }

    public AsyncConversationQuery segmentFilters(List<SegmentDetailQueryFilter> segmentFilters) {
        this.segmentFilters = segmentFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target individual segments within a conversation")
    @JsonProperty(value="segmentFilters")
    public List<SegmentDetailQueryFilter> getSegmentFilters() {
        return this.segmentFilters;
    }

    public void setSegmentFilters(List<SegmentDetailQueryFilter> segmentFilters) {
        this.segmentFilters = segmentFilters;
    }

    public AsyncConversationQuery evaluationFilters(List<EvaluationDetailQueryFilter> evaluationFilters) {
        this.evaluationFilters = evaluationFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target evaluations")
    @JsonProperty(value="evaluationFilters")
    public List<EvaluationDetailQueryFilter> getEvaluationFilters() {
        return this.evaluationFilters;
    }

    public void setEvaluationFilters(List<EvaluationDetailQueryFilter> evaluationFilters) {
        this.evaluationFilters = evaluationFilters;
    }

    public AsyncConversationQuery mediaEndpointStatFilters(List<MediaEndpointStatDetailQueryFilter> mediaEndpointStatFilters) {
        this.mediaEndpointStatFilters = mediaEndpointStatFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target mediaEndpointStats")
    @JsonProperty(value="mediaEndpointStatFilters")
    public List<MediaEndpointStatDetailQueryFilter> getMediaEndpointStatFilters() {
        return this.mediaEndpointStatFilters;
    }

    public void setMediaEndpointStatFilters(List<MediaEndpointStatDetailQueryFilter> mediaEndpointStatFilters) {
        this.mediaEndpointStatFilters = mediaEndpointStatFilters;
    }

    public AsyncConversationQuery surveyFilters(List<SurveyDetailQueryFilter> surveyFilters) {
        this.surveyFilters = surveyFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target surveys")
    @JsonProperty(value="surveyFilters")
    public List<SurveyDetailQueryFilter> getSurveyFilters() {
        return this.surveyFilters;
    }

    public void setSurveyFilters(List<SurveyDetailQueryFilter> surveyFilters) {
        this.surveyFilters = surveyFilters;
    }

    public AsyncConversationQuery order(OrderEnum order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(example="null", value="Sort the result set in ascending/descending order. Default is ascending")
    @JsonProperty(value="order")
    public OrderEnum getOrder() {
        return this.order;
    }

    public void setOrder(OrderEnum order) {
        this.order = order;
    }

    public AsyncConversationQuery orderBy(OrderByEnum orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify which data element within the result set to use for sorting. The options  to use as a basis for sorting the results: conversationStart, segmentStart, and segmentEnd. If not specified, the default is conversationStart")
    @JsonProperty(value="orderBy")
    public OrderByEnum getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OrderByEnum orderBy) {
        this.orderBy = orderBy;
    }

    public AsyncConversationQuery limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify number of results to be returned")
    @JsonProperty(value="limit")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public AsyncConversationQuery startOfDayIntervalMatching(Boolean startOfDayIntervalMatching) {
        this.startOfDayIntervalMatching = startOfDayIntervalMatching;
        return this;
    }

    @ApiModelProperty(example="null", value="Add a filter to only include conversations that started after the beginning of the interval start date (UTC)")
    @JsonProperty(value="startOfDayIntervalMatching")
    public Boolean getStartOfDayIntervalMatching() {
        return this.startOfDayIntervalMatching;
    }

    public void setStartOfDayIntervalMatching(Boolean startOfDayIntervalMatching) {
        this.startOfDayIntervalMatching = startOfDayIntervalMatching;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncConversationQuery asyncConversationQuery = (AsyncConversationQuery)o;
        return Objects.equals(this.interval, asyncConversationQuery.interval) && Objects.equals(this.conversationFilters, asyncConversationQuery.conversationFilters) && Objects.equals(this.segmentFilters, asyncConversationQuery.segmentFilters) && Objects.equals(this.evaluationFilters, asyncConversationQuery.evaluationFilters) && Objects.equals(this.mediaEndpointStatFilters, asyncConversationQuery.mediaEndpointStatFilters) && Objects.equals(this.surveyFilters, asyncConversationQuery.surveyFilters) && Objects.equals((Object)this.order, (Object)asyncConversationQuery.order) && Objects.equals((Object)this.orderBy, (Object)asyncConversationQuery.orderBy) && Objects.equals(this.limit, asyncConversationQuery.limit) && Objects.equals(this.startOfDayIntervalMatching, asyncConversationQuery.startOfDayIntervalMatching);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.conversationFilters, this.segmentFilters, this.evaluationFilters, this.mediaEndpointStatFilters, this.surveyFilters, this.order, this.orderBy, this.limit, this.startOfDayIntervalMatching});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AsyncConversationQuery {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    conversationFilters: ").append(this.toIndentedString(this.conversationFilters)).append("\n");
        sb.append("    segmentFilters: ").append(this.toIndentedString(this.segmentFilters)).append("\n");
        sb.append("    evaluationFilters: ").append(this.toIndentedString(this.evaluationFilters)).append("\n");
        sb.append("    mediaEndpointStatFilters: ").append(this.toIndentedString(this.mediaEndpointStatFilters)).append("\n");
        sb.append("    surveyFilters: ").append(this.toIndentedString(this.surveyFilters)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("    orderBy: ").append(this.toIndentedString((Object)this.orderBy)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    startOfDayIntervalMatching: ").append(this.toIndentedString(this.startOfDayIntervalMatching)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OrderByEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CONVERSATIONSTART("conversationStart"),
        CONVERSATIONEND("conversationEnd"),
        SEGMENTSTART("segmentStart"),
        SEGMENTEND("segmentEnd");

        private String value;

        private OrderByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OrderByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OrderByEnum value : OrderByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OrderByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum OrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("asc"),
        DESC("desc");

        private String value;

        private OrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OrderEnum value : OrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

