/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="The meta object of the SCIM V2 implementation.")
public class ScimMetadata
implements Serializable {
    private ResourceTypeEnum resourceType = null;
    private Date lastModified = null;
    private String location = null;
    private String version = null;

    @ApiModelProperty(example="null", value="The type of SCIM resource.")
    @JsonProperty(value="resourceType")
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    @ApiModelProperty(example="null", value="The last time that the resource was modified. Date time is represented as an ISO-8601 string, for example, yyyy-MM-ddTHH:mm:ss.SSSZ.")
    @JsonProperty(value="lastModified")
    public Date getLastModified() {
        return this.lastModified;
    }

    @ApiModelProperty(example="null", value="The URI of the resource.")
    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    @ApiModelProperty(example="null", value="The version of the resource. Matches the ETag HTTP response header.")
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimMetadata scimMetadata = (ScimMetadata)o;
        return Objects.equals((Object)this.resourceType, (Object)scimMetadata.resourceType) && Objects.equals(this.lastModified, scimMetadata.lastModified) && Objects.equals(this.location, scimMetadata.location) && Objects.equals(this.version, scimMetadata.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourceType, this.lastModified, this.location, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimMetadata {\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ResourceTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        USER("User"),
        GROUP("Group"),
        SERVICEPROVIDERCONFIG("ServiceProviderConfig"),
        RESOURCETYPE("ResourceType");

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ResourceTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ResourceTypeEnum value : ResourceTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ResourceTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

