/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ScimV2Group;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="SCIM Group List Response")
public class ScimGroupListResponse
implements Serializable {
    private Long totalResults = null;
    private Long startIndex = null;
    private Long itemsPerPage = null;
    private List<ScimV2Group> resources = new ArrayList<ScimV2Group>();
    private List<String> schemas = new ArrayList<String>();

    @ApiModelProperty(example="null", value="The total number of results.")
    @JsonProperty(value="totalResults")
    public Long getTotalResults() {
        return this.totalResults;
    }

    @ApiModelProperty(example="null", value="The 1-based index of the first result returned by this request. Add this to \"itemsPerPage\" when requesting the next page of results.")
    @JsonProperty(value="startIndex")
    public Long getStartIndex() {
        return this.startIndex;
    }

    @ApiModelProperty(example="null", value="The number of resources returned per page.")
    @JsonProperty(value="itemsPerPage")
    public Long getItemsPerPage() {
        return this.itemsPerPage;
    }

    public ScimGroupListResponse resources(List<ScimV2Group> resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of requested resources. If \"count\" is 0, then the list will be empty.")
    @JsonProperty(value="Resources")
    public List<ScimV2Group> getResources() {
        return this.resources;
    }

    public void setResources(List<ScimV2Group> resources) {
        this.resources = resources;
    }

    public ScimGroupListResponse schemas(List<String> schemas) {
        this.schemas = schemas;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of supported schemas.")
    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimGroupListResponse scimGroupListResponse = (ScimGroupListResponse)o;
        return Objects.equals(this.totalResults, scimGroupListResponse.totalResults) && Objects.equals(this.startIndex, scimGroupListResponse.startIndex) && Objects.equals(this.itemsPerPage, scimGroupListResponse.itemsPerPage) && Objects.equals(this.resources, scimGroupListResponse.resources) && Objects.equals(this.schemas, scimGroupListResponse.schemas);
    }

    public int hashCode() {
        return Objects.hash(this.totalResults, this.startIndex, this.itemsPerPage, this.resources, this.schemas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScimGroupListResponse {\n");
        sb.append("    totalResults: ").append(this.toIndentedString(this.totalResults)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("    itemsPerPage: ").append(this.toIndentedString(this.itemsPerPage)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

