/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class ImportStatus
implements Serializable {
    private StateEnum state = null;
    private Long totalRecords = null;
    private Long completedRecords = null;
    private Integer percentComplete = null;
    private String failureReason = null;

    @ApiModelProperty(example="null", required=true, value="current status of the import")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    @ApiModelProperty(example="null", required=true, value="total number of records to be imported")
    @JsonProperty(value="totalRecords")
    public Long getTotalRecords() {
        return this.totalRecords;
    }

    @ApiModelProperty(example="null", required=true, value="number of records finished importing")
    @JsonProperty(value="completedRecords")
    public Long getCompletedRecords() {
        return this.completedRecords;
    }

    @ApiModelProperty(example="null", required=true, value="percentage of records finished importing")
    @JsonProperty(value="percentComplete")
    public Integer getPercentComplete() {
        return this.percentComplete;
    }

    @ApiModelProperty(example="null", value="if the import has failed, the reason for the failure")
    @JsonProperty(value="failureReason")
    public String getFailureReason() {
        return this.failureReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportStatus importStatus = (ImportStatus)o;
        return Objects.equals((Object)this.state, (Object)importStatus.state) && Objects.equals(this.totalRecords, importStatus.totalRecords) && Objects.equals(this.completedRecords, importStatus.completedRecords) && Objects.equals(this.percentComplete, importStatus.percentComplete) && Objects.equals(this.failureReason, importStatus.failureReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.totalRecords, this.completedRecords, this.percentComplete, this.failureReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportStatus {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    totalRecords: ").append(this.toIndentedString(this.totalRecords)).append("\n");
        sb.append("    completedRecords: ").append(this.toIndentedString(this.completedRecords)).append("\n");
        sb.append("    percentComplete: ").append(this.toIndentedString(this.percentComplete)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        IN_PROGRESS("IN_PROGRESS"),
        FAILED("FAILED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

