/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetUserAdjacentsRequest {
    private String userId;
    private List<String> expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public GetUserAdjacentsRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public GetUserAdjacentsRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetUserAdjacentsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetUserAdjacentsRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/users/{userId}/adjacents").withPathParameter("userId", this.userId).withQueryParameters("expand", "multi", this.expand).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId) {
        return new Builder().withRequiredParams(userId);
    }

    public static class Builder {
        private final GetUserAdjacentsRequest request = new GetUserAdjacentsRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withRequiredParams(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public GetUserAdjacentsRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetUserAdjacentsRequest.");
            }
            return this.request;
        }
    }
}

