/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetScimV2UserRequest {
    private String userId;
    private String ifNoneMatch;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public GetScimV2UserRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public void setIfNoneMatch(String ifNoneMatch) {
        this.ifNoneMatch = ifNoneMatch;
    }

    public GetScimV2UserRequest withIfNoneMatch(String ifNoneMatch) {
        this.setIfNoneMatch(ifNoneMatch);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetScimV2UserRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetScimV2UserRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/scim/v2/users/{userId}").withPathParameter("userId", this.userId).withHeaderParameter("If-None-Match", this.ifNoneMatch).withCustomHeaders(this.customHeaders).withContentTypes("application/json", "application/scim+json").withAccepts("application/json", "application/scim+json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId) {
        return new Builder().withRequiredParams(userId);
    }

    public static class Builder {
        private final GetScimV2UserRequest request = new GetScimV2UserRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withIfNoneMatch(String ifNoneMatch) {
            this.request.setIfNoneMatch(ifNoneMatch);
            return this;
        }

        public Builder withRequiredParams(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public GetScimV2UserRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetScimV2UserRequest.");
            }
            return this.request;
        }
    }
}

