/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.CredentialSpecification;
import com.mypurecloud.sdk.v2.model.HelpLink;
import com.mypurecloud.sdk.v2.model.UserImage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Descriptor for a type of Integration.")
public class IntegrationType
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private String provider = null;
    private String category = null;
    private List<UserImage> images = new ArrayList<UserImage>();
    private String configPropertiesSchemaUri = null;
    private String configAdvancedSchemaUri = null;
    private String helpUri = null;
    private String termsOfServiceUri = null;
    private String vendorName = null;
    private String vendorWebsiteUri = null;
    private String marketplaceUri = null;
    private String faqUri = null;
    private String privacyPolicyUri = null;
    private String supportContactUri = null;
    private String salesContactUri = null;
    private List<HelpLink> helpLinks = new ArrayList<HelpLink>();
    private Map<String, CredentialSpecification> credentials = null;
    private Boolean nonInstallable = null;
    private Integer maxInstances = null;
    private List<String> userPermissions = new ArrayList<String>();
    private String selfUri = null;

    public IntegrationType id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the integration type.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IntegrationType name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Description of the integration type.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(example="null", value="PureCloud provider of the integration type.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    @ApiModelProperty(example="null", value="Category describing the integration type.")
    @JsonProperty(value="category")
    public String getCategory() {
        return this.category;
    }

    public IntegrationType images(List<UserImage> images) {
        this.images = images;
        return this;
    }

    @ApiModelProperty(example="null", value="Collection of logos.")
    @JsonProperty(value="images")
    public List<UserImage> getImages() {
        return this.images;
    }

    public void setImages(List<UserImage> images) {
        this.images = images;
    }

    @ApiModelProperty(example="null", value="URI of the schema describing the key-value properties needed to configure an integration of this type.")
    @JsonProperty(value="configPropertiesSchemaUri")
    public String getConfigPropertiesSchemaUri() {
        return this.configPropertiesSchemaUri;
    }

    @ApiModelProperty(example="null", value="URI of the schema describing the advanced JSON document needed to configure an integration of this type.")
    @JsonProperty(value="configAdvancedSchemaUri")
    public String getConfigAdvancedSchemaUri() {
        return this.configAdvancedSchemaUri;
    }

    @ApiModelProperty(example="null", value="URI of a page with more information about the integration type")
    @JsonProperty(value="helpUri")
    public String getHelpUri() {
        return this.helpUri;
    }

    @ApiModelProperty(example="null", value="URI of a page with terms and conditions for the integration type")
    @JsonProperty(value="termsOfServiceUri")
    public String getTermsOfServiceUri() {
        return this.termsOfServiceUri;
    }

    @ApiModelProperty(example="null", value="Name of the vendor of this integration type")
    @JsonProperty(value="vendorName")
    public String getVendorName() {
        return this.vendorName;
    }

    @ApiModelProperty(example="null", value="URI of the vendor's website")
    @JsonProperty(value="vendorWebsiteUri")
    public String getVendorWebsiteUri() {
        return this.vendorWebsiteUri;
    }

    @ApiModelProperty(example="null", value="URI of the marketplace listing for this integration type")
    @JsonProperty(value="marketplaceUri")
    public String getMarketplaceUri() {
        return this.marketplaceUri;
    }

    @ApiModelProperty(example="null", value="URI of frequently asked questions about the integration type")
    @JsonProperty(value="faqUri")
    public String getFaqUri() {
        return this.faqUri;
    }

    @ApiModelProperty(example="null", value="URI of a privacy policy for users of the integration type")
    @JsonProperty(value="privacyPolicyUri")
    public String getPrivacyPolicyUri() {
        return this.privacyPolicyUri;
    }

    @ApiModelProperty(example="null", value="URI for vendor support")
    @JsonProperty(value="supportContactUri")
    public String getSupportContactUri() {
        return this.supportContactUri;
    }

    @ApiModelProperty(example="null", value="URI for vendor sales information")
    @JsonProperty(value="salesContactUri")
    public String getSalesContactUri() {
        return this.salesContactUri;
    }

    public IntegrationType helpLinks(List<HelpLink> helpLinks) {
        this.helpLinks = helpLinks;
        return this;
    }

    @ApiModelProperty(example="null", value="List of links to additional help resources")
    @JsonProperty(value="helpLinks")
    public List<HelpLink> getHelpLinks() {
        return this.helpLinks;
    }

    public void setHelpLinks(List<HelpLink> helpLinks) {
        this.helpLinks = helpLinks;
    }

    public IntegrationType credentials(Map<String, CredentialSpecification> credentials) {
        this.credentials = credentials;
        return this;
    }

    @ApiModelProperty(example="null", value="Map of credentials for integrations of this type. The key is the name of a credential that can be provided in the credentials property of the integration configuration.")
    @JsonProperty(value="credentials")
    public Map<String, CredentialSpecification> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Map<String, CredentialSpecification> credentials) {
        this.credentials = credentials;
    }

    @ApiModelProperty(example="null", value="Indicates if the integration type is installable or not.")
    @JsonProperty(value="nonInstallable")
    public Boolean getNonInstallable() {
        return this.nonInstallable;
    }

    @ApiModelProperty(example="null", value="The maximum number of integration instances allowable for this integration type")
    @JsonProperty(value="maxInstances")
    public Integer getMaxInstances() {
        return this.maxInstances;
    }

    public IntegrationType userPermissions(List<String> userPermissions) {
        this.userPermissions = userPermissions;
        return this;
    }

    @ApiModelProperty(example="null", value="List of permissions required to permit user access to the integration type.")
    @JsonProperty(value="userPermissions")
    public List<String> getUserPermissions() {
        return this.userPermissions;
    }

    public void setUserPermissions(List<String> userPermissions) {
        this.userPermissions = userPermissions;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationType integrationType = (IntegrationType)o;
        return Objects.equals(this.id, integrationType.id) && Objects.equals(this.name, integrationType.name) && Objects.equals(this.description, integrationType.description) && Objects.equals(this.provider, integrationType.provider) && Objects.equals(this.category, integrationType.category) && Objects.equals(this.images, integrationType.images) && Objects.equals(this.configPropertiesSchemaUri, integrationType.configPropertiesSchemaUri) && Objects.equals(this.configAdvancedSchemaUri, integrationType.configAdvancedSchemaUri) && Objects.equals(this.helpUri, integrationType.helpUri) && Objects.equals(this.termsOfServiceUri, integrationType.termsOfServiceUri) && Objects.equals(this.vendorName, integrationType.vendorName) && Objects.equals(this.vendorWebsiteUri, integrationType.vendorWebsiteUri) && Objects.equals(this.marketplaceUri, integrationType.marketplaceUri) && Objects.equals(this.faqUri, integrationType.faqUri) && Objects.equals(this.privacyPolicyUri, integrationType.privacyPolicyUri) && Objects.equals(this.supportContactUri, integrationType.supportContactUri) && Objects.equals(this.salesContactUri, integrationType.salesContactUri) && Objects.equals(this.helpLinks, integrationType.helpLinks) && Objects.equals(this.credentials, integrationType.credentials) && Objects.equals(this.nonInstallable, integrationType.nonInstallable) && Objects.equals(this.maxInstances, integrationType.maxInstances) && Objects.equals(this.userPermissions, integrationType.userPermissions) && Objects.equals(this.selfUri, integrationType.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.provider, this.category, this.images, this.configPropertiesSchemaUri, this.configAdvancedSchemaUri, this.helpUri, this.termsOfServiceUri, this.vendorName, this.vendorWebsiteUri, this.marketplaceUri, this.faqUri, this.privacyPolicyUri, this.supportContactUri, this.salesContactUri, this.helpLinks, this.credentials, this.nonInstallable, this.maxInstances, this.userPermissions, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntegrationType {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    configPropertiesSchemaUri: ").append(this.toIndentedString(this.configPropertiesSchemaUri)).append("\n");
        sb.append("    configAdvancedSchemaUri: ").append(this.toIndentedString(this.configAdvancedSchemaUri)).append("\n");
        sb.append("    helpUri: ").append(this.toIndentedString(this.helpUri)).append("\n");
        sb.append("    termsOfServiceUri: ").append(this.toIndentedString(this.termsOfServiceUri)).append("\n");
        sb.append("    vendorName: ").append(this.toIndentedString(this.vendorName)).append("\n");
        sb.append("    vendorWebsiteUri: ").append(this.toIndentedString(this.vendorWebsiteUri)).append("\n");
        sb.append("    marketplaceUri: ").append(this.toIndentedString(this.marketplaceUri)).append("\n");
        sb.append("    faqUri: ").append(this.toIndentedString(this.faqUri)).append("\n");
        sb.append("    privacyPolicyUri: ").append(this.toIndentedString(this.privacyPolicyUri)).append("\n");
        sb.append("    supportContactUri: ").append(this.toIndentedString(this.supportContactUri)).append("\n");
        sb.append("    salesContactUri: ").append(this.toIndentedString(this.salesContactUri)).append("\n");
        sb.append("    helpLinks: ").append(this.toIndentedString(this.helpLinks)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    nonInstallable: ").append(this.toIndentedString(this.nonInstallable)).append("\n");
        sb.append("    maxInstances: ").append(this.toIndentedString(this.maxInstances)).append("\n");
        sb.append("    userPermissions: ").append(this.toIndentedString(this.userPermissions)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

