/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class HistoryEntry
implements Serializable {
    private ActionEnum action = null;
    private String resource = null;
    private Date timestamp = null;
    private User user = null;
    private String version = null;
    private Boolean secure = null;

    public HistoryEntry action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", value="The action performed")
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public HistoryEntry resource(String resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(example="null", value="For actions performed not on the item itself, but on a sub-item, this field identifies the sub-item by name.  For example, for actions performed on prompt resources, this will be the prompt resource name.")
    @JsonProperty(value="resource")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public HistoryEntry timestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="timestamp")
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public HistoryEntry user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="user")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public HistoryEntry version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public HistoryEntry secure(Boolean secure) {
        this.secure = secure;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="secure")
    public Boolean getSecure() {
        return this.secure;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryEntry historyEntry = (HistoryEntry)o;
        return Objects.equals((Object)this.action, (Object)historyEntry.action) && Objects.equals(this.resource, historyEntry.resource) && Objects.equals(this.timestamp, historyEntry.timestamp) && Objects.equals(this.user, historyEntry.user) && Objects.equals(this.version, historyEntry.version) && Objects.equals(this.secure, historyEntry.secure);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.resource, this.timestamp, this.user, this.version, this.secure});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoryEntry {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    secure: ").append(this.toIndentedString(this.secure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CHECKIN("CHECKIN"),
        CHECKOUT("CHECKOUT"),
        CREATE("CREATE"),
        DEACTIVATE("DEACTIVATE"),
        DEBUG("DEBUG"),
        DELETE("DELETE"),
        PUBLISH("PUBLISH"),
        REVERT("REVERT"),
        SAVE("SAVE"),
        TRANSCODE("TRANSCODE"),
        UPDATE("UPDATE"),
        UPLOAD("UPLOAD");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionEnum value : ActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

