/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.PatchRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchScimV2GroupRequest {
    private String groupId;
    private PatchRequest body;
    private String ifMatch;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public PatchScimV2GroupRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public PatchRequest getBody() {
        return this.body;
    }

    public void setBody(PatchRequest body) {
        this.body = body;
    }

    public PatchScimV2GroupRequest withBody(PatchRequest body) {
        this.setBody(body);
        return this;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public void setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
    }

    public PatchScimV2GroupRequest withIfMatch(String ifMatch) {
        this.setIfMatch(ifMatch);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchScimV2GroupRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<PatchRequest> withHttpInfo() {
        if (this.groupId == null) {
            throw new IllegalStateException("Missing the required parameter 'groupId' when building request for PatchScimV2GroupRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchScimV2GroupRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/scim/v2/groups/{groupId}").withPathParameter("groupId", this.groupId).withHeaderParameter("If-Match", this.ifMatch).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json", "application/scim+json").withAccepts("application/json", "application/scim+json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String groupId, PatchRequest body) {
        return new Builder().withRequiredParams(groupId, body);
    }

    public static class Builder {
        private final PatchScimV2GroupRequest request = new PatchScimV2GroupRequest();

        private Builder() {
        }

        public Builder withGroupId(String groupId) {
            this.request.setGroupId(groupId);
            return this;
        }

        public Builder withBody(PatchRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withIfMatch(String ifMatch) {
            this.request.setIfMatch(ifMatch);
            return this;
        }

        public Builder withRequiredParams(String groupId, PatchRequest body) {
            this.request.setGroupId(groupId);
            this.request.setBody(body);
            return this;
        }

        public PatchScimV2GroupRequest build() {
            if (this.request.groupId == null) {
                throw new IllegalStateException("Missing the required parameter 'groupId' when building request for PatchScimV2GroupRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchScimV2GroupRequest.");
            }
            return this.request;
        }
    }
}

