/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.UriReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class FacebookIntegration
implements Serializable {
    private String id = null;
    private String name = null;
    private String appId = null;
    private String pageId = null;
    private String status = null;
    private UriReference recipient = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private UriReference createdBy = null;
    private UriReference modifiedBy = null;
    private Integer version = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", required=true, value="A unique Integration Id.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public FacebookIntegration name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Facebook Integration")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FacebookIntegration appId(String appId) {
        this.appId = appId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The App Id from Facebook messenger")
    @JsonProperty(value="appId")
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public FacebookIntegration pageId(String pageId) {
        this.pageId = pageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The Page Id from Facebook messenger")
    @JsonProperty(value="pageId")
    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public FacebookIntegration status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the Facebook Integration")
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public FacebookIntegration recipient(UriReference recipient) {
        this.recipient = recipient;
        return this;
    }

    @ApiModelProperty(example="null", value="The recipient reference associated to the Facebook Integration. This recipient is used to associate a flow to an integration")
    @JsonProperty(value="recipient")
    public UriReference getRecipient() {
        return this.recipient;
    }

    public void setRecipient(UriReference recipient) {
        this.recipient = recipient;
    }

    public FacebookIntegration dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this Integration was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public FacebookIntegration dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this Integration was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public FacebookIntegration createdBy(UriReference createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User reference that created this Integration")
    @JsonProperty(value="createdBy")
    public UriReference getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UriReference createdBy) {
        this.createdBy = createdBy;
    }

    public FacebookIntegration modifiedBy(UriReference modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User reference that last modified this Integration")
    @JsonProperty(value="modifiedBy")
    public UriReference getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(UriReference modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public FacebookIntegration version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version number required for updates.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FacebookIntegration facebookIntegration = (FacebookIntegration)o;
        return Objects.equals(this.id, facebookIntegration.id) && Objects.equals(this.name, facebookIntegration.name) && Objects.equals(this.appId, facebookIntegration.appId) && Objects.equals(this.pageId, facebookIntegration.pageId) && Objects.equals(this.status, facebookIntegration.status) && Objects.equals(this.recipient, facebookIntegration.recipient) && Objects.equals(this.dateCreated, facebookIntegration.dateCreated) && Objects.equals(this.dateModified, facebookIntegration.dateModified) && Objects.equals(this.createdBy, facebookIntegration.createdBy) && Objects.equals(this.modifiedBy, facebookIntegration.modifiedBy) && Objects.equals(this.version, facebookIntegration.version) && Objects.equals(this.selfUri, facebookIntegration.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.appId, this.pageId, this.status, this.recipient, this.dateCreated, this.dateModified, this.createdBy, this.modifiedBy, this.version, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FacebookIntegration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    pageId: ").append(this.toIndentedString(this.pageId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

