/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.ActionProperties;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class ActionMapAction
implements Serializable {
    private MediaTypeEnum mediaType = null;
    private String actionTargetId = null;
    private Boolean isPacingEnabled = null;
    private ActionProperties props = null;

    public ActionMapAction mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Media type of action.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public ActionMapAction actionTargetId(String actionTargetId) {
        this.actionTargetId = actionTargetId;
        return this;
    }

    @ApiModelProperty(example="null", value="Action target ID.")
    @JsonProperty(value="actionTargetId")
    public String getActionTargetId() {
        return this.actionTargetId;
    }

    public void setActionTargetId(String actionTargetId) {
        this.actionTargetId = actionTargetId;
    }

    public ActionMapAction isPacingEnabled(Boolean isPacingEnabled) {
        this.isPacingEnabled = isPacingEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this action should be throttled.")
    @JsonProperty(value="isPacingEnabled")
    public Boolean getIsPacingEnabled() {
        return this.isPacingEnabled;
    }

    public void setIsPacingEnabled(Boolean isPacingEnabled) {
        this.isPacingEnabled = isPacingEnabled;
    }

    public ActionMapAction props(ActionProperties props) {
        this.props = props;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional properties.")
    @JsonProperty(value="props")
    public ActionProperties getProps() {
        return this.props;
    }

    public void setProps(ActionProperties props) {
        this.props = props;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionMapAction actionMapAction = (ActionMapAction)o;
        return Objects.equals((Object)this.mediaType, (Object)actionMapAction.mediaType) && Objects.equals(this.actionTargetId, actionMapAction.actionTargetId) && Objects.equals(this.isPacingEnabled, actionMapAction.isPacingEnabled) && Objects.equals(this.props, actionMapAction.props);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mediaType, this.actionTargetId, this.isPacingEnabled, this.props});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionMapAction {\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    actionTargetId: ").append(this.toIndentedString(this.actionTargetId)).append("\n");
        sb.append("    isPacingEnabled: ").append(this.toIndentedString(this.isPacingEnabled)).append("\n");
        sb.append("    props: ").append(this.toIndentedString(this.props)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WEBCHAT("webchat");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

