/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.VoicemailMessage;
import java.util.HashMap;
import java.util.Map;

public class PatchVoicemailMessageRequest {
    private String messageId;
    private VoicemailMessage body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public PatchVoicemailMessageRequest withMessageId(String messageId) {
        this.setMessageId(messageId);
        return this;
    }

    public VoicemailMessage getBody() {
        return this.body;
    }

    public void setBody(VoicemailMessage body) {
        this.body = body;
    }

    public PatchVoicemailMessageRequest withBody(VoicemailMessage body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchVoicemailMessageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<VoicemailMessage> withHttpInfo() {
        if (this.messageId == null) {
            throw new IllegalStateException("Missing the required parameter 'messageId' when building request for PatchVoicemailMessageRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchVoicemailMessageRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/voicemail/messages/{messageId}").withPathParameter("messageId", this.messageId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String messageId, VoicemailMessage body) {
        return new Builder().withRequiredParams(messageId, body);
    }

    public static class Builder {
        private final PatchVoicemailMessageRequest request = new PatchVoicemailMessageRequest();

        private Builder() {
        }

        public Builder withMessageId(String messageId) {
            this.request.setMessageId(messageId);
            return this;
        }

        public Builder withBody(VoicemailMessage body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String messageId, VoicemailMessage body) {
            this.request.setMessageId(messageId);
            this.request.setBody(body);
            return this;
        }

        public PatchVoicemailMessageRequest build() {
            if (this.request.messageId == null) {
                throw new IllegalStateException("Missing the required parameter 'messageId' when building request for PatchVoicemailMessageRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchVoicemailMessageRequest.");
            }
            return this.request;
        }
    }
}

