/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.AcwSettings;
import com.mypurecloud.sdk.v2.model.Bullseye;
import com.mypurecloud.sdk.v2.model.Division;
import com.mypurecloud.sdk.v2.model.MediaSetting;
import com.mypurecloud.sdk.v2.model.QueueEmailAddress;
import com.mypurecloud.sdk.v2.model.QueueMessagingAddresses;
import com.mypurecloud.sdk.v2.model.Script;
import com.mypurecloud.sdk.v2.model.UriReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class Queue
implements Serializable {
    private String id = null;
    private String name = null;
    private Division division = null;
    private String description = null;
    private Integer version = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String modifiedBy = null;
    private String createdBy = null;
    private StateEnum state = null;
    private String modifiedByApp = null;
    private String createdByApp = null;
    private Map<String, MediaSetting> mediaSettings = null;
    private Bullseye bullseye = null;
    private AcwSettings acwSettings = null;
    private SkillEvaluationMethodEnum skillEvaluationMethod = null;
    private UriReference queueFlow = null;
    private UriReference whisperPrompt = null;
    private Boolean autoAnswerOnly = null;
    private String callingPartyName = null;
    private String callingPartyNumber = null;
    private Map<String, Script> defaultScripts = null;
    private QueueMessagingAddresses outboundMessagingAddresses = null;
    private QueueEmailAddress outboundEmailAddress = null;
    private Integer memberCount = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Queue name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Queue division(Division division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division to which this entity belongs.")
    @JsonProperty(value="division")
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    public Queue description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The queue description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Queue version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The current version of the queue.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Queue dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the queue was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Queue dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The date of the last modification to the queue. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public Queue modifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the user that last modified the queue.")
    @JsonProperty(value="modifiedBy")
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Queue createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the user that created the queue.")
    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Queue state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if the queue is active, inactive, or deleted.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Queue modifiedByApp(String modifiedByApp) {
        this.modifiedByApp = modifiedByApp;
        return this;
    }

    @ApiModelProperty(example="null", value="The application that last modified the queue.")
    @JsonProperty(value="modifiedByApp")
    public String getModifiedByApp() {
        return this.modifiedByApp;
    }

    public void setModifiedByApp(String modifiedByApp) {
        this.modifiedByApp = modifiedByApp;
    }

    public Queue createdByApp(String createdByApp) {
        this.createdByApp = createdByApp;
        return this;
    }

    @ApiModelProperty(example="null", value="The application that created the queue.")
    @JsonProperty(value="createdByApp")
    public String getCreatedByApp() {
        return this.createdByApp;
    }

    public void setCreatedByApp(String createdByApp) {
        this.createdByApp = createdByApp;
    }

    public Queue mediaSettings(Map<String, MediaSetting> mediaSettings) {
        this.mediaSettings = mediaSettings;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The media settings for the queue. Valid Key Values: CALL, CALLBACK, CHAT, EMAIL, SOCIAL_EXPRESSION")
    @JsonProperty(value="mediaSettings")
    public Map<String, MediaSetting> getMediaSettings() {
        return this.mediaSettings;
    }

    public void setMediaSettings(Map<String, MediaSetting> mediaSettings) {
        this.mediaSettings = mediaSettings;
    }

    public Queue bullseye(Bullseye bullseye) {
        this.bullseye = bullseye;
        return this;
    }

    @ApiModelProperty(example="null", value="The bulls-eye settings for the queue.")
    @JsonProperty(value="bullseye")
    public Bullseye getBullseye() {
        return this.bullseye;
    }

    public void setBullseye(Bullseye bullseye) {
        this.bullseye = bullseye;
    }

    public Queue acwSettings(AcwSettings acwSettings) {
        this.acwSettings = acwSettings;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ACW settings for the queue.")
    @JsonProperty(value="acwSettings")
    public AcwSettings getAcwSettings() {
        return this.acwSettings;
    }

    public void setAcwSettings(AcwSettings acwSettings) {
        this.acwSettings = acwSettings;
    }

    public Queue skillEvaluationMethod(SkillEvaluationMethodEnum skillEvaluationMethod) {
        this.skillEvaluationMethod = skillEvaluationMethod;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The skill evaluation method to use when routing conversations.")
    @JsonProperty(value="skillEvaluationMethod")
    public SkillEvaluationMethodEnum getSkillEvaluationMethod() {
        return this.skillEvaluationMethod;
    }

    public void setSkillEvaluationMethod(SkillEvaluationMethodEnum skillEvaluationMethod) {
        this.skillEvaluationMethod = skillEvaluationMethod;
    }

    public Queue queueFlow(UriReference queueFlow) {
        this.queueFlow = queueFlow;
        return this;
    }

    @ApiModelProperty(example="null", value="The in-queue flow to use for conversations waiting in queue.")
    @JsonProperty(value="queueFlow")
    public UriReference getQueueFlow() {
        return this.queueFlow;
    }

    public void setQueueFlow(UriReference queueFlow) {
        this.queueFlow = queueFlow;
    }

    public Queue whisperPrompt(UriReference whisperPrompt) {
        this.whisperPrompt = whisperPrompt;
        return this;
    }

    @ApiModelProperty(example="null", value="The prompt used for whisper on the queue, if configured.")
    @JsonProperty(value="whisperPrompt")
    public UriReference getWhisperPrompt() {
        return this.whisperPrompt;
    }

    public void setWhisperPrompt(UriReference whisperPrompt) {
        this.whisperPrompt = whisperPrompt;
    }

    public Queue autoAnswerOnly(Boolean autoAnswerOnly) {
        this.autoAnswerOnly = autoAnswerOnly;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies whether the configured whisper should play for all ACD calls, or only for those which are auto-answered.")
    @JsonProperty(value="autoAnswerOnly")
    public Boolean getAutoAnswerOnly() {
        return this.autoAnswerOnly;
    }

    public void setAutoAnswerOnly(Boolean autoAnswerOnly) {
        this.autoAnswerOnly = autoAnswerOnly;
    }

    public Queue callingPartyName(String callingPartyName) {
        this.callingPartyName = callingPartyName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name to use for caller identification for outbound calls from this queue.")
    @JsonProperty(value="callingPartyName")
    public String getCallingPartyName() {
        return this.callingPartyName;
    }

    public void setCallingPartyName(String callingPartyName) {
        this.callingPartyName = callingPartyName;
    }

    public Queue callingPartyNumber(String callingPartyNumber) {
        this.callingPartyNumber = callingPartyNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="The phone number to use for caller identification for outbound calls from this queue.")
    @JsonProperty(value="callingPartyNumber")
    public String getCallingPartyNumber() {
        return this.callingPartyNumber;
    }

    public void setCallingPartyNumber(String callingPartyNumber) {
        this.callingPartyNumber = callingPartyNumber;
    }

    public Queue defaultScripts(Map<String, Script> defaultScripts) {
        this.defaultScripts = defaultScripts;
        return this;
    }

    @ApiModelProperty(example="null", value="The default script Ids for the communication types.")
    @JsonProperty(value="defaultScripts")
    public Map<String, Script> getDefaultScripts() {
        return this.defaultScripts;
    }

    public void setDefaultScripts(Map<String, Script> defaultScripts) {
        this.defaultScripts = defaultScripts;
    }

    public Queue outboundMessagingAddresses(QueueMessagingAddresses outboundMessagingAddresses) {
        this.outboundMessagingAddresses = outboundMessagingAddresses;
        return this;
    }

    @ApiModelProperty(example="null", value="The messaging addresses for the queue.")
    @JsonProperty(value="outboundMessagingAddresses")
    public QueueMessagingAddresses getOutboundMessagingAddresses() {
        return this.outboundMessagingAddresses;
    }

    public void setOutboundMessagingAddresses(QueueMessagingAddresses outboundMessagingAddresses) {
        this.outboundMessagingAddresses = outboundMessagingAddresses;
    }

    public Queue outboundEmailAddress(QueueEmailAddress outboundEmailAddress) {
        this.outboundEmailAddress = outboundEmailAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="outboundEmailAddress")
    public QueueEmailAddress getOutboundEmailAddress() {
        return this.outboundEmailAddress;
    }

    public void setOutboundEmailAddress(QueueEmailAddress outboundEmailAddress) {
        this.outboundEmailAddress = outboundEmailAddress;
    }

    public Queue memberCount(Integer memberCount) {
        this.memberCount = memberCount;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="memberCount")
    public Integer getMemberCount() {
        return this.memberCount;
    }

    public void setMemberCount(Integer memberCount) {
        this.memberCount = memberCount;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Queue queue = (Queue)o;
        return Objects.equals(this.id, queue.id) && Objects.equals(this.name, queue.name) && Objects.equals(this.division, queue.division) && Objects.equals(this.description, queue.description) && Objects.equals(this.version, queue.version) && Objects.equals(this.dateCreated, queue.dateCreated) && Objects.equals(this.dateModified, queue.dateModified) && Objects.equals(this.modifiedBy, queue.modifiedBy) && Objects.equals(this.createdBy, queue.createdBy) && Objects.equals((Object)this.state, (Object)queue.state) && Objects.equals(this.modifiedByApp, queue.modifiedByApp) && Objects.equals(this.createdByApp, queue.createdByApp) && Objects.equals(this.mediaSettings, queue.mediaSettings) && Objects.equals(this.bullseye, queue.bullseye) && Objects.equals(this.acwSettings, queue.acwSettings) && Objects.equals((Object)this.skillEvaluationMethod, (Object)queue.skillEvaluationMethod) && Objects.equals(this.queueFlow, queue.queueFlow) && Objects.equals(this.whisperPrompt, queue.whisperPrompt) && Objects.equals(this.autoAnswerOnly, queue.autoAnswerOnly) && Objects.equals(this.callingPartyName, queue.callingPartyName) && Objects.equals(this.callingPartyNumber, queue.callingPartyNumber) && Objects.equals(this.defaultScripts, queue.defaultScripts) && Objects.equals(this.outboundMessagingAddresses, queue.outboundMessagingAddresses) && Objects.equals(this.outboundEmailAddress, queue.outboundEmailAddress) && Objects.equals(this.memberCount, queue.memberCount) && Objects.equals(this.selfUri, queue.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.division, this.description, this.version, this.dateCreated, this.dateModified, this.modifiedBy, this.createdBy, this.state, this.modifiedByApp, this.createdByApp, this.mediaSettings, this.bullseye, this.acwSettings, this.skillEvaluationMethod, this.queueFlow, this.whisperPrompt, this.autoAnswerOnly, this.callingPartyName, this.callingPartyNumber, this.defaultScripts, this.outboundMessagingAddresses, this.outboundEmailAddress, this.memberCount, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Queue {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    modifiedByApp: ").append(this.toIndentedString(this.modifiedByApp)).append("\n");
        sb.append("    createdByApp: ").append(this.toIndentedString(this.createdByApp)).append("\n");
        sb.append("    mediaSettings: ").append(this.toIndentedString(this.mediaSettings)).append("\n");
        sb.append("    bullseye: ").append(this.toIndentedString(this.bullseye)).append("\n");
        sb.append("    acwSettings: ").append(this.toIndentedString(this.acwSettings)).append("\n");
        sb.append("    skillEvaluationMethod: ").append(this.toIndentedString((Object)this.skillEvaluationMethod)).append("\n");
        sb.append("    queueFlow: ").append(this.toIndentedString(this.queueFlow)).append("\n");
        sb.append("    whisperPrompt: ").append(this.toIndentedString(this.whisperPrompt)).append("\n");
        sb.append("    autoAnswerOnly: ").append(this.toIndentedString(this.autoAnswerOnly)).append("\n");
        sb.append("    callingPartyName: ").append(this.toIndentedString(this.callingPartyName)).append("\n");
        sb.append("    callingPartyNumber: ").append(this.toIndentedString(this.callingPartyNumber)).append("\n");
        sb.append("    defaultScripts: ").append(this.toIndentedString(this.defaultScripts)).append("\n");
        sb.append("    outboundMessagingAddresses: ").append(this.toIndentedString(this.outboundMessagingAddresses)).append("\n");
        sb.append("    outboundEmailAddress: ").append(this.toIndentedString(this.outboundEmailAddress)).append("\n");
        sb.append("    memberCount: ").append(this.toIndentedString(this.memberCount)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SkillEvaluationMethodEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("NONE"),
        BEST("BEST"),
        ALL("ALL");

        private String value;

        private SkillEvaluationMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SkillEvaluationMethodEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SkillEvaluationMethodEnum value : SkillEvaluationMethodEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SkillEvaluationMethodEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

