/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteIntegrationRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteIntegrationsActionDraftRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteIntegrationsActionRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteIntegrationsCredentialRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationConfigCurrentRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsActionDraftRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsActionDraftSchemaRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsActionDraftTemplateRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsActionDraftValidationRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsActionRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsActionSchemaRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsActionTemplateRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsActionsCategoriesRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsActionsDraftsRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsActionsRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsClientappsRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsCredentialRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsCredentialsRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsCredentialsTypesRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsEventlogEventIdRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsEventlogRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsTypeConfigschemaRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsTypeRequest;
import com.mypurecloud.sdk.v2.api.request.GetIntegrationsTypesRequest;
import com.mypurecloud.sdk.v2.api.request.PatchIntegrationRequest;
import com.mypurecloud.sdk.v2.api.request.PatchIntegrationsActionDraftRequest;
import com.mypurecloud.sdk.v2.api.request.PatchIntegrationsActionRequest;
import com.mypurecloud.sdk.v2.api.request.PostIntegrationsActionDraftPublishRequest;
import com.mypurecloud.sdk.v2.api.request.PostIntegrationsActionDraftRequest;
import com.mypurecloud.sdk.v2.api.request.PostIntegrationsActionDraftTestRequest;
import com.mypurecloud.sdk.v2.api.request.PostIntegrationsActionExecuteRequest;
import com.mypurecloud.sdk.v2.api.request.PostIntegrationsActionTestRequest;
import com.mypurecloud.sdk.v2.api.request.PostIntegrationsActionsDraftsRequest;
import com.mypurecloud.sdk.v2.api.request.PostIntegrationsActionsRequest;
import com.mypurecloud.sdk.v2.api.request.PostIntegrationsCredentialsRequest;
import com.mypurecloud.sdk.v2.api.request.PostIntegrationsRequest;
import com.mypurecloud.sdk.v2.api.request.PostIntegrationsWorkforcemanagementVendorconnectionRequest;
import com.mypurecloud.sdk.v2.api.request.PutIntegrationConfigCurrentRequest;
import com.mypurecloud.sdk.v2.api.request.PutIntegrationsCredentialRequest;
import com.mypurecloud.sdk.v2.model.Action;
import com.mypurecloud.sdk.v2.model.ActionEntityListing;
import com.mypurecloud.sdk.v2.model.CategoryEntityListing;
import com.mypurecloud.sdk.v2.model.ClientAppEntityListing;
import com.mypurecloud.sdk.v2.model.CreateIntegrationRequest;
import com.mypurecloud.sdk.v2.model.Credential;
import com.mypurecloud.sdk.v2.model.CredentialInfo;
import com.mypurecloud.sdk.v2.model.CredentialInfoListing;
import com.mypurecloud.sdk.v2.model.CredentialTypeListing;
import com.mypurecloud.sdk.v2.model.DraftValidationResult;
import com.mypurecloud.sdk.v2.model.Integration;
import com.mypurecloud.sdk.v2.model.IntegrationConfiguration;
import com.mypurecloud.sdk.v2.model.IntegrationEntityListing;
import com.mypurecloud.sdk.v2.model.IntegrationEvent;
import com.mypurecloud.sdk.v2.model.IntegrationEventEntityListing;
import com.mypurecloud.sdk.v2.model.IntegrationType;
import com.mypurecloud.sdk.v2.model.IntegrationTypeEntityListing;
import com.mypurecloud.sdk.v2.model.JsonSchemaDocument;
import com.mypurecloud.sdk.v2.model.PostActionInput;
import com.mypurecloud.sdk.v2.model.PublishDraftInput;
import com.mypurecloud.sdk.v2.model.TestExecutionResult;
import com.mypurecloud.sdk.v2.model.UpdateActionInput;
import com.mypurecloud.sdk.v2.model.UpdateDraftInput;
import com.mypurecloud.sdk.v2.model.UserActionCategoryEntityListing;
import com.mypurecloud.sdk.v2.model.VendorConnectionRequest;
import java.io.IOException;
import java.util.List;

public class IntegrationsApi {
    private final ApiClient pcapiClient;

    public IntegrationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IntegrationsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Integration deleteIntegration(String integrationId) throws IOException, ApiException {
        return this.deleteIntegration(this.createDeleteIntegrationRequest(integrationId));
    }

    public ApiResponse<Integration> deleteIntegrationWithHttpInfo(String integrationId) throws IOException {
        return this.deleteIntegration(this.createDeleteIntegrationRequest(integrationId).withHttpInfo());
    }

    private DeleteIntegrationRequest createDeleteIntegrationRequest(String integrationId) {
        return DeleteIntegrationRequest.builder().withIntegrationId(integrationId).build();
    }

    public Integration deleteIntegration(DeleteIntegrationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Integration> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Integration>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Integration> deleteIntegration(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Integration>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteIntegrationsAction(String actionId) throws IOException, ApiException {
        this.deleteIntegrationsAction(this.createDeleteIntegrationsActionRequest(actionId));
    }

    public ApiResponse<Void> deleteIntegrationsActionWithHttpInfo(String actionId) throws IOException {
        return this.deleteIntegrationsAction(this.createDeleteIntegrationsActionRequest(actionId).withHttpInfo());
    }

    private DeleteIntegrationsActionRequest createDeleteIntegrationsActionRequest(String actionId) {
        return DeleteIntegrationsActionRequest.builder().withActionId(actionId).build();
    }

    public void deleteIntegrationsAction(DeleteIntegrationsActionRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteIntegrationsAction(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteIntegrationsActionDraft(String actionId) throws IOException, ApiException {
        this.deleteIntegrationsActionDraft(this.createDeleteIntegrationsActionDraftRequest(actionId));
    }

    public ApiResponse<Void> deleteIntegrationsActionDraftWithHttpInfo(String actionId) throws IOException {
        return this.deleteIntegrationsActionDraft(this.createDeleteIntegrationsActionDraftRequest(actionId).withHttpInfo());
    }

    private DeleteIntegrationsActionDraftRequest createDeleteIntegrationsActionDraftRequest(String actionId) {
        return DeleteIntegrationsActionDraftRequest.builder().withActionId(actionId).build();
    }

    public void deleteIntegrationsActionDraft(DeleteIntegrationsActionDraftRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteIntegrationsActionDraft(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteIntegrationsCredential(String credentialId) throws IOException, ApiException {
        this.deleteIntegrationsCredential(this.createDeleteIntegrationsCredentialRequest(credentialId));
    }

    public ApiResponse<Void> deleteIntegrationsCredentialWithHttpInfo(String credentialId) throws IOException {
        return this.deleteIntegrationsCredential(this.createDeleteIntegrationsCredentialRequest(credentialId).withHttpInfo());
    }

    private DeleteIntegrationsCredentialRequest createDeleteIntegrationsCredentialRequest(String credentialId) {
        return DeleteIntegrationsCredentialRequest.builder().withCredentialId(credentialId).build();
    }

    public void deleteIntegrationsCredential(DeleteIntegrationsCredentialRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteIntegrationsCredential(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Integration getIntegration(String integrationId, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException, ApiException {
        return this.getIntegration(this.createGetIntegrationRequest(integrationId, pageSize, pageNumber, sortBy, expand, nextPage, previousPage));
    }

    public ApiResponse<Integration> getIntegrationWithHttpInfo(String integrationId, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException {
        return this.getIntegration(this.createGetIntegrationRequest(integrationId, pageSize, pageNumber, sortBy, expand, nextPage, previousPage).withHttpInfo());
    }

    private GetIntegrationRequest createGetIntegrationRequest(String integrationId, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) {
        return GetIntegrationRequest.builder().withIntegrationId(integrationId).withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).build();
    }

    public Integration getIntegration(GetIntegrationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Integration> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Integration>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Integration> getIntegration(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Integration>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public IntegrationConfiguration getIntegrationConfigCurrent(String integrationId) throws IOException, ApiException {
        return this.getIntegrationConfigCurrent(this.createGetIntegrationConfigCurrentRequest(integrationId));
    }

    public ApiResponse<IntegrationConfiguration> getIntegrationConfigCurrentWithHttpInfo(String integrationId) throws IOException {
        return this.getIntegrationConfigCurrent(this.createGetIntegrationConfigCurrentRequest(integrationId).withHttpInfo());
    }

    private GetIntegrationConfigCurrentRequest createGetIntegrationConfigCurrentRequest(String integrationId) {
        return GetIntegrationConfigCurrentRequest.builder().withIntegrationId(integrationId).build();
    }

    public IntegrationConfiguration getIntegrationConfigCurrent(GetIntegrationConfigCurrentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<IntegrationConfiguration> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<IntegrationConfiguration>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<IntegrationConfiguration> getIntegrationConfigCurrent(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<IntegrationConfiguration>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public IntegrationEntityListing getIntegrations(Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException, ApiException {
        return this.getIntegrations(this.createGetIntegrationsRequest(pageSize, pageNumber, sortBy, expand, nextPage, previousPage));
    }

    public ApiResponse<IntegrationEntityListing> getIntegrationsWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException {
        return this.getIntegrations(this.createGetIntegrationsRequest(pageSize, pageNumber, sortBy, expand, nextPage, previousPage).withHttpInfo());
    }

    private GetIntegrationsRequest createGetIntegrationsRequest(Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) {
        return GetIntegrationsRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).build();
    }

    public IntegrationEntityListing getIntegrations(GetIntegrationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<IntegrationEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<IntegrationEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<IntegrationEntityListing> getIntegrations(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<IntegrationEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Action getIntegrationsAction(String actionId, String expand, Boolean includeConfig) throws IOException, ApiException {
        return this.getIntegrationsAction(this.createGetIntegrationsActionRequest(actionId, expand, includeConfig));
    }

    public ApiResponse<Action> getIntegrationsActionWithHttpInfo(String actionId, String expand, Boolean includeConfig) throws IOException {
        return this.getIntegrationsAction(this.createGetIntegrationsActionRequest(actionId, expand, includeConfig).withHttpInfo());
    }

    private GetIntegrationsActionRequest createGetIntegrationsActionRequest(String actionId, String expand, Boolean includeConfig) {
        return GetIntegrationsActionRequest.builder().withActionId(actionId).withExpand(expand).withIncludeConfig(includeConfig).build();
    }

    public Action getIntegrationsAction(GetIntegrationsActionRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Action> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Action>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Action> getIntegrationsAction(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Action>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Action getIntegrationsActionDraft(String actionId, String expand, Boolean includeConfig) throws IOException, ApiException {
        return this.getIntegrationsActionDraft(this.createGetIntegrationsActionDraftRequest(actionId, expand, includeConfig));
    }

    public ApiResponse<Action> getIntegrationsActionDraftWithHttpInfo(String actionId, String expand, Boolean includeConfig) throws IOException {
        return this.getIntegrationsActionDraft(this.createGetIntegrationsActionDraftRequest(actionId, expand, includeConfig).withHttpInfo());
    }

    private GetIntegrationsActionDraftRequest createGetIntegrationsActionDraftRequest(String actionId, String expand, Boolean includeConfig) {
        return GetIntegrationsActionDraftRequest.builder().withActionId(actionId).withExpand(expand).withIncludeConfig(includeConfig).build();
    }

    public Action getIntegrationsActionDraft(GetIntegrationsActionDraftRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Action> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Action>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Action> getIntegrationsActionDraft(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Action>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public JsonSchemaDocument getIntegrationsActionDraftSchema(String actionId, String fileName) throws IOException, ApiException {
        return this.getIntegrationsActionDraftSchema(this.createGetIntegrationsActionDraftSchemaRequest(actionId, fileName));
    }

    public ApiResponse<JsonSchemaDocument> getIntegrationsActionDraftSchemaWithHttpInfo(String actionId, String fileName) throws IOException {
        return this.getIntegrationsActionDraftSchema(this.createGetIntegrationsActionDraftSchemaRequest(actionId, fileName).withHttpInfo());
    }

    private GetIntegrationsActionDraftSchemaRequest createGetIntegrationsActionDraftSchemaRequest(String actionId, String fileName) {
        return GetIntegrationsActionDraftSchemaRequest.builder().withActionId(actionId).withFileName(fileName).build();
    }

    public JsonSchemaDocument getIntegrationsActionDraftSchema(GetIntegrationsActionDraftSchemaRequest request) throws IOException, ApiException {
        try {
            ApiResponse<JsonSchemaDocument> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<JsonSchemaDocument>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<JsonSchemaDocument> getIntegrationsActionDraftSchema(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<JsonSchemaDocument>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public String getIntegrationsActionDraftTemplate(String actionId, String fileName) throws IOException, ApiException {
        return this.getIntegrationsActionDraftTemplate(this.createGetIntegrationsActionDraftTemplateRequest(actionId, fileName));
    }

    public ApiResponse<String> getIntegrationsActionDraftTemplateWithHttpInfo(String actionId, String fileName) throws IOException {
        return this.getIntegrationsActionDraftTemplate(this.createGetIntegrationsActionDraftTemplateRequest(actionId, fileName).withHttpInfo());
    }

    private GetIntegrationsActionDraftTemplateRequest createGetIntegrationsActionDraftTemplateRequest(String actionId, String fileName) {
        return GetIntegrationsActionDraftTemplateRequest.builder().withActionId(actionId).withFileName(fileName).build();
    }

    public String getIntegrationsActionDraftTemplate(GetIntegrationsActionDraftTemplateRequest request) throws IOException, ApiException {
        try {
            ApiResponse<String> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<String>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<String> getIntegrationsActionDraftTemplate(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<String>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public DraftValidationResult getIntegrationsActionDraftValidation(String actionId) throws IOException, ApiException {
        return this.getIntegrationsActionDraftValidation(this.createGetIntegrationsActionDraftValidationRequest(actionId));
    }

    public ApiResponse<DraftValidationResult> getIntegrationsActionDraftValidationWithHttpInfo(String actionId) throws IOException {
        return this.getIntegrationsActionDraftValidation(this.createGetIntegrationsActionDraftValidationRequest(actionId).withHttpInfo());
    }

    private GetIntegrationsActionDraftValidationRequest createGetIntegrationsActionDraftValidationRequest(String actionId) {
        return GetIntegrationsActionDraftValidationRequest.builder().withActionId(actionId).build();
    }

    public DraftValidationResult getIntegrationsActionDraftValidation(GetIntegrationsActionDraftValidationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<DraftValidationResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<DraftValidationResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<DraftValidationResult> getIntegrationsActionDraftValidation(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<DraftValidationResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public JsonSchemaDocument getIntegrationsActionSchema(String actionId, String fileName) throws IOException, ApiException {
        return this.getIntegrationsActionSchema(this.createGetIntegrationsActionSchemaRequest(actionId, fileName));
    }

    public ApiResponse<JsonSchemaDocument> getIntegrationsActionSchemaWithHttpInfo(String actionId, String fileName) throws IOException {
        return this.getIntegrationsActionSchema(this.createGetIntegrationsActionSchemaRequest(actionId, fileName).withHttpInfo());
    }

    private GetIntegrationsActionSchemaRequest createGetIntegrationsActionSchemaRequest(String actionId, String fileName) {
        return GetIntegrationsActionSchemaRequest.builder().withActionId(actionId).withFileName(fileName).build();
    }

    public JsonSchemaDocument getIntegrationsActionSchema(GetIntegrationsActionSchemaRequest request) throws IOException, ApiException {
        try {
            ApiResponse<JsonSchemaDocument> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<JsonSchemaDocument>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<JsonSchemaDocument> getIntegrationsActionSchema(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<JsonSchemaDocument>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public String getIntegrationsActionTemplate(String actionId, String fileName) throws IOException, ApiException {
        return this.getIntegrationsActionTemplate(this.createGetIntegrationsActionTemplateRequest(actionId, fileName));
    }

    public ApiResponse<String> getIntegrationsActionTemplateWithHttpInfo(String actionId, String fileName) throws IOException {
        return this.getIntegrationsActionTemplate(this.createGetIntegrationsActionTemplateRequest(actionId, fileName).withHttpInfo());
    }

    private GetIntegrationsActionTemplateRequest createGetIntegrationsActionTemplateRequest(String actionId, String fileName) {
        return GetIntegrationsActionTemplateRequest.builder().withActionId(actionId).withFileName(fileName).build();
    }

    public String getIntegrationsActionTemplate(GetIntegrationsActionTemplateRequest request) throws IOException, ApiException {
        try {
            ApiResponse<String> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<String>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<String> getIntegrationsActionTemplate(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<String>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ActionEntityListing getIntegrationsActions(String category, String secure, String includeAuthActions, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException, ApiException {
        return this.getIntegrationsActions(this.createGetIntegrationsActionsRequest(category, secure, includeAuthActions, pageSize, pageNumber, sortBy, expand, nextPage, previousPage));
    }

    public ApiResponse<ActionEntityListing> getIntegrationsActionsWithHttpInfo(String category, String secure, String includeAuthActions, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException {
        return this.getIntegrationsActions(this.createGetIntegrationsActionsRequest(category, secure, includeAuthActions, pageSize, pageNumber, sortBy, expand, nextPage, previousPage).withHttpInfo());
    }

    private GetIntegrationsActionsRequest createGetIntegrationsActionsRequest(String category, String secure, String includeAuthActions, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) {
        return GetIntegrationsActionsRequest.builder().withCategory(category).withSecure(secure).withIncludeAuthActions(includeAuthActions).withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).build();
    }

    public ActionEntityListing getIntegrationsActions(GetIntegrationsActionsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ActionEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ActionEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ActionEntityListing> getIntegrationsActions(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ActionEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CategoryEntityListing getIntegrationsActionsCategories(String secure, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException, ApiException {
        return this.getIntegrationsActionsCategories(this.createGetIntegrationsActionsCategoriesRequest(secure, pageSize, pageNumber, sortBy, expand, nextPage, previousPage));
    }

    public ApiResponse<CategoryEntityListing> getIntegrationsActionsCategoriesWithHttpInfo(String secure, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException {
        return this.getIntegrationsActionsCategories(this.createGetIntegrationsActionsCategoriesRequest(secure, pageSize, pageNumber, sortBy, expand, nextPage, previousPage).withHttpInfo());
    }

    private GetIntegrationsActionsCategoriesRequest createGetIntegrationsActionsCategoriesRequest(String secure, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) {
        return GetIntegrationsActionsCategoriesRequest.builder().withSecure(secure).withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).build();
    }

    public CategoryEntityListing getIntegrationsActionsCategories(GetIntegrationsActionsCategoriesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CategoryEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CategoryEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CategoryEntityListing> getIntegrationsActionsCategories(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CategoryEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ActionEntityListing getIntegrationsActionsDrafts(String category, String secure, String includeAuthActions, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException, ApiException {
        return this.getIntegrationsActionsDrafts(this.createGetIntegrationsActionsDraftsRequest(category, secure, includeAuthActions, pageSize, pageNumber, sortBy, expand, nextPage, previousPage));
    }

    public ApiResponse<ActionEntityListing> getIntegrationsActionsDraftsWithHttpInfo(String category, String secure, String includeAuthActions, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException {
        return this.getIntegrationsActionsDrafts(this.createGetIntegrationsActionsDraftsRequest(category, secure, includeAuthActions, pageSize, pageNumber, sortBy, expand, nextPage, previousPage).withHttpInfo());
    }

    private GetIntegrationsActionsDraftsRequest createGetIntegrationsActionsDraftsRequest(String category, String secure, String includeAuthActions, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) {
        return GetIntegrationsActionsDraftsRequest.builder().withCategory(category).withSecure(secure).withIncludeAuthActions(includeAuthActions).withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).build();
    }

    public ActionEntityListing getIntegrationsActionsDrafts(GetIntegrationsActionsDraftsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ActionEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ActionEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ActionEntityListing> getIntegrationsActionsDrafts(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ActionEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ClientAppEntityListing getIntegrationsClientapps(Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException, ApiException {
        return this.getIntegrationsClientapps(this.createGetIntegrationsClientappsRequest(pageSize, pageNumber, sortBy, expand, nextPage, previousPage));
    }

    public ApiResponse<ClientAppEntityListing> getIntegrationsClientappsWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException {
        return this.getIntegrationsClientapps(this.createGetIntegrationsClientappsRequest(pageSize, pageNumber, sortBy, expand, nextPage, previousPage).withHttpInfo());
    }

    private GetIntegrationsClientappsRequest createGetIntegrationsClientappsRequest(Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) {
        return GetIntegrationsClientappsRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).build();
    }

    public ClientAppEntityListing getIntegrationsClientapps(GetIntegrationsClientappsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ClientAppEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ClientAppEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ClientAppEntityListing> getIntegrationsClientapps(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ClientAppEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Credential getIntegrationsCredential(String credentialId) throws IOException, ApiException {
        return this.getIntegrationsCredential(this.createGetIntegrationsCredentialRequest(credentialId));
    }

    public ApiResponse<Credential> getIntegrationsCredentialWithHttpInfo(String credentialId) throws IOException {
        return this.getIntegrationsCredential(this.createGetIntegrationsCredentialRequest(credentialId).withHttpInfo());
    }

    private GetIntegrationsCredentialRequest createGetIntegrationsCredentialRequest(String credentialId) {
        return GetIntegrationsCredentialRequest.builder().withCredentialId(credentialId).build();
    }

    public Credential getIntegrationsCredential(GetIntegrationsCredentialRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Credential> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Credential>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Credential> getIntegrationsCredential(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Credential>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CredentialInfoListing getIntegrationsCredentials(Integer pageNumber, Integer pageSize) throws IOException, ApiException {
        return this.getIntegrationsCredentials(this.createGetIntegrationsCredentialsRequest(pageNumber, pageSize));
    }

    public ApiResponse<CredentialInfoListing> getIntegrationsCredentialsWithHttpInfo(Integer pageNumber, Integer pageSize) throws IOException {
        return this.getIntegrationsCredentials(this.createGetIntegrationsCredentialsRequest(pageNumber, pageSize).withHttpInfo());
    }

    private GetIntegrationsCredentialsRequest createGetIntegrationsCredentialsRequest(Integer pageNumber, Integer pageSize) {
        return GetIntegrationsCredentialsRequest.builder().withPageNumber(pageNumber).withPageSize(pageSize).build();
    }

    public CredentialInfoListing getIntegrationsCredentials(GetIntegrationsCredentialsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CredentialInfoListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CredentialInfoListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CredentialInfoListing> getIntegrationsCredentials(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CredentialInfoListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CredentialTypeListing getIntegrationsCredentialsTypes() throws IOException, ApiException {
        return this.getIntegrationsCredentialsTypes(this.createGetIntegrationsCredentialsTypesRequest());
    }

    public ApiResponse<CredentialTypeListing> getIntegrationsCredentialsTypesWithHttpInfo() throws IOException {
        return this.getIntegrationsCredentialsTypes(this.createGetIntegrationsCredentialsTypesRequest().withHttpInfo());
    }

    private GetIntegrationsCredentialsTypesRequest createGetIntegrationsCredentialsTypesRequest() {
        return GetIntegrationsCredentialsTypesRequest.builder().build();
    }

    public CredentialTypeListing getIntegrationsCredentialsTypes(GetIntegrationsCredentialsTypesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CredentialTypeListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CredentialTypeListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CredentialTypeListing> getIntegrationsCredentialsTypes(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CredentialTypeListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public IntegrationEventEntityListing getIntegrationsEventlog(Integer pageSize, Integer pageNumber, String sortBy, String sortOrder, String entityId) throws IOException, ApiException {
        return this.getIntegrationsEventlog(this.createGetIntegrationsEventlogRequest(pageSize, pageNumber, sortBy, sortOrder, entityId));
    }

    public ApiResponse<IntegrationEventEntityListing> getIntegrationsEventlogWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, String sortOrder, String entityId) throws IOException {
        return this.getIntegrationsEventlog(this.createGetIntegrationsEventlogRequest(pageSize, pageNumber, sortBy, sortOrder, entityId).withHttpInfo());
    }

    private GetIntegrationsEventlogRequest createGetIntegrationsEventlogRequest(Integer pageSize, Integer pageNumber, String sortBy, String sortOrder, String entityId) {
        return GetIntegrationsEventlogRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withSortOrder(sortOrder).withEntityId(entityId).build();
    }

    public IntegrationEventEntityListing getIntegrationsEventlog(GetIntegrationsEventlogRequest request) throws IOException, ApiException {
        try {
            ApiResponse<IntegrationEventEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<IntegrationEventEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<IntegrationEventEntityListing> getIntegrationsEventlog(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<IntegrationEventEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public IntegrationEvent getIntegrationsEventlogEventId(String eventId) throws IOException, ApiException {
        return this.getIntegrationsEventlogEventId(this.createGetIntegrationsEventlogEventIdRequest(eventId));
    }

    public ApiResponse<IntegrationEvent> getIntegrationsEventlogEventIdWithHttpInfo(String eventId) throws IOException {
        return this.getIntegrationsEventlogEventId(this.createGetIntegrationsEventlogEventIdRequest(eventId).withHttpInfo());
    }

    private GetIntegrationsEventlogEventIdRequest createGetIntegrationsEventlogEventIdRequest(String eventId) {
        return GetIntegrationsEventlogEventIdRequest.builder().withEventId(eventId).build();
    }

    public IntegrationEvent getIntegrationsEventlogEventId(GetIntegrationsEventlogEventIdRequest request) throws IOException, ApiException {
        try {
            ApiResponse<IntegrationEvent> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<IntegrationEvent>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<IntegrationEvent> getIntegrationsEventlogEventId(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<IntegrationEvent>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public IntegrationType getIntegrationsType(String typeId) throws IOException, ApiException {
        return this.getIntegrationsType(this.createGetIntegrationsTypeRequest(typeId));
    }

    public ApiResponse<IntegrationType> getIntegrationsTypeWithHttpInfo(String typeId) throws IOException {
        return this.getIntegrationsType(this.createGetIntegrationsTypeRequest(typeId).withHttpInfo());
    }

    private GetIntegrationsTypeRequest createGetIntegrationsTypeRequest(String typeId) {
        return GetIntegrationsTypeRequest.builder().withTypeId(typeId).build();
    }

    public IntegrationType getIntegrationsType(GetIntegrationsTypeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<IntegrationType> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<IntegrationType>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<IntegrationType> getIntegrationsType(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<IntegrationType>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public JsonSchemaDocument getIntegrationsTypeConfigschema(String typeId, String configType) throws IOException, ApiException {
        return this.getIntegrationsTypeConfigschema(this.createGetIntegrationsTypeConfigschemaRequest(typeId, configType));
    }

    public ApiResponse<JsonSchemaDocument> getIntegrationsTypeConfigschemaWithHttpInfo(String typeId, String configType) throws IOException {
        return this.getIntegrationsTypeConfigschema(this.createGetIntegrationsTypeConfigschemaRequest(typeId, configType).withHttpInfo());
    }

    private GetIntegrationsTypeConfigschemaRequest createGetIntegrationsTypeConfigschemaRequest(String typeId, String configType) {
        return GetIntegrationsTypeConfigschemaRequest.builder().withTypeId(typeId).withConfigType(configType).build();
    }

    public JsonSchemaDocument getIntegrationsTypeConfigschema(GetIntegrationsTypeConfigschemaRequest request) throws IOException, ApiException {
        try {
            ApiResponse<JsonSchemaDocument> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<JsonSchemaDocument>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<JsonSchemaDocument> getIntegrationsTypeConfigschema(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<JsonSchemaDocument>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public IntegrationTypeEntityListing getIntegrationsTypes(Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException, ApiException {
        return this.getIntegrationsTypes(this.createGetIntegrationsTypesRequest(pageSize, pageNumber, sortBy, expand, nextPage, previousPage));
    }

    public ApiResponse<IntegrationTypeEntityListing> getIntegrationsTypesWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException {
        return this.getIntegrationsTypes(this.createGetIntegrationsTypesRequest(pageSize, pageNumber, sortBy, expand, nextPage, previousPage).withHttpInfo());
    }

    private GetIntegrationsTypesRequest createGetIntegrationsTypesRequest(Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) {
        return GetIntegrationsTypesRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).build();
    }

    public IntegrationTypeEntityListing getIntegrationsTypes(GetIntegrationsTypesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<IntegrationTypeEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<IntegrationTypeEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<IntegrationTypeEntityListing> getIntegrationsTypes(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<IntegrationTypeEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Integration patchIntegration(String integrationId, Integration body, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException, ApiException {
        return this.patchIntegration(this.createPatchIntegrationRequest(integrationId, body, pageSize, pageNumber, sortBy, expand, nextPage, previousPage));
    }

    public ApiResponse<Integration> patchIntegrationWithHttpInfo(String integrationId, Integration body, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) throws IOException {
        return this.patchIntegration(this.createPatchIntegrationRequest(integrationId, body, pageSize, pageNumber, sortBy, expand, nextPage, previousPage).withHttpInfo());
    }

    private PatchIntegrationRequest createPatchIntegrationRequest(String integrationId, Integration body, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage) {
        return PatchIntegrationRequest.builder().withIntegrationId(integrationId).withBody(body).withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).build();
    }

    public Integration patchIntegration(PatchIntegrationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Integration> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Integration>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Integration> patchIntegration(ApiRequest<Integration> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Integration>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Action patchIntegrationsAction(String actionId, UpdateActionInput body) throws IOException, ApiException {
        return this.patchIntegrationsAction(this.createPatchIntegrationsActionRequest(actionId, body));
    }

    public ApiResponse<Action> patchIntegrationsActionWithHttpInfo(String actionId, UpdateActionInput body) throws IOException {
        return this.patchIntegrationsAction(this.createPatchIntegrationsActionRequest(actionId, body).withHttpInfo());
    }

    private PatchIntegrationsActionRequest createPatchIntegrationsActionRequest(String actionId, UpdateActionInput body) {
        return PatchIntegrationsActionRequest.builder().withActionId(actionId).withBody(body).build();
    }

    public Action patchIntegrationsAction(PatchIntegrationsActionRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Action> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Action>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Action> patchIntegrationsAction(ApiRequest<UpdateActionInput> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Action>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Action patchIntegrationsActionDraft(String actionId, UpdateDraftInput body) throws IOException, ApiException {
        return this.patchIntegrationsActionDraft(this.createPatchIntegrationsActionDraftRequest(actionId, body));
    }

    public ApiResponse<Action> patchIntegrationsActionDraftWithHttpInfo(String actionId, UpdateDraftInput body) throws IOException {
        return this.patchIntegrationsActionDraft(this.createPatchIntegrationsActionDraftRequest(actionId, body).withHttpInfo());
    }

    private PatchIntegrationsActionDraftRequest createPatchIntegrationsActionDraftRequest(String actionId, UpdateDraftInput body) {
        return PatchIntegrationsActionDraftRequest.builder().withActionId(actionId).withBody(body).build();
    }

    public Action patchIntegrationsActionDraft(PatchIntegrationsActionDraftRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Action> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Action>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Action> patchIntegrationsActionDraft(ApiRequest<UpdateDraftInput> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Action>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Integration postIntegrations(CreateIntegrationRequest body) throws IOException, ApiException {
        return this.postIntegrations(this.createPostIntegrationsRequest(body));
    }

    public ApiResponse<Integration> postIntegrationsWithHttpInfo(CreateIntegrationRequest body) throws IOException {
        return this.postIntegrations(this.createPostIntegrationsRequest(body).withHttpInfo());
    }

    private PostIntegrationsRequest createPostIntegrationsRequest(CreateIntegrationRequest body) {
        return PostIntegrationsRequest.builder().withBody(body).build();
    }

    public Integration postIntegrations(PostIntegrationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Integration> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Integration>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Integration> postIntegrations(ApiRequest<CreateIntegrationRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Integration>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Action postIntegrationsActionDraft(String actionId) throws IOException, ApiException {
        return this.postIntegrationsActionDraft(this.createPostIntegrationsActionDraftRequest(actionId));
    }

    public ApiResponse<Action> postIntegrationsActionDraftWithHttpInfo(String actionId) throws IOException {
        return this.postIntegrationsActionDraft(this.createPostIntegrationsActionDraftRequest(actionId).withHttpInfo());
    }

    private PostIntegrationsActionDraftRequest createPostIntegrationsActionDraftRequest(String actionId) {
        return PostIntegrationsActionDraftRequest.builder().withActionId(actionId).build();
    }

    public Action postIntegrationsActionDraft(PostIntegrationsActionDraftRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Action> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Action>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Action> postIntegrationsActionDraft(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Action>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Action postIntegrationsActionDraftPublish(String actionId, PublishDraftInput body) throws IOException, ApiException {
        return this.postIntegrationsActionDraftPublish(this.createPostIntegrationsActionDraftPublishRequest(actionId, body));
    }

    public ApiResponse<Action> postIntegrationsActionDraftPublishWithHttpInfo(String actionId, PublishDraftInput body) throws IOException {
        return this.postIntegrationsActionDraftPublish(this.createPostIntegrationsActionDraftPublishRequest(actionId, body).withHttpInfo());
    }

    private PostIntegrationsActionDraftPublishRequest createPostIntegrationsActionDraftPublishRequest(String actionId, PublishDraftInput body) {
        return PostIntegrationsActionDraftPublishRequest.builder().withActionId(actionId).withBody(body).build();
    }

    public Action postIntegrationsActionDraftPublish(PostIntegrationsActionDraftPublishRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Action> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Action>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Action> postIntegrationsActionDraftPublish(ApiRequest<PublishDraftInput> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Action>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public TestExecutionResult postIntegrationsActionDraftTest(String actionId, Object body) throws IOException, ApiException {
        return this.postIntegrationsActionDraftTest(this.createPostIntegrationsActionDraftTestRequest(actionId, body));
    }

    public ApiResponse<TestExecutionResult> postIntegrationsActionDraftTestWithHttpInfo(String actionId, Object body) throws IOException {
        return this.postIntegrationsActionDraftTest(this.createPostIntegrationsActionDraftTestRequest(actionId, body).withHttpInfo());
    }

    private PostIntegrationsActionDraftTestRequest createPostIntegrationsActionDraftTestRequest(String actionId, Object body) {
        return PostIntegrationsActionDraftTestRequest.builder().withActionId(actionId).withBody(body).build();
    }

    public TestExecutionResult postIntegrationsActionDraftTest(PostIntegrationsActionDraftTestRequest request) throws IOException, ApiException {
        try {
            ApiResponse<TestExecutionResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<TestExecutionResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<TestExecutionResult> postIntegrationsActionDraftTest(ApiRequest<Object> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<TestExecutionResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Object postIntegrationsActionExecute(String actionId, Object body) throws IOException, ApiException {
        return this.postIntegrationsActionExecute(this.createPostIntegrationsActionExecuteRequest(actionId, body));
    }

    public ApiResponse<Object> postIntegrationsActionExecuteWithHttpInfo(String actionId, Object body) throws IOException {
        return this.postIntegrationsActionExecute(this.createPostIntegrationsActionExecuteRequest(actionId, body).withHttpInfo());
    }

    private PostIntegrationsActionExecuteRequest createPostIntegrationsActionExecuteRequest(String actionId, Object body) {
        return PostIntegrationsActionExecuteRequest.builder().withActionId(actionId).withBody(body).build();
    }

    public Object postIntegrationsActionExecute(PostIntegrationsActionExecuteRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Object> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Object>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Object> postIntegrationsActionExecute(ApiRequest<Object> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Object>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public TestExecutionResult postIntegrationsActionTest(String actionId, Object body) throws IOException, ApiException {
        return this.postIntegrationsActionTest(this.createPostIntegrationsActionTestRequest(actionId, body));
    }

    public ApiResponse<TestExecutionResult> postIntegrationsActionTestWithHttpInfo(String actionId, Object body) throws IOException {
        return this.postIntegrationsActionTest(this.createPostIntegrationsActionTestRequest(actionId, body).withHttpInfo());
    }

    private PostIntegrationsActionTestRequest createPostIntegrationsActionTestRequest(String actionId, Object body) {
        return PostIntegrationsActionTestRequest.builder().withActionId(actionId).withBody(body).build();
    }

    public TestExecutionResult postIntegrationsActionTest(PostIntegrationsActionTestRequest request) throws IOException, ApiException {
        try {
            ApiResponse<TestExecutionResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<TestExecutionResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<TestExecutionResult> postIntegrationsActionTest(ApiRequest<Object> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<TestExecutionResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Action postIntegrationsActions(PostActionInput body) throws IOException, ApiException {
        return this.postIntegrationsActions(this.createPostIntegrationsActionsRequest(body));
    }

    public ApiResponse<Action> postIntegrationsActionsWithHttpInfo(PostActionInput body) throws IOException {
        return this.postIntegrationsActions(this.createPostIntegrationsActionsRequest(body).withHttpInfo());
    }

    private PostIntegrationsActionsRequest createPostIntegrationsActionsRequest(PostActionInput body) {
        return PostIntegrationsActionsRequest.builder().withBody(body).build();
    }

    public Action postIntegrationsActions(PostIntegrationsActionsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Action> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Action>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Action> postIntegrationsActions(ApiRequest<PostActionInput> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Action>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Action postIntegrationsActionsDrafts(PostActionInput body) throws IOException, ApiException {
        return this.postIntegrationsActionsDrafts(this.createPostIntegrationsActionsDraftsRequest(body));
    }

    public ApiResponse<Action> postIntegrationsActionsDraftsWithHttpInfo(PostActionInput body) throws IOException {
        return this.postIntegrationsActionsDrafts(this.createPostIntegrationsActionsDraftsRequest(body).withHttpInfo());
    }

    private PostIntegrationsActionsDraftsRequest createPostIntegrationsActionsDraftsRequest(PostActionInput body) {
        return PostIntegrationsActionsDraftsRequest.builder().withBody(body).build();
    }

    public Action postIntegrationsActionsDrafts(PostIntegrationsActionsDraftsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Action> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Action>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Action> postIntegrationsActionsDrafts(ApiRequest<PostActionInput> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Action>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CredentialInfo postIntegrationsCredentials(Credential body) throws IOException, ApiException {
        return this.postIntegrationsCredentials(this.createPostIntegrationsCredentialsRequest(body));
    }

    public ApiResponse<CredentialInfo> postIntegrationsCredentialsWithHttpInfo(Credential body) throws IOException {
        return this.postIntegrationsCredentials(this.createPostIntegrationsCredentialsRequest(body).withHttpInfo());
    }

    private PostIntegrationsCredentialsRequest createPostIntegrationsCredentialsRequest(Credential body) {
        return PostIntegrationsCredentialsRequest.builder().withBody(body).build();
    }

    public CredentialInfo postIntegrationsCredentials(PostIntegrationsCredentialsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CredentialInfo> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CredentialInfo>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CredentialInfo> postIntegrationsCredentials(ApiRequest<Credential> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CredentialInfo>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UserActionCategoryEntityListing postIntegrationsWorkforcemanagementVendorconnection(VendorConnectionRequest body) throws IOException, ApiException {
        return this.postIntegrationsWorkforcemanagementVendorconnection(this.createPostIntegrationsWorkforcemanagementVendorconnectionRequest(body));
    }

    public ApiResponse<UserActionCategoryEntityListing> postIntegrationsWorkforcemanagementVendorconnectionWithHttpInfo(VendorConnectionRequest body) throws IOException {
        return this.postIntegrationsWorkforcemanagementVendorconnection(this.createPostIntegrationsWorkforcemanagementVendorconnectionRequest(body).withHttpInfo());
    }

    private PostIntegrationsWorkforcemanagementVendorconnectionRequest createPostIntegrationsWorkforcemanagementVendorconnectionRequest(VendorConnectionRequest body) {
        return PostIntegrationsWorkforcemanagementVendorconnectionRequest.builder().withBody(body).build();
    }

    public UserActionCategoryEntityListing postIntegrationsWorkforcemanagementVendorconnection(PostIntegrationsWorkforcemanagementVendorconnectionRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UserActionCategoryEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UserActionCategoryEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UserActionCategoryEntityListing> postIntegrationsWorkforcemanagementVendorconnection(ApiRequest<VendorConnectionRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UserActionCategoryEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public IntegrationConfiguration putIntegrationConfigCurrent(String integrationId, IntegrationConfiguration body) throws IOException, ApiException {
        return this.putIntegrationConfigCurrent(this.createPutIntegrationConfigCurrentRequest(integrationId, body));
    }

    public ApiResponse<IntegrationConfiguration> putIntegrationConfigCurrentWithHttpInfo(String integrationId, IntegrationConfiguration body) throws IOException {
        return this.putIntegrationConfigCurrent(this.createPutIntegrationConfigCurrentRequest(integrationId, body).withHttpInfo());
    }

    private PutIntegrationConfigCurrentRequest createPutIntegrationConfigCurrentRequest(String integrationId, IntegrationConfiguration body) {
        return PutIntegrationConfigCurrentRequest.builder().withIntegrationId(integrationId).withBody(body).build();
    }

    public IntegrationConfiguration putIntegrationConfigCurrent(PutIntegrationConfigCurrentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<IntegrationConfiguration> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<IntegrationConfiguration>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<IntegrationConfiguration> putIntegrationConfigCurrent(ApiRequest<IntegrationConfiguration> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<IntegrationConfiguration>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CredentialInfo putIntegrationsCredential(String credentialId, Credential body) throws IOException, ApiException {
        return this.putIntegrationsCredential(this.createPutIntegrationsCredentialRequest(credentialId, body));
    }

    public ApiResponse<CredentialInfo> putIntegrationsCredentialWithHttpInfo(String credentialId, Credential body) throws IOException {
        return this.putIntegrationsCredential(this.createPutIntegrationsCredentialRequest(credentialId, body).withHttpInfo());
    }

    private PutIntegrationsCredentialRequest createPutIntegrationsCredentialRequest(String credentialId, Credential body) {
        return PutIntegrationsCredentialRequest.builder().withCredentialId(credentialId).withBody(body).build();
    }

    public CredentialInfo putIntegrationsCredential(PutIntegrationsCredentialRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CredentialInfo> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CredentialInfo>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CredentialInfo> putIntegrationsCredential(ApiRequest<Credential> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CredentialInfo>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

