/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UserPresenceRule
implements Serializable {
    private String id = null;
    private String name = null;
    private User presenceUser = null;
    private PresenceTypeEnum presenceType = null;
    private String presenceValue = null;
    private Integer presenceLimitInSeconds = null;
    private Boolean enabled = null;
    private Boolean inAlarm = null;
    private List<User> notificationUsers = new ArrayList<User>();
    private List<AlertTypesEnum> alertTypes = new ArrayList<AlertTypesEnum>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public UserPresenceRule name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the rule")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserPresenceRule presenceUser(User presenceUser) {
        this.presenceUser = presenceUser;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user whose presence will be watched.")
    @JsonProperty(value="presenceUser")
    public User getPresenceUser() {
        return this.presenceUser;
    }

    public void setPresenceUser(User presenceUser) {
        this.presenceUser = presenceUser;
    }

    public UserPresenceRule presenceType(PresenceTypeEnum presenceType) {
        this.presenceType = presenceType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates to which presence type the presence value belongs.")
    @JsonProperty(value="presenceType")
    public PresenceTypeEnum getPresenceType() {
        return this.presenceType;
    }

    public void setPresenceType(PresenceTypeEnum presenceType) {
        this.presenceType = presenceType;
    }

    public UserPresenceRule presenceValue(String presenceValue) {
        this.presenceValue = presenceValue;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Org's UUID or Systems enum constance indicating the presence of concern.")
    @JsonProperty(value="presenceValue")
    public String getPresenceValue() {
        return this.presenceValue;
    }

    public void setPresenceValue(String presenceValue) {
        this.presenceValue = presenceValue;
    }

    public UserPresenceRule presenceLimitInSeconds(Integer presenceLimitInSeconds) {
        this.presenceLimitInSeconds = presenceLimitInSeconds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The number of seconds to wait before alerting based upon the user's presence.")
    @JsonProperty(value="presenceLimitInSeconds")
    public Integer getPresenceLimitInSeconds() {
        return this.presenceLimitInSeconds;
    }

    public void setPresenceLimitInSeconds(Integer presenceLimitInSeconds) {
        this.presenceLimitInSeconds = presenceLimitInSeconds;
    }

    public UserPresenceRule enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates if the rule is enabled.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @ApiModelProperty(example="null", value="Indicates if the rule is in alarm state.")
    @JsonProperty(value="inAlarm")
    public Boolean getInAlarm() {
        return this.inAlarm;
    }

    public UserPresenceRule notificationUsers(List<User> notificationUsers) {
        this.notificationUsers = notificationUsers;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ids of users who will be notified of alarm state change.")
    @JsonProperty(value="notificationUsers")
    public List<User> getNotificationUsers() {
        return this.notificationUsers;
    }

    public void setNotificationUsers(List<User> notificationUsers) {
        this.notificationUsers = notificationUsers;
    }

    public UserPresenceRule alertTypes(List<AlertTypesEnum> alertTypes) {
        this.alertTypes = alertTypes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A collection of notification methods.")
    @JsonProperty(value="alertTypes")
    public List<AlertTypesEnum> getAlertTypes() {
        return this.alertTypes;
    }

    public void setAlertTypes(List<AlertTypesEnum> alertTypes) {
        this.alertTypes = alertTypes;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserPresenceRule userPresenceRule = (UserPresenceRule)o;
        return Objects.equals(this.id, userPresenceRule.id) && Objects.equals(this.name, userPresenceRule.name) && Objects.equals(this.presenceUser, userPresenceRule.presenceUser) && Objects.equals((Object)this.presenceType, (Object)userPresenceRule.presenceType) && Objects.equals(this.presenceValue, userPresenceRule.presenceValue) && Objects.equals(this.presenceLimitInSeconds, userPresenceRule.presenceLimitInSeconds) && Objects.equals(this.enabled, userPresenceRule.enabled) && Objects.equals(this.inAlarm, userPresenceRule.inAlarm) && Objects.equals(this.notificationUsers, userPresenceRule.notificationUsers) && Objects.equals(this.alertTypes, userPresenceRule.alertTypes) && Objects.equals(this.selfUri, userPresenceRule.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.presenceUser, this.presenceType, this.presenceValue, this.presenceLimitInSeconds, this.enabled, this.inAlarm, this.notificationUsers, this.alertTypes, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserPresenceRule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    presenceUser: ").append(this.toIndentedString(this.presenceUser)).append("\n");
        sb.append("    presenceType: ").append(this.toIndentedString((Object)this.presenceType)).append("\n");
        sb.append("    presenceValue: ").append(this.toIndentedString(this.presenceValue)).append("\n");
        sb.append("    presenceLimitInSeconds: ").append(this.toIndentedString(this.presenceLimitInSeconds)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    inAlarm: ").append(this.toIndentedString(this.inAlarm)).append("\n");
        sb.append("    notificationUsers: ").append(this.toIndentedString(this.notificationUsers)).append("\n");
        sb.append("    alertTypes: ").append(this.toIndentedString(this.alertTypes)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AlertTypesEnum {
        SMS("SMS"),
        DEVICE("DEVICE"),
        EMAIL("EMAIL");

        private String value;

        private AlertTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AlertTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AlertTypesEnum value : AlertTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AlertTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum PresenceTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SYSTEM("SYSTEM"),
        ORGANIZATION("ORGANIZATION");

        private String value;

        private PresenceTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PresenceTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PresenceTypeEnum value : PresenceTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PresenceTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

