/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Schedule;
import java.util.HashMap;
import java.util.Map;

public class PutArchitectScheduleRequest {
    private String scheduleId;
    private Schedule body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public PutArchitectScheduleRequest withScheduleId(String scheduleId) {
        this.setScheduleId(scheduleId);
        return this;
    }

    public Schedule getBody() {
        return this.body;
    }

    public void setBody(Schedule body) {
        this.body = body;
    }

    public PutArchitectScheduleRequest withBody(Schedule body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutArchitectScheduleRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Schedule> withHttpInfo() {
        if (this.scheduleId == null) {
            throw new IllegalStateException("Missing the required parameter 'scheduleId' when building request for PutArchitectScheduleRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutArchitectScheduleRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/architect/schedules/{scheduleId}").withPathParameter("scheduleId", this.scheduleId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String scheduleId, Schedule body) {
        return new Builder().withRequiredParams(scheduleId, body);
    }

    public static class Builder {
        private final PutArchitectScheduleRequest request = new PutArchitectScheduleRequest();

        private Builder() {
        }

        public Builder withScheduleId(String scheduleId) {
            this.request.setScheduleId(scheduleId);
            return this;
        }

        public Builder withBody(Schedule body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String scheduleId, Schedule body) {
            this.request.setScheduleId(scheduleId);
            this.request.setBody(body);
            return this;
        }

        public PutArchitectScheduleRequest build() {
            if (this.request.scheduleId == null) {
                throw new IllegalStateException("Missing the required parameter 'scheduleId' when building request for PutArchitectScheduleRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutArchitectScheduleRequest.");
            }
            return this.request;
        }
    }
}

