/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.QueueMember;
import java.util.HashMap;
import java.util.Map;

public class PatchRoutingQueueUserRequest {
    private String queueId;
    private String memberId;
    private QueueMember body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public PatchRoutingQueueUserRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public PatchRoutingQueueUserRequest withMemberId(String memberId) {
        this.setMemberId(memberId);
        return this;
    }

    public QueueMember getBody() {
        return this.body;
    }

    public void setBody(QueueMember body) {
        this.body = body;
    }

    public PatchRoutingQueueUserRequest withBody(QueueMember body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchRoutingQueueUserRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<QueueMember> withHttpInfo() {
        if (this.queueId == null) {
            throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PatchRoutingQueueUserRequest.");
        }
        if (this.memberId == null) {
            throw new IllegalStateException("Missing the required parameter 'memberId' when building request for PatchRoutingQueueUserRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchRoutingQueueUserRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/routing/queues/{queueId}/users/{memberId}").withPathParameter("queueId", this.queueId).withPathParameter("memberId", this.memberId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String queueId, String memberId, QueueMember body) {
        return new Builder().withRequiredParams(queueId, memberId, body);
    }

    public static class Builder {
        private final PatchRoutingQueueUserRequest request = new PatchRoutingQueueUserRequest();

        private Builder() {
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withMemberId(String memberId) {
            this.request.setMemberId(memberId);
            return this;
        }

        public Builder withBody(QueueMember body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String queueId, String memberId, QueueMember body) {
            this.request.setQueueId(queueId);
            this.request.setMemberId(memberId);
            this.request.setBody(body);
            return this;
        }

        public PatchRoutingQueueUserRequest build() {
            if (this.request.queueId == null) {
                throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PatchRoutingQueueUserRequest.");
            }
            if (this.request.memberId == null) {
                throw new IllegalStateException("Missing the required parameter 'memberId' when building request for PatchRoutingQueueUserRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchRoutingQueueUserRequest.");
            }
            return this.request;
        }
    }
}

