/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.connector.okhttp;

import com.google.common.util.concurrent.SettableFuture;
import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.connector.ApiClientConnector;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorRequest;
import com.mypurecloud.sdk.v2.connector.ApiClientConnectorResponse;
import com.mypurecloud.sdk.v2.connector.okhttp.OkHttpResponse;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Future;

public class OkHttpClientConnector
implements ApiClientConnector {
    private final OkHttpClient client;

    public OkHttpClientConnector(OkHttpClient client) {
        this.client = client;
    }

    @Override
    public ApiClientConnectorResponse invoke(ApiClientConnectorRequest request) throws IOException {
        Call call = this.client.newCall(this.buildRequest(request));
        return new OkHttpResponse(call.execute());
    }

    @Override
    public Future<ApiClientConnectorResponse> invokeAsync(ApiClientConnectorRequest request, final AsyncApiCallback<ApiClientConnectorResponse> callback) {
        final SettableFuture future = SettableFuture.create();
        try {
            Call call = this.client.newCall(this.buildRequest(request));
            call.enqueue(new Callback(){

                public void onFailure(Request request, IOException e) {
                    callback.onFailed(e);
                    future.setException((Throwable)e);
                }

                public void onResponse(Response response) throws IOException {
                    OkHttpResponse okHttpResponse = new OkHttpResponse(response);
                    callback.onCompleted(okHttpResponse);
                    future.set((Object)new OkHttpResponse(response));
                }
            });
        }
        catch (Throwable exception) {
            callback.onFailed(exception);
            future.setException(exception);
        }
        return future;
    }

    private Request buildRequest(ApiClientConnectorRequest request) throws IOException {
        String method;
        Request.Builder builder = new Request.Builder().url(request.getUrl());
        Map<String, String> headers = request.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                builder = builder.addHeader(header.getKey(), header.getValue());
            }
        }
        if ("GET".equals(method = request.getMethod())) {
            builder = builder.get();
        } else if ("HEAD".equals(method)) {
            builder = builder.head();
        } else if ("POST".equals(method)) {
            builder = builder.post(this.createBody(request));
        } else if ("PUT".equals(method)) {
            builder = builder.put(this.createBody(request));
        } else if ("DELETE".equals(method)) {
            builder = builder.delete();
        } else if ("PATCH".equals(method)) {
            builder = builder.patch(this.createBody(request));
        } else {
            throw new IllegalStateException("Unknown method type " + method);
        }
        return builder.build();
    }

    private RequestBody createBody(ApiClientConnectorRequest request) throws IOException {
        String contentType = "application/json";
        Map<String, String> headers = request.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            for (String name : headers.keySet()) {
                if (!name.equalsIgnoreCase("content-type")) continue;
                contentType = headers.get(name);
                break;
            }
        }
        if (request.hasBody()) {
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)request.readBody());
        }
        return RequestBody.create(null, (byte[])new byte[0]);
    }

    @Override
    public void close() throws Exception {
    }
}

