/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.AnalyticsQueryFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ObservationQuery
implements Serializable {
    private AnalyticsQueryFilter filter = null;
    private List<MetricsEnum> metrics = new ArrayList<MetricsEnum>();

    public ObservationQuery filter(AnalyticsQueryFilter filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Filter to return a subset of observations. Expresses boolean logical predicates as well as dimensional filters")
    @JsonProperty(value="filter")
    public AnalyticsQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(AnalyticsQueryFilter filter) {
        this.filter = filter;
    }

    public ObservationQuery metrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL SELECT clause. Enables retrieving only named metrics. If omitted, all metrics that are available will be returned (like SELECT *).")
    @JsonProperty(value="metrics")
    public List<MetricsEnum> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObservationQuery observationQuery = (ObservationQuery)o;
        return Objects.equals(this.filter, observationQuery.filter) && Objects.equals(this.metrics, observationQuery.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.metrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ObservationQuery {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MetricsEnum {
        TSEGMENTDURATION("tSegmentDuration"),
        TCONVERSATIONDURATION("tConversationDuration"),
        OTOTALCRITICALSCORE("oTotalCriticalScore"),
        OTOTALSCORE("oTotalScore"),
        NEVALUATIONS("nEvaluations"),
        TABANDON("tAbandon"),
        TIVR("tIvr"),
        TANSWERED("tAnswered"),
        TFLOWOUT("tFlowOut"),
        TACD("tAcd"),
        TTALK("tTalk"),
        THELD("tHeld"),
        TTALKCOMPLETE("tTalkComplete"),
        THELDCOMPLETE("tHeldComplete"),
        TACW("tAcw"),
        THANDLE("tHandle"),
        TCONTACTING("tContacting"),
        TDIALING("tDialing"),
        TWAIT("tWait"),
        TAGENTROUTINGSTATUS("tAgentRoutingStatus"),
        TORGANIZATIONPRESENCE("tOrganizationPresence"),
        TSYSTEMPRESENCE("tSystemPresence"),
        TUSERRESPONSETIME("tUserResponseTime"),
        TAGENTRESPONSETIME("tAgentResponseTime"),
        TVOICEMAIL("tVoicemail"),
        NSTATETRANSITIONERROR("nStateTransitionError"),
        NOFFERED("nOffered"),
        NOVERSLA("nOverSla"),
        NTRANSFERRED("nTransferred"),
        TALERT("tAlert"),
        TNOTRESPONDING("tNotResponding"),
        NOUTBOUND("nOutbound"),
        NOUTBOUNDATTEMPTED("nOutboundAttempted"),
        NOUTBOUNDCONNECTED("nOutboundConnected"),
        NOUTBOUNDABANDONED("nOutboundAbandoned"),
        NERROR("nError"),
        OSERVICETARGET("oServiceTarget"),
        OSERVICELEVEL("oServiceLevel"),
        TACTIVE("tActive"),
        TINACTIVE("tInactive"),
        OACTIVEUSERS("oActiveUsers"),
        OMEMBERUSERS("oMemberUsers"),
        OACTIVEQUEUES("oActiveQueues"),
        OMEMBERQUEUES("oMemberQueues"),
        OINTERACTING("oInteracting"),
        OWAITING("oWaiting"),
        OONQUEUEUSERS("oOnQueueUsers"),
        OOFFQUEUEUSERS("oOffQueueUsers"),
        OUSERPRESENCES("oUserPresences"),
        OUSERROUTINGSTATUSES("oUserRoutingStatuses");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricsEnum value : MetricsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

