/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class CreateAsgRequest
implements Serializable {
    private String asgOwnerEmail = null;
    private String edgeGroupId = null;
    private String externalTrunkBaseId = null;
    private String asgLogicalIAMInstanceProfile = null;
    private Boolean asgAmi = null;
    private AsgTypeEnum asgType = null;
    private Integer asgInstanceCount = null;
    private String asgNetworkSpace = null;
    private Boolean asgChaosExempt = null;
    private Integer asgRecoveryShutdownMinutes = null;

    public CreateAsgRequest asgOwnerEmail(String asgOwnerEmail) {
        this.asgOwnerEmail = asgOwnerEmail;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Email address of the individual starting the ASG")
    @JsonProperty(value="asgOwnerEmail")
    public String getAsgOwnerEmail() {
        return this.asgOwnerEmail;
    }

    public void setAsgOwnerEmail(String asgOwnerEmail) {
        this.asgOwnerEmail = asgOwnerEmail;
    }

    public CreateAsgRequest edgeGroupId(String edgeGroupId) {
        this.edgeGroupId = edgeGroupId;
        return this;
    }

    @ApiModelProperty(example="null", value="Edge group that the user wants the asg edges to be assigned to.")
    @JsonProperty(value="edgeGroupId")
    public String getEdgeGroupId() {
        return this.edgeGroupId;
    }

    public void setEdgeGroupId(String edgeGroupId) {
        this.edgeGroupId = edgeGroupId;
    }

    public CreateAsgRequest externalTrunkBaseId(String externalTrunkBaseId) {
        this.externalTrunkBaseId = externalTrunkBaseId;
        return this;
    }

    @ApiModelProperty(example="null", value="Trunk base that the user wants the asg edges to be assigned to")
    @JsonProperty(value="externalTrunkBaseId")
    public String getExternalTrunkBaseId() {
        return this.externalTrunkBaseId;
    }

    public void setExternalTrunkBaseId(String externalTrunkBaseId) {
        this.externalTrunkBaseId = externalTrunkBaseId;
    }

    public CreateAsgRequest asgLogicalIAMInstanceProfile(String asgLogicalIAMInstanceProfile) {
        this.asgLogicalIAMInstanceProfile = asgLogicalIAMInstanceProfile;
        return this;
    }

    @ApiModelProperty(example="null", value="Overrides the default logical IAM Instance Profile")
    @JsonProperty(value="asgLogicalIAMInstanceProfile")
    public String getAsgLogicalIAMInstanceProfile() {
        return this.asgLogicalIAMInstanceProfile;
    }

    public void setAsgLogicalIAMInstanceProfile(String asgLogicalIAMInstanceProfile) {
        this.asgLogicalIAMInstanceProfile = asgLogicalIAMInstanceProfile;
    }

    public CreateAsgRequest asgAmi(Boolean asgAmi) {
        this.asgAmi = asgAmi;
        return this;
    }

    @ApiModelProperty(example="null", value="Overrides the default EDGE AMI used with the ASG")
    @JsonProperty(value="asgAmi")
    public Boolean getAsgAmi() {
        return this.asgAmi;
    }

    public void setAsgAmi(Boolean asgAmi) {
        this.asgAmi = asgAmi;
    }

    public CreateAsgRequest asgType(AsgTypeEnum asgType) {
        this.asgType = asgType;
        return this;
    }

    @ApiModelProperty(example="null", value="Overrides the type of ASG being created.  By default we always create a 'standard' asg.")
    @JsonProperty(value="asgType")
    public AsgTypeEnum getAsgType() {
        return this.asgType;
    }

    public void setAsgType(AsgTypeEnum asgType) {
        this.asgType = asgType;
    }

    public CreateAsgRequest asgInstanceCount(Integer asgInstanceCount) {
        this.asgInstanceCount = asgInstanceCount;
        return this;
    }

    @ApiModelProperty(example="null", value="Overrides the default number of Edge instances to start in the ASG")
    @JsonProperty(value="asgInstanceCount")
    public Integer getAsgInstanceCount() {
        return this.asgInstanceCount;
    }

    public void setAsgInstanceCount(Integer asgInstanceCount) {
        this.asgInstanceCount = asgInstanceCount;
    }

    public CreateAsgRequest asgNetworkSpace(String asgNetworkSpace) {
        this.asgNetworkSpace = asgNetworkSpace;
        return this;
    }

    @ApiModelProperty(example="null", value="Overrides the network space the ASG will start in.  The default will always be mediaservices")
    @JsonProperty(value="asgNetworkSpace")
    public String getAsgNetworkSpace() {
        return this.asgNetworkSpace;
    }

    public void setAsgNetworkSpace(String asgNetworkSpace) {
        this.asgNetworkSpace = asgNetworkSpace;
    }

    public CreateAsgRequest asgChaosExempt(Boolean asgChaosExempt) {
        this.asgChaosExempt = asgChaosExempt;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional parameter that exempts this ASG from chaos monkey killing one of its instances.")
    @JsonProperty(value="asgChaosExempt")
    public Boolean getAsgChaosExempt() {
        return this.asgChaosExempt;
    }

    public void setAsgChaosExempt(Boolean asgChaosExempt) {
        this.asgChaosExempt = asgChaosExempt;
    }

    public CreateAsgRequest asgRecoveryShutdownMinutes(Integer asgRecoveryShutdownMinutes) {
        this.asgRecoveryShutdownMinutes = asgRecoveryShutdownMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of minutes a recovery ASG will stay active before it is torn down")
    @JsonProperty(value="asgRecoveryShutdownMinutes")
    public Integer getAsgRecoveryShutdownMinutes() {
        return this.asgRecoveryShutdownMinutes;
    }

    public void setAsgRecoveryShutdownMinutes(Integer asgRecoveryShutdownMinutes) {
        this.asgRecoveryShutdownMinutes = asgRecoveryShutdownMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAsgRequest createAsgRequest = (CreateAsgRequest)o;
        return Objects.equals(this.asgOwnerEmail, createAsgRequest.asgOwnerEmail) && Objects.equals(this.edgeGroupId, createAsgRequest.edgeGroupId) && Objects.equals(this.externalTrunkBaseId, createAsgRequest.externalTrunkBaseId) && Objects.equals(this.asgLogicalIAMInstanceProfile, createAsgRequest.asgLogicalIAMInstanceProfile) && Objects.equals(this.asgAmi, createAsgRequest.asgAmi) && Objects.equals((Object)this.asgType, (Object)createAsgRequest.asgType) && Objects.equals(this.asgInstanceCount, createAsgRequest.asgInstanceCount) && Objects.equals(this.asgNetworkSpace, createAsgRequest.asgNetworkSpace) && Objects.equals(this.asgChaosExempt, createAsgRequest.asgChaosExempt) && Objects.equals(this.asgRecoveryShutdownMinutes, createAsgRequest.asgRecoveryShutdownMinutes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.asgOwnerEmail, this.edgeGroupId, this.externalTrunkBaseId, this.asgLogicalIAMInstanceProfile, this.asgAmi, this.asgType, this.asgInstanceCount, this.asgNetworkSpace, this.asgChaosExempt, this.asgRecoveryShutdownMinutes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAsgRequest {\n");
        sb.append("    asgOwnerEmail: ").append(this.toIndentedString(this.asgOwnerEmail)).append("\n");
        sb.append("    edgeGroupId: ").append(this.toIndentedString(this.edgeGroupId)).append("\n");
        sb.append("    externalTrunkBaseId: ").append(this.toIndentedString(this.externalTrunkBaseId)).append("\n");
        sb.append("    asgLogicalIAMInstanceProfile: ").append(this.toIndentedString(this.asgLogicalIAMInstanceProfile)).append("\n");
        sb.append("    asgAmi: ").append(this.toIndentedString(this.asgAmi)).append("\n");
        sb.append("    asgType: ").append(this.toIndentedString((Object)this.asgType)).append("\n");
        sb.append("    asgInstanceCount: ").append(this.toIndentedString(this.asgInstanceCount)).append("\n");
        sb.append("    asgNetworkSpace: ").append(this.toIndentedString(this.asgNetworkSpace)).append("\n");
        sb.append("    asgChaosExempt: ").append(this.toIndentedString(this.asgChaosExempt)).append("\n");
        sb.append("    asgRecoveryShutdownMinutes: ").append(this.toIndentedString(this.asgRecoveryShutdownMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AsgTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STANDARD("standard"),
        RECOVERY("recovery");

        private String value;

        private AsgTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AsgTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AsgTypeEnum value : AsgTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AsgTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

