/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ActionConfig;
import com.mypurecloud.sdk.v2.model.ActionContractInput;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Definition of an Action to be created or updated.")
public class PostActionInput
implements Serializable {
    private String category = null;
    private String name = null;
    private String integrationId = null;
    private ActionConfig config = null;
    private ActionContractInput contract = null;
    private Boolean secure = null;

    public PostActionInput category(String category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Category of action")
    @JsonProperty(value="category")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public PostActionInput name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of action")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PostActionInput integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the integration this action is associated to")
    @JsonProperty(value="integrationId")
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public PostActionInput config(ActionConfig config) {
        this.config = config;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Configuration to support request and response processing")
    @JsonProperty(value="config")
    public ActionConfig getConfig() {
        return this.config;
    }

    public void setConfig(ActionConfig config) {
        this.config = config;
    }

    public PostActionInput contract(ActionContractInput contract) {
        this.contract = contract;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Action contract")
    @JsonProperty(value="contract")
    public ActionContractInput getContract() {
        return this.contract;
    }

    public void setContract(ActionContractInput contract) {
        this.contract = contract;
    }

    public PostActionInput secure(Boolean secure) {
        this.secure = secure;
        return this;
    }

    @ApiModelProperty(example="null", value="Indication of whether or not the action is designed to accept sensitive data")
    @JsonProperty(value="secure")
    public Boolean getSecure() {
        return this.secure;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostActionInput postActionInput = (PostActionInput)o;
        return Objects.equals(this.category, postActionInput.category) && Objects.equals(this.name, postActionInput.name) && Objects.equals(this.integrationId, postActionInput.integrationId) && Objects.equals(this.config, postActionInput.config) && Objects.equals(this.contract, postActionInput.contract) && Objects.equals(this.secure, postActionInput.secure);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.name, this.integrationId, this.config, this.contract, this.secure);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostActionInput {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    contract: ").append(this.toIndentedString(this.contract)).append("\n");
        sb.append("    secure: ").append(this.toIndentedString(this.secure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

