/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetGroupProfileRequest {
    private String groupId;
    private String fields;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public GetGroupProfileRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public GetGroupProfileRequest withFields(String fields) {
        this.setFields(fields);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetGroupProfileRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.groupId == null) {
            throw new IllegalStateException("Missing the required parameter 'groupId' when building request for GetGroupProfileRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/groups/{groupId}/profile").withPathParameter("groupId", this.groupId).withQueryParameters("fields", "", this.fields).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String groupId) {
        return new Builder().withRequiredParams(groupId);
    }

    public static class Builder {
        private final GetGroupProfileRequest request = new GetGroupProfileRequest();

        private Builder() {
        }

        public Builder withGroupId(String groupId) {
            this.request.setGroupId(groupId);
            return this;
        }

        public Builder withFields(String fields) {
            this.request.setFields(fields);
            return this;
        }

        public Builder withRequiredParams(String groupId) {
            this.request.setGroupId(groupId);
            return this;
        }

        public GetGroupProfileRequest build() {
            if (this.request.groupId == null) {
                throw new IllegalStateException("Missing the required parameter 'groupId' when building request for GetGroupProfileRequest.");
            }
            return this.request;
        }
    }
}

