/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteLanguageRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteRoutingLanguageRequest;
import com.mypurecloud.sdk.v2.api.request.GetLanguageRequest;
import com.mypurecloud.sdk.v2.api.request.GetLanguagesRequest;
import com.mypurecloud.sdk.v2.api.request.GetLanguagesTranslationsBuiltinRequest;
import com.mypurecloud.sdk.v2.api.request.GetLanguagesTranslationsOrganizationRequest;
import com.mypurecloud.sdk.v2.api.request.GetLanguagesTranslationsRequest;
import com.mypurecloud.sdk.v2.api.request.GetLanguagesTranslationsUserRequest;
import com.mypurecloud.sdk.v2.api.request.GetRoutingLanguageRequest;
import com.mypurecloud.sdk.v2.api.request.PostLanguagesRequest;
import com.mypurecloud.sdk.v2.model.AvailableTranslations;
import com.mypurecloud.sdk.v2.model.Language;
import com.mypurecloud.sdk.v2.model.LanguageEntityListing;
import java.io.IOException;
import java.util.Map;

public class LanguagesApi {
    private final ApiClient pcapiClient;

    public LanguagesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LanguagesApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteLanguage(String languageId) throws IOException, ApiException {
        this.deleteLanguage(this.createDeleteLanguageRequest(languageId));
    }

    public ApiResponse<Void> deleteLanguageWithHttpInfo(String languageId) throws IOException {
        return this.deleteLanguage(this.createDeleteLanguageRequest(languageId).withHttpInfo());
    }

    private DeleteLanguageRequest createDeleteLanguageRequest(String languageId) {
        return DeleteLanguageRequest.builder().withLanguageId(languageId).build();
    }

    public void deleteLanguage(DeleteLanguageRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteLanguage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteRoutingLanguage(String languageId) throws IOException, ApiException {
        this.deleteRoutingLanguage(this.createDeleteRoutingLanguageRequest(languageId));
    }

    public ApiResponse<Void> deleteRoutingLanguageWithHttpInfo(String languageId) throws IOException {
        return this.deleteRoutingLanguage(this.createDeleteRoutingLanguageRequest(languageId).withHttpInfo());
    }

    private DeleteRoutingLanguageRequest createDeleteRoutingLanguageRequest(String languageId) {
        return DeleteRoutingLanguageRequest.builder().withLanguageId(languageId).build();
    }

    public void deleteRoutingLanguage(DeleteRoutingLanguageRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteRoutingLanguage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Language getLanguage(String languageId) throws IOException, ApiException {
        return this.getLanguage(this.createGetLanguageRequest(languageId));
    }

    public ApiResponse<Language> getLanguageWithHttpInfo(String languageId) throws IOException {
        return this.getLanguage(this.createGetLanguageRequest(languageId).withHttpInfo());
    }

    private GetLanguageRequest createGetLanguageRequest(String languageId) {
        return GetLanguageRequest.builder().withLanguageId(languageId).build();
    }

    public Language getLanguage(GetLanguageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Language> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Language>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Language> getLanguage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Language>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public LanguageEntityListing getLanguages(Integer pageSize, Integer pageNumber, String sortOrder, String name) throws IOException, ApiException {
        return this.getLanguages(this.createGetLanguagesRequest(pageSize, pageNumber, sortOrder, name));
    }

    public ApiResponse<LanguageEntityListing> getLanguagesWithHttpInfo(Integer pageSize, Integer pageNumber, String sortOrder, String name) throws IOException {
        return this.getLanguages(this.createGetLanguagesRequest(pageSize, pageNumber, sortOrder, name).withHttpInfo());
    }

    private GetLanguagesRequest createGetLanguagesRequest(Integer pageSize, Integer pageNumber, String sortOrder, String name) {
        return GetLanguagesRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).withSortOrder(sortOrder).withName(name).build();
    }

    public LanguageEntityListing getLanguages(GetLanguagesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<LanguageEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<LanguageEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<LanguageEntityListing> getLanguages(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<LanguageEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AvailableTranslations getLanguagesTranslations() throws IOException, ApiException {
        return this.getLanguagesTranslations(this.createGetLanguagesTranslationsRequest());
    }

    public ApiResponse<AvailableTranslations> getLanguagesTranslationsWithHttpInfo() throws IOException {
        return this.getLanguagesTranslations(this.createGetLanguagesTranslationsRequest().withHttpInfo());
    }

    private GetLanguagesTranslationsRequest createGetLanguagesTranslationsRequest() {
        return GetLanguagesTranslationsRequest.builder().build();
    }

    public AvailableTranslations getLanguagesTranslations(GetLanguagesTranslationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AvailableTranslations> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AvailableTranslations>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AvailableTranslations> getLanguagesTranslations(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AvailableTranslations>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Map<String, Object> getLanguagesTranslationsBuiltin(String language) throws IOException, ApiException {
        return this.getLanguagesTranslationsBuiltin(this.createGetLanguagesTranslationsBuiltinRequest(language));
    }

    public ApiResponse<Map<String, Object>> getLanguagesTranslationsBuiltinWithHttpInfo(String language) throws IOException {
        return this.getLanguagesTranslationsBuiltin(this.createGetLanguagesTranslationsBuiltinRequest(language).withHttpInfo());
    }

    private GetLanguagesTranslationsBuiltinRequest createGetLanguagesTranslationsBuiltinRequest(String language) {
        return GetLanguagesTranslationsBuiltinRequest.builder().withLanguage(language).build();
    }

    public Map<String, Object> getLanguagesTranslationsBuiltin(GetLanguagesTranslationsBuiltinRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Map<String, Object>> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Map<String, Object>>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Map<String, Object>> getLanguagesTranslationsBuiltin(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Map<String, Object>>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Map<String, Object> getLanguagesTranslationsOrganization(String language) throws IOException, ApiException {
        return this.getLanguagesTranslationsOrganization(this.createGetLanguagesTranslationsOrganizationRequest(language));
    }

    public ApiResponse<Map<String, Object>> getLanguagesTranslationsOrganizationWithHttpInfo(String language) throws IOException {
        return this.getLanguagesTranslationsOrganization(this.createGetLanguagesTranslationsOrganizationRequest(language).withHttpInfo());
    }

    private GetLanguagesTranslationsOrganizationRequest createGetLanguagesTranslationsOrganizationRequest(String language) {
        return GetLanguagesTranslationsOrganizationRequest.builder().withLanguage(language).build();
    }

    public Map<String, Object> getLanguagesTranslationsOrganization(GetLanguagesTranslationsOrganizationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Map<String, Object>> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Map<String, Object>>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Map<String, Object>> getLanguagesTranslationsOrganization(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Map<String, Object>>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Map<String, Object> getLanguagesTranslationsUser(String userId) throws IOException, ApiException {
        return this.getLanguagesTranslationsUser(this.createGetLanguagesTranslationsUserRequest(userId));
    }

    public ApiResponse<Map<String, Object>> getLanguagesTranslationsUserWithHttpInfo(String userId) throws IOException {
        return this.getLanguagesTranslationsUser(this.createGetLanguagesTranslationsUserRequest(userId).withHttpInfo());
    }

    private GetLanguagesTranslationsUserRequest createGetLanguagesTranslationsUserRequest(String userId) {
        return GetLanguagesTranslationsUserRequest.builder().withUserId(userId).build();
    }

    public Map<String, Object> getLanguagesTranslationsUser(GetLanguagesTranslationsUserRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Map<String, Object>> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Map<String, Object>>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Map<String, Object>> getLanguagesTranslationsUser(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Map<String, Object>>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Language getRoutingLanguage(String languageId) throws IOException, ApiException {
        return this.getRoutingLanguage(this.createGetRoutingLanguageRequest(languageId));
    }

    public ApiResponse<Language> getRoutingLanguageWithHttpInfo(String languageId) throws IOException {
        return this.getRoutingLanguage(this.createGetRoutingLanguageRequest(languageId).withHttpInfo());
    }

    private GetRoutingLanguageRequest createGetRoutingLanguageRequest(String languageId) {
        return GetRoutingLanguageRequest.builder().withLanguageId(languageId).build();
    }

    public Language getRoutingLanguage(GetRoutingLanguageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Language> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Language>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Language> getRoutingLanguage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Language>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Language postLanguages(Language body) throws IOException, ApiException {
        return this.postLanguages(this.createPostLanguagesRequest(body));
    }

    public ApiResponse<Language> postLanguagesWithHttpInfo(Language body) throws IOException {
        return this.postLanguages(this.createPostLanguagesRequest(body).withHttpInfo());
    }

    private PostLanguagesRequest createPostLanguagesRequest(Language body) {
        return PostLanguagesRequest.builder().withBody(body).build();
    }

    public Language postLanguages(PostLanguagesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Language> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Language>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Language> postLanguages(ApiRequest<Language> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Language>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

