/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.EmailMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PostConversationsEmailMessagesRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String emailId;
    private EmailMessage body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public PostConversationsEmailMessagesRequest withEmailId(String emailId) {
        this.setEmailId(emailId);
        return this;
    }

    public EmailMessage getBody() {
        return this.body;
    }

    public void setBody(EmailMessage body) {
        this.body = body;
    }

    public PostConversationsEmailMessagesRequest withBody(EmailMessage body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationsEmailMessagesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<EmailMessage> withHttpInfo() {
        if (this.emailId == null) {
            throw new IllegalStateException("Missing the required parameter 'emailId' when building request for PostConversationsEmailMessagesRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsEmailMessagesRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/emails/{emailId}/messages").withPathParameter("emailId", this.emailId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String emailId, EmailMessage body) {
        return new Builder().withRequiredParams(emailId, body);
    }

    public static class Builder {
        private final PostConversationsEmailMessagesRequest request = new PostConversationsEmailMessagesRequest();

        private Builder() {
        }

        public Builder withEmailId(String emailId) {
            this.request.setEmailId(emailId);
            return this;
        }

        public Builder withBody(EmailMessage body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String emailId, EmailMessage body) {
            this.request.setEmailId(emailId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationsEmailMessagesRequest build() {
            return this.request;
        }
    }
}

