/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetScriptPageRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String scriptId;
    private String pageId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public GetScriptPageRequest withScriptId(String scriptId) {
        this.setScriptId(scriptId);
        return this;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public GetScriptPageRequest withPageId(String pageId) {
        this.setPageId(pageId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetScriptPageRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.scriptId == null) {
            throw new IllegalStateException("Missing the required parameter 'scriptId' when building request for GetScriptPageRequest.");
        }
        if (this.pageId == null) {
            throw new IllegalStateException("Missing the required parameter 'pageId' when building request for GetScriptPageRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/scripts/{scriptId}/pages/{pageId}").withPathParameter("scriptId", this.scriptId).withPathParameter("pageId", this.pageId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String scriptId, String pageId) {
        return new Builder().withRequiredParams(scriptId, pageId);
    }

    public static class Builder {
        private final GetScriptPageRequest request = new GetScriptPageRequest();

        private Builder() {
        }

        public Builder withScriptId(String scriptId) {
            this.request.setScriptId(scriptId);
            return this;
        }

        public Builder withPageId(String pageId) {
            this.request.setPageId(pageId);
            return this;
        }

        public Builder withRequiredParams(String scriptId, String pageId) {
            this.request.setScriptId(scriptId);
            this.request.setPageId(pageId);
            return this;
        }

        public GetScriptPageRequest build() {
            return this.request;
        }
    }
}

